/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.PruefzifferVerfahren;
import de.jfachwert.bank.BLZ;
import de.jfachwert.bank.IBAN;
import de.jfachwert.bank.Kontonummer;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.Mod97Verfahren;
import de.jfachwert.pruefung.NullValidator;
import java.io.Serializable;
import java.util.Locale;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 \u001a2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u001a\u001bB\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0018\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\r\u00a8\u0006\u001c"}, d2={"Lde/jfachwert/bank/IBAN;", "Lde/jfachwert/AbstractFachwert;", "", "iban", "pzVerfahren", "Lde/jfachwert/KSimpleValidator;", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "bLZ", "Lde/jfachwert/bank/BLZ;", "getBLZ", "()Lde/jfachwert/bank/BLZ;", "formatted", "getFormatted", "()Ljava/lang/String;", "kontonummer", "Lde/jfachwert/bank/Kontonummer;", "getKontonummer", "()Lde/jfachwert/bank/Kontonummer;", "land", "Ljava/util/Locale;", "getLand", "()Ljava/util/Locale;", "pruefziffer", "getPruefziffer", "unformatted", "getUnformatted", "Companion", "Validator", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nIBAN.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IBAN.kt\nde/jfachwert/bank/IBAN\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,197:1\n107#2:198\n79#2,22:199\n*S KotlinDebug\n*F\n+ 1 IBAN.kt\nde/jfachwert/bank/IBAN\n*L\n65#1:198\n65#1:199,22\n*E\n"})
public class IBAN
extends AbstractFachwert<String, IBAN> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final PruefzifferVerfahren<String> MOD97 = Mod97Verfahren.Companion.getInstance();
    @NotNull
    private static final WeakHashMap<String, IBAN> WEAK_CACHE = new WeakHashMap();
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new Validator();
    @JvmField
    @NotNull
    public static final IBAN UNBEKANNT = new IBAN("DE07123412341234123412", null, 2, null);
    @JvmField
    @NotNull
    public static final IBAN NULL = new IBAN("", new NullValidator());

    @JvmOverloads
    public IBAN(@NotNull String iban, @NotNull KSimpleValidator<String> pzVerfahren) {
        Intrinsics.checkNotNullParameter((Object)iban, (String)"iban");
        Intrinsics.checkNotNullParameter(pzVerfahren, (String)"pzVerfahren");
        super((Serializable)((Object)iban), pzVerfahren);
    }

    public /* synthetic */ IBAN(String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(string, kSimpleValidator);
    }

    @NotNull
    public final String getFormatted() {
        String input = this.getUnformatted() + "   ";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.getUnformatted().length(); i += 4) {
            buf.append(input, i, i + 4);
            buf.append(' ');
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @NotNull
    public final String getUnformatted() {
        return (String)this.getCode();
    }

    @NotNull
    public final Locale getLand() {
        String string = this.getUnformatted().substring(0, 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String country = string;
        String string2 = country.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String language = string2;
        String string3 = country;
        if (Intrinsics.areEqual((Object)string3, (Object)"AT") ? true : Intrinsics.areEqual((Object)string3, (Object)"CH")) {
            language = "de";
        }
        return new Locale(language, country);
    }

    @NotNull
    public final String getPruefziffer() {
        return MOD97.getPruefziffer((String)((Object)((Serializable)((Object)this.getUnformatted()))));
    }

    @NotNull
    public final BLZ getBLZ() {
        String iban = this.getUnformatted();
        String string = iban.substring(4, 12);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return new BLZ(string, null, 2, null);
    }

    @NotNull
    public final Kontonummer getKontonummer() {
        String iban = this.getUnformatted();
        String string = iban.substring(12);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return new Kontonummer(string);
    }

    @JvmOverloads
    public IBAN(@NotNull String iban) {
        Intrinsics.checkNotNullParameter((Object)iban, (String)"iban");
        this(iban, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final IBAN of(@NotNull String code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final String validate(@NotNull String iban) {
        return Companion.validate(iban);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/jfachwert/bank/IBAN$Companion;", "", "()V", "MOD97", "Lde/jfachwert/PruefzifferVerfahren;", "", "NULL", "Lde/jfachwert/bank/IBAN;", "UNBEKANNT", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "of", "code", "validate", "iban", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IBAN of(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            IBAN iBAN = WEAK_CACHE.computeIfAbsent(code, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)iBAN, (String)"computeIfAbsent(...)");
            return iBAN;
        }

        @JvmStatic
        @NotNull
        public final String validate(@NotNull String iban) {
            Intrinsics.checkNotNullParameter((Object)iban, (String)"iban");
            return (String)((Object)VALIDATOR.validate((Serializable)((Object)iban)));
        }

        private static final IBAN of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (IBAN)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\u0006"}, d2={"Lde/jfachwert/bank/IBAN$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "()V", "validate", "value", "jfachwert"})
    public static final class Validator
    implements KSimpleValidator<String> {
        @Override
        @NotNull
        public String validate(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = StringUtils.remove((String)value, (char)' ');
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remove(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String normalized = string2;
            LengthValidator.Companion.validate(normalized, 16, 34);
            String string3 = normalized.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            switch (string3) {
                case "AT": {
                    LengthValidator.Companion.validate(normalized, 20);
                    break;
                }
                case "CH": {
                    LengthValidator.Companion.validate(normalized, 21);
                    break;
                }
                case "DE": {
                    LengthValidator.Companion.validate(normalized, 22);
                }
            }
            return (String)((Object)MOD97.validate((Serializable)((Object)normalized)));
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public String verify(@NotNull String value) {
            return (String)((Object)KSimpleValidator.DefaultImpls.verify(this, (Serializable)((Object)value)));
        }
    }
}

