/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.bank.Kontonummer;
import de.jfachwert.pruefung.exception.InvalidLengthException;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \n2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\n\u000bB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Lde/jfachwert/bank/Kontonummer;", "Lde/jfachwert/AbstractFachwert;", "", "nr", "", "(Ljava/lang/String;)V", "validator", "Lde/jfachwert/KSimpleValidator;", "(JLde/jfachwert/KSimpleValidator;)V", "toString", "Companion", "Validator", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nKontonummer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Kontonummer.kt\nde/jfachwert/bank/Kontonummer\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,148:1\n107#2:149\n79#2,22:150\n*S KotlinDebug\n*F\n+ 1 Kontonummer.kt\nde/jfachwert/bank/Kontonummer\n*L\n49#1:149\n49#1:150,22\n*E\n"})
public class Kontonummer
extends AbstractFachwert<Long, Kontonummer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final WeakHashMap<Long, Kontonummer> WEAK_CACHE = new WeakHashMap();
    @NotNull
    private static final Validator VALIDATOR = new Validator();

    @JvmOverloads
    public Kontonummer(long nr, @NotNull KSimpleValidator<Long> validator) {
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        super(nr, validator);
    }

    public /* synthetic */ Kontonummer(long l, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(l, kSimpleValidator);
    }

    /*
     * WARNING - void declaration
     */
    public Kontonummer(@NotNull String nr) {
        void $this$trim$iv;
        Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
        String string = nr;
        Kontonummer kontonummer = this;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        kontonummer(Long.parseLong(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), null, 2, null);
    }

    @Override
    @NotNull
    public String toString() {
        String string = "%010d";
        Object[] objectArray = new Object[]{this.getCode()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @JvmOverloads
    public Kontonummer(long nr) {
        this(nr, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Kontonummer of(@NotNull String code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final String validate(@NotNull String kontonr) {
        return Companion.validate(kontonr);
    }

    @JvmStatic
    public static final long validate(long kontonr) {
        return Companion.validate(kontonr);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/jfachwert/bank/Kontonummer$Companion;", "", "()V", "VALIDATOR", "Lde/jfachwert/bank/Kontonummer$Validator;", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "", "Lde/jfachwert/bank/Kontonummer;", "of", "nr", "code", "", "validate", "kontonr", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Kontonummer of(long nr) {
            Kontonummer kontonummer = WEAK_CACHE.computeIfAbsent(nr, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)kontonummer, (String)"computeIfAbsent(...)");
            return kontonummer;
        }

        @JvmStatic
        @NotNull
        public final Kontonummer of(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return this.of(Long.parseLong(code));
        }

        @JvmStatic
        @NotNull
        public final String validate(@NotNull String kontonr) {
            Intrinsics.checkNotNullParameter((Object)kontonr, (String)"kontonr");
            return VALIDATOR.validate(kontonr);
        }

        @JvmStatic
        public final long validate(long kontonr) {
            return VALIDATOR.validate(kontonr);
        }

        private static final Kontonummer of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Kontonummer)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lde/jfachwert/bank/Kontonummer$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "()V", "validate", "kontonr", "(J)Ljava/lang/Long;", "", "jfachwert"})
    public static final class Validator
    implements KSimpleValidator<Long> {
        @Override
        @NotNull
        public Long validate(long kontonr) {
            if (kontonr < 1L) {
                throw new InvalidValueException(Long.valueOf(kontonr), "account_number");
            }
            if (kontonr > 9999999999L) {
                String string = Long.toString(kontonr);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                throw new InvalidLengthException(string, 1, 10);
            }
            return kontonr;
        }

        @Override
        @NotNull
        public final String validate(@NotNull String kontonr) {
            Intrinsics.checkNotNullParameter((Object)kontonr, (String)"kontonr");
            String normalized = StringUtils.trimToEmpty((String)kontonr);
            try {
                Long l = Long.valueOf(normalized);
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(...)");
                this.validate(((Number)l).longValue());
            }
            catch (NumberFormatException nfe) {
                throw new InvalidValueException((Serializable)((Object)kontonr), "account_number", nfe);
            }
            Intrinsics.checkNotNull((Object)normalized);
            return normalized;
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public Long verify(long value) {
            return (Long)KSimpleValidator.DefaultImpls.verify(this, value);
        }
    }
}

