/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank.internal;

import de.jfachwert.bank.Waehrung;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyQuery;
import javax.money.CurrencyQueryBuilder;
import javax.money.CurrencyUnit;
import javax.money.UnknownCurrencyException;
import javax.money.spi.Bootstrap;
import javax.money.spi.CurrencyProviderSpi;
import javax.money.spi.MonetaryCurrenciesSingletonSpi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J-\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\u000f\"\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/jfachwert/bank/internal/WaehrungenSingleton;", "Ljavax/money/spi/MonetaryCurrenciesSingletonSpi;", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getCurrencies", "", "Ljavax/money/CurrencyUnit;", "query", "Ljavax/money/CurrencyQuery;", "getCurrency", "currencyCode", "", "providers", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljavax/money/CurrencyUnit;", "getDefaultProviderChain", "", "getProviderNames", "jfachwert"})
public final class WaehrungenSingleton
implements MonetaryCurrenciesSingletonSpi {
    private final Logger log = Logger.getLogger(WaehrungenSingleton.class.getName());

    @NotNull
    public List<String> getDefaultProviderChain() {
        return new ArrayList(this.getProviderNames());
    }

    @NotNull
    public Set<String> getProviderNames() {
        Set result = new HashSet();
        for (CurrencyProviderSpi spi : Bootstrap.getServices(CurrencyProviderSpi.class)) {
            String string = spi.getProviderName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProviderName(...)");
            result.add(string);
        }
        return result;
    }

    @NotNull
    public Set<CurrencyUnit> getCurrencies(@NotNull CurrencyQuery query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Set result = new HashSet();
        for (Locale locale : query.getCountries()) {
            try {
                Currency currency = Currency.getInstance(locale);
                Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"getInstance(...)");
                result.add(Waehrung.Companion.of(currency));
            }
            catch (Exception ex) {
                this.log.log(Level.FINE, "Kann Waehrung fuer Locale '" + locale + "' nicht ermitteln.");
                this.log.log(Level.FINER, "Details:", ex);
            }
        }
        for (String currencyCode : query.getCurrencyCodes()) {
            try {
                Intrinsics.checkNotNull((Object)currencyCode);
                result.add(Waehrung.Companion.of(currencyCode));
            }
            catch (Exception ex) {
                this.log.log(Level.FINE, "Kann Waehrung '" + currencyCode + "' nicht ermitteln.");
                this.log.log(Level.FINER, "Details:", ex);
            }
        }
        for (CurrencyProviderSpi spi : Bootstrap.getServices(CurrencyProviderSpi.class)) {
            Set set = spi.getCurrencies(query);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getCurrencies(...)");
            result.addAll(set);
        }
        return result;
    }

    @NotNull
    public CurrencyUnit getCurrency(@NotNull String currencyCode, String ... providers) {
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        String[] stringArray = new String[]{currencyCode};
        CurrencyQuery currencyQuery = ((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCurrencyCodes(stringArray).setProviderNames(Arrays.copyOf(providers, providers.length))).build();
        Intrinsics.checkNotNullExpressionValue((Object)currencyQuery, (String)"build(...)");
        Collection found = this.getCurrencies(currencyQuery);
        if (found.isEmpty()) {
            throw new UnknownCurrencyException(currencyCode);
        }
        if (found.size() > 1) {
            this.log.fine(found + " found for " + currencyCode + " - using first one.");
        }
        return (CurrencyUnit)found.iterator().next();
    }
}

