/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.jfachwert.math.internal.ToNumberSerializer;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@JsonSerialize(using=ToNumberSerializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\b'\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lde/jfachwert/math/AbstractNumber;", "", "", "()V", "compareTo", "", "other", "toBigDecimal", "Ljava/math/BigDecimal;", "toByte", "", "toChar", "", "toDouble", "", "toFloat", "", "toInt", "toLong", "", "toShort", "", "jfachwert"})
public abstract class AbstractNumber
extends Number
implements Comparable<AbstractNumber> {
    @NotNull
    public abstract BigDecimal toBigDecimal();

    public int toInt() {
        return this.toBigDecimal().intValue();
    }

    public long toLong() {
        return this.toBigDecimal().longValue();
    }

    public float toFloat() {
        return this.toBigDecimal().floatValue();
    }

    public double toDouble() {
        return this.toBigDecimal().doubleValue();
    }

    public byte toByte() {
        return this.toBigDecimal().byteValue();
    }

    public char toChar() {
        return (char)this.intValue();
    }

    public short toShort() {
        return this.toBigDecimal().shortValue();
    }

    @Override
    public int compareTo(@NotNull AbstractNumber other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.toBigDecimal().compareTo(other.toBigDecimal());
    }
}

