/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import de.jfachwert.KFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.math.AbstractNumber;
import de.jfachwert.math.PackedDecimal;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0002\u0017\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\r\u0012\u0006\u0010\u0003\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/jfachwert/math/Nummer;", "Lde/jfachwert/math/AbstractNumber;", "Lde/jfachwert/KFachwert;", "code", "", "(I)V", "", "(J)V", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "", "(Ljava/lang/String;)V", "Lde/jfachwert/math/PackedDecimal;", "equals", "", "other", "", "hashCode", "toBigDecimal", "Ljava/math/BigDecimal;", "toInt", "toLong", "toString", "Companion", "Validator", "jfachwert"})
public class Nummer
extends AbstractNumber
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PackedDecimal code;
    @NotNull
    private static final Nummer[] CACHE = new Nummer[11];
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new Validator();
    @NotNull
    private static final Nummer NULL = new Nummer("");

    public Nummer(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.code = PackedDecimal.Companion.valueOf(code);
    }

    public Nummer(int code) {
        BigInteger bigInteger = BigInteger.valueOf(code);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(bigInteger);
    }

    public Nummer(long code) {
        BigInteger bigInteger = BigInteger.valueOf(code);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(bigInteger);
    }

    public Nummer(@NotNull BigInteger code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        String string = code.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this(string);
    }

    @Override
    @NotNull
    public BigDecimal toBigDecimal() {
        return this.code.toBigDecimal();
    }

    @Override
    public int toInt() {
        return this.code.intValue();
    }

    @Override
    public long toLong() {
        return this.code.longValue();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Nummer)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.toString(), (Object)((Nummer)other).toString());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.code};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return this.code.toString();
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap(this);
    }

    @Override
    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid(this);
    }

    @NotNull
    public static final Nummer getNULL() {
        return Companion.getNULL();
    }

    @JvmStatic
    @NotNull
    public static final Nummer of(long code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final Nummer of(@NotNull String code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final Nummer of(@NotNull BigInteger code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final Nummer of(@NotNull Nummer other) {
        return Companion.of(other);
    }

    @JvmStatic
    @NotNull
    public static final String validate(@NotNull String nummer) {
        return Companion.validate(nummer);
    }

    static {
        int n = CACHE.length;
        for (int i = 0; i < n; ++i) {
            Nummer.CACHE[i] = new Nummer(i);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0012H\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\rH\u0007J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0007R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001c\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/jfachwert/math/Nummer$Companion;", "", "()V", "CACHE", "", "Lde/jfachwert/math/Nummer;", "[Lde/jfachwert/math/Nummer;", "NULL", "getNULL$annotations", "getNULL", "()Lde/jfachwert/math/Nummer;", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "of", "other", "code", "Ljava/math/BigInteger;", "", "validate", "nummer", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Nummer getNULL() {
            return NULL;
        }

        @JvmStatic
        public static /* synthetic */ void getNULL$annotations() {
        }

        @JvmStatic
        @NotNull
        public final Nummer of(long code) {
            Nummer nummer;
            if (code >= 0L && code < (long)CACHE.length) {
                Nummer nummer2 = CACHE[(int)code];
                nummer = nummer2;
                Intrinsics.checkNotNull((Object)nummer2);
            } else {
                nummer = new Nummer(code);
            }
            return nummer;
        }

        @JvmStatic
        @NotNull
        public final Nummer of(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return this.of(new Nummer(code));
        }

        @JvmStatic
        @NotNull
        public final Nummer of(@NotNull BigInteger code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return this.of(code.longValue());
        }

        @JvmStatic
        @NotNull
        public final Nummer of(@NotNull Nummer other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.of(other.longValue());
        }

        @JvmStatic
        @NotNull
        public final String validate(@NotNull String nummer) {
            Intrinsics.checkNotNullParameter((Object)nummer, (String)"nummer");
            return (String)((Object)VALIDATOR.validate((Serializable)((Object)nummer)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\u0006"}, d2={"Lde/jfachwert/math/Nummer$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "()V", "validate", "value", "jfachwert"})
    public static final class Validator
    implements KSimpleValidator<String> {
        @Override
        @NotNull
        public String validate(@NotNull String value) {
            String string;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                string = new BigInteger(value).toString();
                Intrinsics.checkNotNull((Object)string);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidValueException((Serializable)((Object)value), "number");
            }
            return string;
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public String verify(@NotNull String value) {
            return (String)((Object)KSimpleValidator.DefaultImpls.verify(this, (Serializable)((Object)value)));
        }
    }
}

