/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.bank.Geldbetrag;
import de.jfachwert.math.AbstractNumber;
import de.jfachwert.math.Prozent;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\u0003\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lde/jfachwert/math/Prozent;", "Lde/jfachwert/math/AbstractNumber;", "Lde/jfachwert/KFachwert;", "wert", "", "(Ljava/lang/String;)V", "", "(J)V", "Ljava/math/BigDecimal;", "(Ljava/math/BigDecimal;)V", "getWert", "()Ljava/math/BigDecimal;", "equals", "", "other", "", "hashCode", "", "multiply", "x", "Ljavax/money/MonetaryAmount;", "geldbetrag", "toBigDecimal", "toString", "Companion", "jfachwert"})
public class Prozent
extends AbstractNumber
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigDecimal wert;
    private static final Logger log = Logger.getLogger(Prozent.class.getName());
    @NotNull
    private static final WeakHashMap<BigDecimal, Prozent> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Prozent ZERO;
    @JvmField
    @NotNull
    public static final Prozent ONE;
    @JvmField
    @NotNull
    public static final Prozent TEN;

    public Prozent(@NotNull BigDecimal wert) {
        Intrinsics.checkNotNullParameter((Object)wert, (String)"wert");
        this.wert = wert;
    }

    @NotNull
    public final BigDecimal getWert() {
        return this.wert;
    }

    public Prozent(@NotNull String wert) {
        Intrinsics.checkNotNullParameter((Object)wert, (String)"wert");
        this(Prozent.Companion.toNumber(wert));
    }

    public Prozent(long wert) {
        BigDecimal bigDecimal = BigDecimal.valueOf(wert);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        this(bigDecimal);
    }

    @Override
    @NotNull
    public BigDecimal toBigDecimal() {
        BigDecimal bigDecimal = this.wert.divide(BigDecimal.valueOf(100L));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"divide(...)");
        return bigDecimal;
    }

    @NotNull
    public final BigDecimal multiply(@NotNull BigDecimal x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        BigDecimal bigDecimal = x.multiply(this.toBigDecimal());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"multiply(...)");
        return bigDecimal;
    }

    @NotNull
    public final MonetaryAmount multiply(@NotNull MonetaryAmount geldbetrag) {
        Intrinsics.checkNotNullParameter((Object)geldbetrag, (String)"geldbetrag");
        Number number = geldbetrag.getNumber().numberValue(BigDecimal.class);
        Intrinsics.checkNotNullExpressionValue((Object)number, (String)"numberValue(...)");
        BigDecimal zins = this.multiply((BigDecimal)number);
        Number number2 = zins;
        CurrencyUnit currencyUnit = geldbetrag.getCurrency();
        Intrinsics.checkNotNullExpressionValue((Object)currencyUnit, (String)"getCurrency(...)");
        return Geldbetrag.Companion.of(number2, currencyUnit);
    }

    @NotNull
    public final BigDecimal multiply(long x) {
        BigDecimal bigDecimal = BigDecimal.valueOf(x);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return this.multiply(bigDecimal);
    }

    @NotNull
    public String toString() {
        return this.wert.toString() + '%';
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Prozent)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.wert, (Object)((Prozent)other).wert);
    }

    public int hashCode() {
        return this.wert.hashCode();
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap(this);
    }

    @Override
    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid(this);
    }

    @JvmStatic
    @NotNull
    public static final Prozent of(@NotNull String wert) {
        return Companion.of(wert);
    }

    @JvmStatic
    @NotNull
    public static final Prozent of(long wert) {
        return Companion.of(wert);
    }

    @JvmStatic
    @NotNull
    public static final Prozent of(@NotNull BigDecimal wert) {
        return Companion.of(wert);
    }

    static {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        ZERO = Companion.of(bigDecimal);
        BigDecimal bigDecimal2 = BigDecimal.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"ONE");
        ONE = Companion.of(bigDecimal2);
        BigDecimal bigDecimal3 = BigDecimal.TEN;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"TEN");
        TEN = Companion.of(bigDecimal3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0010H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/jfachwert/math/Prozent$Companion;", "", "()V", "ONE", "Lde/jfachwert/math/Prozent;", "TEN", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Ljava/math/BigDecimal;", "ZERO", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "of", "wert", "", "", "toNumber", "jfachwert"})
    @SourceDebugExtension(value={"SMAP\nProzent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Prozent.kt\nde/jfachwert/math/Prozent$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,189:1\n37#2,2:190\n107#3:192\n79#3,22:193\n*S KotlinDebug\n*F\n+ 1 Prozent.kt\nde/jfachwert/math/Prozent$Companion\n*L\n138#1:190,2\n138#1:192\n138#1:193,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final BigDecimal toNumber(String wert) {
            Object object = new String[]{"%"};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)wert, (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String $this$trim$iv = thisCollection$iv.toArray(new String[0])[0];
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String number = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            try {
                object = new BigDecimal(number);
            }
            catch (NumberFormatException ex) {
                log.log(Level.FINE, number + " ist keine normale Nummer.");
                log.log(Level.FINER, "Details:", ex);
                object = new BigDecimal(StringsKt.replace$default((String)number, (char)',', (char)'.', (boolean)false, (int)4, null));
            }
            return object;
        }

        @JvmStatic
        @NotNull
        public final Prozent of(@NotNull String wert) {
            Intrinsics.checkNotNullParameter((Object)wert, (String)"wert");
            return this.of(this.toNumber(wert));
        }

        @JvmStatic
        @NotNull
        public final Prozent of(long wert) {
            BigDecimal bigDecimal = BigDecimal.valueOf(wert);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            return this.of(bigDecimal);
        }

        @JvmStatic
        @NotNull
        public final Prozent of(@NotNull BigDecimal wert) {
            Intrinsics.checkNotNullParameter((Object)wert, (String)"wert");
            Prozent prozent = WEAK_CACHE.computeIfAbsent(wert, arg_0 -> Companion.of$lambda$1(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)prozent, (String)"computeIfAbsent(...)");
            return prozent;
        }

        private static final Prozent of$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Prozent)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

