/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.med;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.PruefzifferVerfahren;
import de.jfachwert.med.PZN;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.NullValidator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u0000 \f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0003\f\r\u000eB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016\u00a8\u0006\u000f"}, d2={"Lde/jfachwert/med/PZN;", "Lde/jfachwert/AbstractFachwert;", "", "code", "", "(Ljava/lang/String;)V", "validator", "Lde/jfachwert/KSimpleValidator;", "(ILde/jfachwert/KSimpleValidator;)V", "isValid", "", "toString", "Companion", "Mod11Verfahren", "Validator", "jfachwert"})
public class PZN
extends AbstractFachwert<Integer, PZN> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final WeakHashMap<Integer, PZN> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Validator VALIDATOR = new Validator();
    @JvmField
    @NotNull
    public static final PZN NULL = new PZN(0, new NullValidator());

    @JvmOverloads
    public PZN(int code, @NotNull KSimpleValidator<Integer> validator) {
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        super(code, validator);
    }

    public /* synthetic */ PZN(int n, KSimpleValidator kSimpleValidator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(n, kSimpleValidator);
    }

    public PZN(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this(PZN.Companion.toInt(code), null, 2, null);
    }

    @Override
    public boolean isValid() {
        return VALIDATOR.isVald(this.getCode());
    }

    @Override
    @NotNull
    public String toString() {
        String string = "PZN-%08d";
        Object[] objectArray = new Object[]{this.getCode()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @JvmOverloads
    public PZN(int code) {
        this(code, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final PZN of(int code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final PZN of(@NotNull String code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final PZN of(@NotNull String code, @NotNull KSimpleValidator<Integer> validator) {
        return Companion.of(code, validator);
    }

    @JvmStatic
    @NotNull
    public static final PZN of(int code, @NotNull KSimpleValidator<Integer> validator) {
        return Companion.of(code, validator);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u000eH\u0007J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0007J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/jfachwert/med/PZN$Companion;", "", "()V", "NULL", "Lde/jfachwert/med/PZN;", "VALIDATOR", "Lde/jfachwert/med/PZN$Validator;", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "", "of", "code", "validator", "Lde/jfachwert/KSimpleValidator;", "", "toInt", "s", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PZN of(int code) {
            PZN pZN = WEAK_CACHE.computeIfAbsent(code, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)pZN, (String)"computeIfAbsent(...)");
            return pZN;
        }

        @JvmStatic
        @NotNull
        public final PZN of(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return this.of(this.toInt(code));
        }

        @JvmStatic
        @NotNull
        public final PZN of(@NotNull String code, @NotNull KSimpleValidator<Integer> validator) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter(validator, (String)"validator");
            return this.of(this.toInt(code), validator);
        }

        @JvmStatic
        @NotNull
        public final PZN of(int code, @NotNull KSimpleValidator<Integer> validator) {
            Intrinsics.checkNotNullParameter(validator, (String)"validator");
            return new PZN(code, validator);
        }

        private final int toInt(String s2) {
            return Integer.parseInt(StringsKt.replace((String)s2, (String)"PZN-", (String)"", (boolean)true));
        }

        private static final PZN of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (PZN)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0002H\u0002\u00a8\u0006\t"}, d2={"Lde/jfachwert/med/PZN$Mod11Verfahren;", "Lde/jfachwert/PruefzifferVerfahren;", "", "()V", "berechnePruefziffer", "wert", "getPruefziffer", "getQuersumme", "", "jfachwert"})
    public static final class Mod11Verfahren
    implements PruefzifferVerfahren<String> {
        @Override
        @NotNull
        public String getPruefziffer(@NotNull String wert) {
            Intrinsics.checkNotNullParameter((Object)wert, (String)"wert");
            return String.valueOf(StringsKt.last((CharSequence)wert));
        }

        @Override
        @NotNull
        public String berechnePruefziffer(@NotNull String wert) {
            Intrinsics.checkNotNullParameter((Object)wert, (String)"wert");
            int sum = this.getQuersumme(wert);
            String string = Integer.toString(sum % 11 % 10);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final int getQuersumme(String wert) {
            char[] cArray = wert.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            char[] digits = cArray;
            int sum = 0;
            int length = digits.length - 1;
            int anfangsWichtung = 8 - length;
            for (int i = 0; i < length; ++i) {
                int digit = Character.digit(digits[i], 10);
                sum += digit * (anfangsWichtung + i);
            }
            return sum;
        }

        @Override
        public boolean isValid(@NotNull String wert) {
            return PruefzifferVerfahren.DefaultImpls.isValid(this, (Serializable)((Object)wert));
        }

        @Override
        @NotNull
        public String validate(@NotNull String value) {
            return (String)((Object)PruefzifferVerfahren.DefaultImpls.validate(this, (Serializable)((Object)value)));
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return PruefzifferVerfahren.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public String verify(@NotNull String value) {
            return (String)((Object)PruefzifferVerfahren.DefaultImpls.verify(this, (Serializable)((Object)value)));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"Lde/jfachwert/med/PZN$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "()V", "validate", "value", "(I)Ljava/lang/Integer;", "Companion", "jfachwert"})
    public static final class Validator
    implements KSimpleValidator<Integer> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final PruefzifferVerfahren<String> MOD11 = new Mod11Verfahren();
        @NotNull
        private static final LengthValidator<Integer> VALIDATOR8 = new LengthValidator(2, 8);

        @Override
        @NotNull
        public Integer validate(int value) {
            int n = ((Number)VALIDATOR8.validate((Integer)((Serializable)Integer.valueOf(value)))).intValue();
            String string = Integer.toString(n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            MOD11.validate((String)((Object)((Serializable)((Object)string))));
            return n;
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public Integer verify(int value) {
            return (Integer)KSimpleValidator.DefaultImpls.verify(this, value);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/jfachwert/med/PZN$Validator$Companion;", "", "()V", "MOD11", "Lde/jfachwert/PruefzifferVerfahren;", "", "VALIDATOR8", "Lde/jfachwert/pruefung/LengthValidator;", "", "jfachwert"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

