/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.med;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.med.Versichertennummer;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.LuhnVerfahren;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \t2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\t\nB\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lde/jfachwert/med/Versichertennummer;", "Lde/jfachwert/AbstractFachwert;", "", "code", "pzVerfahren", "Lde/jfachwert/KSimpleValidator;", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "isValid", "", "Companion", "Validator", "jfachwert"})
public class Versichertennummer
extends AbstractFachwert<String, Versichertennummer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final WeakHashMap<String, Versichertennummer> WEAK_CACHE = new WeakHashMap();
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new Validator();
    @JvmField
    @NotNull
    public static final Versichertennummer NULL = new Versichertennummer("", new NullValidator());

    @JvmOverloads
    public Versichertennummer(@NotNull String code, @NotNull KSimpleValidator<String> pzVerfahren) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(pzVerfahren, (String)"pzVerfahren");
        super((Serializable)((Object)code), pzVerfahren);
    }

    public /* synthetic */ Versichertennummer(String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(string, kSimpleValidator);
    }

    @Override
    public boolean isValid() {
        return VALIDATOR.isVald((String)this.getCode());
    }

    @JvmOverloads
    public Versichertennummer(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this(code, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Versichertennummer of(@NotNull String code) {
        return Companion.of(code);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0007H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/jfachwert/med/Versichertennummer$Companion;", "", "()V", "NULL", "Lde/jfachwert/med/Versichertennummer;", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "of", "code", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Versichertennummer of(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Versichertennummer versichertennummer = WEAK_CACHE.computeIfAbsent(code, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)versichertennummer, (String)"computeIfAbsent(...)");
            return versichertennummer;
        }

        private static final Versichertennummer of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Versichertennummer)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\u0006"}, d2={"Lde/jfachwert/med/Versichertennummer$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "()V", "validate", "value", "jfachwert"})
    public static final class Validator
    implements KSimpleValidator<String> {
        @Override
        @NotNull
        public String validate(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String normalized = ((Object)StringsKt.trim((CharSequence)value)).toString();
            LengthValidator.Companion.validate(normalized, 10);
            Regex regex = new Regex("[A-Z]\\d{9}");
            if (!regex.matches((CharSequence)normalized)) {
                throw new InvalidValueException((Serializable)((Object)normalized), "policy_number", regex);
            }
            new LuhnVerfahren().validate(normalized);
            return normalized;
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public String verify(@NotNull String value) {
            return (String)((Object)KSimpleValidator.DefaultImpls.verify(this, (Serializable)((Object)value)));
        }
    }
}

