/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.net;

import de.jfachwert.KSimpleValidator;
import de.jfachwert.Text;
import de.jfachwert.net.Domainname;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0007\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lde/jfachwert/net/Domainname;", "Lde/jfachwert/Text;", "name", "", "validator", "Lde/jfachwert/KSimpleValidator;", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "tLD", "getTLD", "()Lde/jfachwert/net/Domainname;", "getLevelDomain", "level", "", "Companion", "Validator", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nDomainname.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Domainname.kt\nde/jfachwert/net/Domainname\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,141:1\n107#2:142\n79#2,22:143\n37#3,2:165\n*S KotlinDebug\n*F\n+ 1 Domainname.kt\nde/jfachwert/net/Domainname\n*L\n47#1:142\n47#1:143,22\n66#1:165,2\n*E\n"})
public class Domainname
extends Text {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final WeakHashMap<String, Domainname> WEAK_CACHE = new WeakHashMap();
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new Validator();

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public Domainname(@NotNull String name, @NotNull KSimpleValidator<String> validator) {
        void $this$trim$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        String string = name;
        Domainname domainname = this;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        super(string2, validator);
    }

    public /* synthetic */ Domainname(String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(string, kSimpleValidator);
    }

    @NotNull
    public final Domainname getTLD() {
        String string = StringUtils.substringAfterLast((String)((String)this.getCode()), (String)".");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substringAfterLast(...)");
        return new Domainname(string, null, 2, null);
    }

    @NotNull
    public final Domainname getLevelDomain(int level) {
        String[] stringArray = new String[]{"."};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((CharSequence)this.getCode()), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        int firstPart = parts.length - level;
        if (firstPart < 0 || level < 1) {
            throw new LocalizedIllegalArgumentException((Serializable)Integer.valueOf(level), "level", Range.of((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(parts.length)));
        }
        StringBuilder name = new StringBuilder(parts[firstPart]);
        int n = parts.length;
        for (int i = firstPart + 1; i < n; ++i) {
            name.append('.');
            name.append(parts[i]);
        }
        String string = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new Domainname(string, null, 2, null);
    }

    @JvmOverloads
    public Domainname(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Domainname of(@NotNull String name) {
        return Companion.of(name);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/jfachwert/net/Domainname$Companion;", "", "()V", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lde/jfachwert/net/Domainname;", "of", "name", "validate", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Domainname of(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Domainname domainname = WEAK_CACHE.computeIfAbsent(name, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)domainname, (String)"computeIfAbsent(...)");
            return domainname;
        }

        @NotNull
        public final String validate(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return (String)((Object)VALIDATOR.validate((Serializable)((Object)name)));
        }

        private static final Domainname of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Domainname)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lde/jfachwert/net/Domainname$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "()V", "validate", "value", "Companion", "jfachwert"})
    public static final class Validator
    implements KSimpleValidator<String> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private static final Pattern VALID_PATTERN = Pattern.compile("^(?=.{1,253}\\.?$)(?:(?!-|[^.]+_)[A-Za-z0-9-_]{1,63}(?<!-)(?:\\.|$))+$");

        @Override
        @NotNull
        public String validate(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (VALID_PATTERN.matcher(value).matches()) {
                return value;
            }
            throw new InvalidValueException((Serializable)((Object)value), "name");
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public String verify(@NotNull String value) {
            return (String)((Object)KSimpleValidator.DefaultImpls.verify(this, (Serializable)((Object)value)));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/jfachwert/net/Domainname$Validator$Companion;", "", "()V", "VALID_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "jfachwert"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

