/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import de.jfachwert.KSimpleValidator;
import de.jfachwert.Text;
import de.jfachwert.post.PLZ;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.NumberValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lde/jfachwert/post/PLZ;", "Lde/jfachwert/Text;", "plz", "", "(Ljava/lang/String;)V", "validator", "Lde/jfachwert/KSimpleValidator;", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "landeskennung", "(Ljava/lang/String;Ljava/lang/String;)V", "land", "Ljava/util/Locale;", "(Ljava/util/Locale;Ljava/lang/String;)V", "getLand", "()Ljava/util/Locale;", "getLandeskennung", "()Ljava/lang/String;", "postleitZahl", "getPostleitZahl", "hasLandeskennung", "", "toLongString", "toShortString", "toString", "Companion", "Validator", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nPLZ.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PLZ.kt\nde/jfachwert/post/PLZ\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1#2:286\n*E\n"})
public class PLZ
extends Text {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new Validator();
    @NotNull
    private static final WeakHashMap<String, PLZ> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final PLZ NULL = new PLZ("00000", new NullValidator());

    public PLZ(@NotNull String plz) {
        Intrinsics.checkNotNullParameter((Object)plz, (String)"plz");
        super(plz, VALIDATOR);
    }

    public PLZ(@NotNull String plz, @NotNull KSimpleValidator<String> validator) {
        Intrinsics.checkNotNullParameter((Object)plz, (String)"plz");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        super(plz, validator);
    }

    public PLZ(@NotNull String landeskennung, @NotNull String plz) {
        Intrinsics.checkNotNullParameter((Object)landeskennung, (String)"landeskennung");
        Intrinsics.checkNotNullParameter((Object)plz, (String)"plz");
        this(landeskennung + plz);
    }

    public PLZ(@NotNull Locale land, @NotNull String plz) {
        Intrinsics.checkNotNullParameter((Object)land, (String)"land");
        Intrinsics.checkNotNullParameter((Object)plz, (String)"plz");
        this(PLZ.Companion.toLandeskennung(land) + plz);
    }

    public final boolean hasLandeskennung() {
        return PLZ.Companion.hasLandeskennung((String)this.getCode());
    }

    @NotNull
    public final String getLandeskennung() {
        if (!this.hasLandeskennung()) {
            boolean bl = false;
            String string = "keine Landeskennung angegeben";
            throw new IllegalStateException(string.toString());
        }
        return PLZ.Companion.getLandeskennung((String)this.getCode());
    }

    @NotNull
    public final Locale getLand() {
        Locale locale;
        String kennung;
        switch (kennung = this.getLandeskennung()) {
            case "D": {
                locale = new Locale("de", "DE");
                break;
            }
            case "A": {
                locale = new Locale("de", "AT");
                break;
            }
            case "CH": {
                locale = new Locale("de", "CH");
                break;
            }
            default: {
                throw new UnsupportedOperationException("unbekannte Landeskennung '" + kennung + '\'');
            }
        }
        return locale;
    }

    @NotNull
    public final String getPostleitZahl() {
        return PLZ.Companion.getPostleitZahl((String)this.getCode());
    }

    @NotNull
    public final String toShortString() {
        return (String)this.getCode();
    }

    @NotNull
    public final String toLongString() {
        String plz = (String)this.getCode();
        if (this.hasLandeskennung()) {
            plz = PLZ.Companion.toLongString(plz);
        }
        return plz;
    }

    @Override
    @NotNull
    public String toString() {
        return this.toLongString();
    }

    @JvmStatic
    @NotNull
    public static final PLZ of(@NotNull String plz) {
        return Companion.of(plz);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/jfachwert/post/PLZ$Companion;", "", "()V", "NULL", "Lde/jfachwert/post/PLZ;", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "getLandeskennung", "plz", "getPostleitZahl", "hasLandeskennung", "", "of", "toLandeskennung", "locale", "Ljava/util/Locale;", "toLongString", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        private final String toLandeskennung(Locale locale) {
            String string;
            String country;
            String string2 = locale.getCountry();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCountry(...)");
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String string4 = country = string3;
            if (Intrinsics.areEqual((Object)string4, (Object)"AT") ? true : Intrinsics.areEqual((Object)string4, (Object)"DE")) {
                String string5 = country.substring(0, 1);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string = country;
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final PLZ of(@NotNull String plz) {
            Intrinsics.checkNotNullParameter((Object)plz, (String)"plz");
            PLZ pLZ = WEAK_CACHE.computeIfAbsent(plz, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)pLZ, (String)"computeIfAbsent(...)");
            return pLZ;
        }

        private final boolean hasLandeskennung(String plz) {
            char kennung = plz.charAt(0);
            return Character.isLetter(kennung);
        }

        private final String getLandeskennung(String plz) {
            String string = StringUtils.substringBefore((String)this.toLongString(plz), (String)"-");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substringBefore(...)");
            return string;
        }

        private final String getPostleitZahl(String plz) {
            String string;
            if (!this.hasLandeskennung(plz)) {
                string = plz;
            } else {
                String string2 = StringUtils.substringAfter((String)this.toLongString(plz), (String)"-");
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substringAfter(...)");
            }
            return string;
        }

        private final String toLongString(String plz) {
            int i = StringUtils.indexOfAny((CharSequence)plz, (String)"0123456789");
            if (i < 0) {
                throw new InvalidValueException((Serializable)((Object)plz), "postal_code");
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = plz.substring(0, i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            StringBuilder stringBuilder2 = stringBuilder.append(string).append('-');
            String string2 = plz.substring(i);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            return stringBuilder2.append(string2).toString();
        }

        private static final PLZ of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (PLZ)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lde/jfachwert/post/PLZ$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "()V", "validate", "value", "Companion", "jfachwert"})
    public static final class Validator
    implements KSimpleValidator<String> {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public String validate(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String plz = Validator.Companion.normalize(value);
            if (Companion.hasLandeskennung(plz)) {
                Validator.Companion.validateNumberOf(plz);
            } else if ((plz = LengthValidator.Companion.validate(plz, 3, 10)).length() == 5) {
                Validator.Companion.validateNumberDE(plz);
            }
            return plz;
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public String verify(@NotNull String value) {
            return (String)((Object)KSimpleValidator.DefaultImpls.verify(this, (Serializable)((Object)value)));
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J \u0010\t\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a8\u0006\r"}, d2={"Lde/jfachwert/post/PLZ$Validator$Companion;", "", "()V", "normalize", "", "plz", "validateNumberDE", "", "validateNumberOf", "validateNumberWith", "length", "", "zahl", "jfachwert"})
        public static final class Companion {
            private Companion() {
            }

            private final void validateNumberOf(String plz) {
                String kennung = PLZ.Companion.getLandeskennung(plz);
                String zahl = PLZ.Companion.getPostleitZahl(plz);
                switch (kennung) {
                    case "D": {
                        this.validateNumberDE(zahl);
                        this.validateNumberWith(plz, 6, zahl);
                        break;
                    }
                    case "CH": {
                        this.validateNumberWith(plz, 6, zahl);
                        break;
                    }
                    case "A": {
                        this.validateNumberWith(plz, 5, zahl);
                        break;
                    }
                    default: {
                        LengthValidator.Companion.validate(zahl, 3, 10);
                    }
                }
            }

            private final void validateNumberWith(String plz, int length, String zahl) {
                LengthValidator.Companion.validate(plz, length);
                BigDecimal bigDecimal = BigDecimal.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
                BigDecimal bigDecimal2 = BigDecimal.TEN.pow(length);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"pow(...)");
                new NumberValidator(bigDecimal, bigDecimal2).validate(zahl);
            }

            private final void validateNumberDE(String plz) {
                int n = Integer.parseInt(plz);
                if (n < 1067 || n > 99998) {
                    Serializable serializable = (Serializable)((Object)plz);
                    Range range = Range.of((Comparable)((Comparable)((Object)"01067")), (Comparable)((Comparable)((Object)"99998")));
                    Intrinsics.checkNotNullExpressionValue((Object)range, (String)"of(...)");
                    throw new InvalidValueException(serializable, "postal_code", range);
                }
            }

            private final String normalize(String plz) {
                String string = StringUtils.replaceChars((String)plz, (String)" -", (String)"");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceChars(...)");
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                return string2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

