/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung;

import de.jfachwert.PruefzifferVerfahren;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0011\b\u0017\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/jfachwert/pruefung/Mod10Verfahren;", "Lde/jfachwert/PruefzifferVerfahren;", "", "gewichtung", "", "(I)V", "gewichtungUngerade", "gewichtungGerade", "(II)V", "berechnePruefziffer", "wert", "getPruefziffer", "getQuersumme", "isValid", "", "Companion", "jfachwert"})
public class Mod10Verfahren
implements PruefzifferVerfahren<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int gewichtungUngerade;
    private final int gewichtungGerade;
    @JvmField
    @NotNull
    public static final Mod10Verfahren EAN13 = new Mod10Verfahren(1, 3);
    @JvmField
    @NotNull
    public static final Mod10Verfahren CODE25 = new Mod10Verfahren(3, 1);
    @JvmField
    @NotNull
    public static final Mod10Verfahren LEITCODE = new Mod10Verfahren(4, 9);

    public Mod10Verfahren(int gewichtungUngerade, int gewichtungGerade) {
        this.gewichtungUngerade = gewichtungUngerade;
        this.gewichtungGerade = gewichtungGerade;
    }

    @JvmOverloads
    public Mod10Verfahren(int gewichtung) {
        this(gewichtung, 1);
    }

    public /* synthetic */ Mod10Verfahren(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    @Override
    public boolean isValid(@NotNull String wert) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)wert, (String)"wert");
        if (StringUtils.length((CharSequence)wert) < 2) {
            bl = false;
        } else {
            String string = this.getPruefziffer(wert);
            String string2 = wert.substring(0, wert.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            bl = Intrinsics.areEqual((Object)string, (Object)this.berechnePruefziffer(string2));
        }
        return bl;
    }

    @Override
    @NotNull
    public String getPruefziffer(@NotNull String wert) {
        Intrinsics.checkNotNullParameter((Object)wert, (String)"wert");
        String string = wert.substring(wert.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }

    @Override
    @NotNull
    public String berechnePruefziffer(@NotNull String wert) {
        Intrinsics.checkNotNullParameter((Object)wert, (String)"wert");
        int sum = this.getQuersumme(wert);
        String string = Integer.toString((10 - sum % 10) % 10);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final int getQuersumme(String wert) {
        char[] cArray = wert.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] digits = cArray;
        int sum = 0;
        int length = digits.length;
        for (int i = 0; i < length; ++i) {
            int digit = Character.digit(digits[i], 10);
            sum += (digit *= i % 2 == 0 ? this.gewichtungUngerade : this.gewichtungGerade);
        }
        return sum;
    }

    @Override
    @NotNull
    public String validate(@NotNull String value) {
        return (String)((Object)PruefzifferVerfahren.DefaultImpls.validate(this, (Serializable)((Object)value)));
    }

    @Override
    @Nullable
    public Object validateObject(@NotNull Object value) {
        return PruefzifferVerfahren.DefaultImpls.validateObject(this, value);
    }

    @Override
    @NotNull
    public String verify(@NotNull String value) {
        return (String)((Object)PruefzifferVerfahren.DefaultImpls.verify(this, (Serializable)((Object)value)));
    }

    @JvmOverloads
    public Mod10Verfahren() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/jfachwert/pruefung/Mod10Verfahren$Companion;", "", "()V", "CODE25", "Lde/jfachwert/pruefung/Mod10Verfahren;", "EAN13", "LEITCODE", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

