/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung.exception;

import de.jfachwert.pruefung.exception.InvalidLengthException;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedException;
import java.io.Serializable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B1\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0016\u0010\n\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rB#\b\u0017\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u0017\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015B\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0016B\u0017\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0017\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0005H\u0016R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/jfachwert/pruefung/exception/LocalizedIllegalArgumentException;", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "Lde/jfachwert/pruefung/exception/LocalizedException;", "message", "", "(Ljava/lang/String;)V", "value", "Ljava/io/Serializable;", "context", "range", "Lorg/apache/commons/lang3/Range;", "", "(Ljava/io/Serializable;Ljava/lang/String;Lorg/apache/commons/lang3/Range;)V", "cause", "", "(Ljava/io/Serializable;Ljava/lang/String;Ljava/lang/Throwable;)V", "array", "", "expected", "", "([BI)V", "(Ljava/lang/Throwable;)V", "valueException", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "getLocalizedMessage", "jfachwert"})
public class LocalizedIllegalArgumentException
extends IllegalArgumentException
implements LocalizedException {
    @NotNull
    private final Throwable valueException;

    public LocalizedIllegalArgumentException(@Nullable String message, @NotNull Throwable valueException) {
        Intrinsics.checkNotNullParameter((Object)valueException, (String)"valueException");
        super(message, valueException);
        this.valueException = valueException;
    }

    public LocalizedIllegalArgumentException(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this(null, message, null, 4, null);
    }

    public LocalizedIllegalArgumentException(@Nullable Serializable value, @NotNull String context, @Nullable Range<? extends Comparable<?>> range) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Serializable serializable = value;
        Intrinsics.checkNotNull((Object)serializable);
        Range<? extends Comparable<?>> range2 = range;
        Intrinsics.checkNotNull(range2);
        this(value, context, new InvalidValueException(serializable, context, range2));
    }

    @JvmOverloads
    public LocalizedIllegalArgumentException(@Nullable Serializable value, @NotNull String context, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this("illegal value for " + StringsKt.replace$default((String)context, (char)'_', (char)' ', (boolean)false, (int)4, null) + ": \"" + value + '\"', cause);
    }

    public /* synthetic */ LocalizedIllegalArgumentException(Serializable serializable, String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Serializable serializable2 = serializable;
            Intrinsics.checkNotNull((Object)serializable2);
            throwable = new InvalidValueException(serializable2, string);
        }
        this(serializable, string, throwable);
    }

    public LocalizedIllegalArgumentException(@NotNull byte[] array, int expected) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this("array=" + Arrays.toString(array) + " has not length " + expected + " (but " + array.length + ')', new InvalidLengthException(array, expected));
    }

    public LocalizedIllegalArgumentException(@NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this(cause.getMessage(), cause);
    }

    @Override
    @NotNull
    public String getLocalizedMessage() {
        String string = this.valueException.getLocalizedMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
        return string;
    }

    @Override
    @NotNull
    public String getLocalizedMessage(@NotNull String key, Object ... args) {
        return LocalizedException.DefaultImpls.getLocalizedMessage(this, key, args);
    }

    @Override
    @NotNull
    public String getMessageKey(@NotNull String message) {
        return LocalizedException.DefaultImpls.getMessageKey(this, message);
    }

    @Override
    @NotNull
    public String getLocalizedString(@NotNull String key) {
        return LocalizedException.DefaultImpls.getLocalizedString(this, key);
    }

    @JvmOverloads
    public LocalizedIllegalArgumentException(@Nullable Serializable value, @NotNull String context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(value, context, null, 4, null);
    }
}

