/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.rechnung;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import de.jfachwert.rechnung.Rechnungsmonat;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\n\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0017\u0018\u0000 82\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u00018B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0012\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rB\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u000e\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u001d\u001a\u00020\u0004J\u0006\u0010\u001e\u001a\u00020\nJ\u0011\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0000H\u0096\u0002J\u0013\u0010!\u001a\u00020\"2\b\u0010 \u001a\u0004\u0018\u00010#H\u0096\u0002J\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020\u0004J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'J\u001e\u0010(\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+H\u0007J\b\u0010,\u001a\u00020\nH\u0016J\u0006\u0010-\u001a\u00020\u0004J\u0006\u0010.\u001a\u00020\u0004J\u000e\u0010.\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'J\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\nJ\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\nJ\u000e\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\nJ\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\nJ\b\u00107\u001a\u00020\u0007H\u0016R\u0011\u0010\u0010\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u000e\u0010\t\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u001b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012\u00a8\u00069"}, d2={"Lde/jfachwert/rechnung/Rechnungsmonat;", "Lde/jfachwert/KFachwert;", "", "date", "Ljava/time/LocalDate;", "(Ljava/time/LocalDate;)V", "monat", "", "(Ljava/lang/String;)V", "monate", "", "(I)V", "jahr", "(II)V", "Ljava/time/Month;", "(Ljava/time/Month;I)V", "folgejahr", "getFolgejahr", "()Lde/jfachwert/rechnung/Rechnungsmonat;", "folgemonat", "getFolgemonat", "getJahr", "()I", "getMonat", "", "vorjahr", "getVorjahr", "vormonat", "getVormonat", "asLocalDate", "asMonate", "compareTo", "other", "equals", "", "", "ersterArbeitstag", "ersterTag", "wochentag", "Ljava/time/DayOfWeek;", "format", "pattern", "locale", "Ljava/util/Locale;", "hashCode", "letzterArbeitstag", "letzterTag", "minusMonths", "months", "minusYears", "years", "plusMonths", "monthsToAdd", "plusYears", "yearsToAdd", "toString", "Companion", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nRechnungsmonat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rechnungsmonat.kt\nde/jfachwert/rechnung/Rechnungsmonat\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,543:1\n37#2,2:544\n*S KotlinDebug\n*F\n+ 1 Rechnungsmonat.kt\nde/jfachwert/rechnung/Rechnungsmonat\n*L\n82#1:544,2\n*E\n"})
public class Rechnungsmonat
implements KFachwert,
Comparable<Rechnungsmonat> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final short monate;
    @NotNull
    private static final Map<Short, Rechnungsmonat> WEAK_CACHE = new WeakHashMap();
    private static final Range<Integer> VALID_MONTH_RANGE = Range.of((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(12));
    private static final Range<Integer> VALID_YEAR_RANGE = Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(9999));
    @NotNull
    private static final String MONTH = "month";
    @NotNull
    private static final String YEAR = "year";
    @JvmField
    @NotNull
    public static final Rechnungsmonat NULL = Companion.of(0);

    @JvmOverloads
    public Rechnungsmonat(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this(date.getMonthValue(), date.getYear());
    }

    public /* synthetic */ Rechnungsmonat(LocalDate localDate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            LocalDate localDate2 = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"now(...)");
            localDate = localDate2;
        }
        this(localDate);
    }

    public Rechnungsmonat(@NotNull String monat) {
        short s2;
        Intrinsics.checkNotNullParameter((Object)monat, (String)"monat");
        String[] stringArray = new String[]{"/"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)monat, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        if (parts.length == 2 && Rechnungsmonat.Companion.isDigit(parts[0]) && Rechnungsmonat.Companion.isDigit(parts[1])) {
            String string = parts[0];
            Range<Integer> range = VALID_MONTH_RANGE;
            Intrinsics.checkNotNullExpressionValue(range, (String)"VALID_MONTH_RANGE");
            int n = Rechnungsmonat.Companion.verify(MONTH, string, (Range<Integer>)range);
            String string2 = parts[1];
            Range<Integer> range2 = VALID_YEAR_RANGE;
            Intrinsics.checkNotNullExpressionValue(range2, (String)"VALID_YEAR_RANGE");
            s2 = Rechnungsmonat.Companion.asMonate(n, Rechnungsmonat.Companion.verify(YEAR, string2, (Range<Integer>)range2));
        } else {
            LocalDate date = Rechnungsmonat.Companion.toLocalDate(monat);
            s2 = Rechnungsmonat.Companion.asMonate(date.getMonthValue(), date.getYear());
        }
        this.monate = s2;
    }

    private Rechnungsmonat(int monate) {
        this.monate = (short)monate;
    }

    public Rechnungsmonat(int monat, int jahr) {
        this(Rechnungsmonat.Companion.asMonate(monat, jahr));
    }

    public Rechnungsmonat(@NotNull Month monat, int jahr) {
        Intrinsics.checkNotNullParameter((Object)monat, (String)"monat");
        this(monat.getValue(), jahr);
    }

    public final int asMonate() {
        return this.monate + 1;
    }

    public final int getMonat() {
        return this.monate % 12 + 1;
    }

    public final int getJahr() {
        return this.monate / 12;
    }

    @NotNull
    public final Rechnungsmonat getVormonat() {
        return Companion.of(this.monate - 1);
    }

    @NotNull
    public final Rechnungsmonat getFolgemonat() {
        return Companion.of(this.monate + 1);
    }

    @NotNull
    public final Rechnungsmonat getVorjahr() {
        return Companion.of(this.monate - 12);
    }

    @NotNull
    public final Rechnungsmonat getFolgejahr() {
        return Companion.of(this.monate + 12);
    }

    @NotNull
    public final LocalDate ersterTag() {
        LocalDate localDate = LocalDate.of(this.getJahr(), this.getMonat(), 1);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"of(...)");
        return localDate;
    }

    @NotNull
    public final LocalDate ersterTag(@NotNull DayOfWeek wochentag) {
        Intrinsics.checkNotNullParameter((Object)wochentag, (String)"wochentag");
        LocalDate tag = this.ersterTag();
        while (tag.getDayOfWeek() != wochentag) {
            Intrinsics.checkNotNullExpressionValue((Object)tag.plusDays(1L), (String)"plusDays(...)");
        }
        return tag;
    }

    @NotNull
    public final LocalDate ersterArbeitstag() {
        LocalDate localDate;
        LocalDate tag = this.ersterTag();
        DayOfWeek dayOfWeek = tag.getDayOfWeek();
        switch (dayOfWeek == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dayOfWeek.ordinal()]) {
            case 1: {
                LocalDate localDate2 = tag.plusDays(2L);
                localDate = localDate2;
                Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"plusDays(...)");
                break;
            }
            case 2: {
                LocalDate localDate3 = tag.plusDays(1L);
                localDate = localDate3;
                Intrinsics.checkNotNullExpressionValue((Object)localDate3, (String)"plusDays(...)");
                break;
            }
            default: {
                localDate = tag;
            }
        }
        return localDate;
    }

    @NotNull
    public final LocalDate letzterTag() {
        LocalDate localDate = this.getFolgemonat().ersterTag().minusDays(1L);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"minusDays(...)");
        return localDate;
    }

    @NotNull
    public final LocalDate letzterTag(@NotNull DayOfWeek wochentag) {
        Intrinsics.checkNotNullParameter((Object)wochentag, (String)"wochentag");
        LocalDate tag = this.ersterTag();
        while (tag.getDayOfWeek() != wochentag) {
            Intrinsics.checkNotNullExpressionValue((Object)tag.minusDays(1L), (String)"minusDays(...)");
        }
        return tag;
    }

    @NotNull
    public final LocalDate letzterArbeitstag() {
        LocalDate localDate;
        LocalDate tag = this.letzterTag();
        DayOfWeek dayOfWeek = tag.getDayOfWeek();
        switch (dayOfWeek == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dayOfWeek.ordinal()]) {
            case 1: {
                LocalDate localDate2 = tag.minusDays(1L);
                localDate = localDate2;
                Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"minusDays(...)");
                break;
            }
            case 2: {
                LocalDate localDate3 = tag.minusDays(2L);
                localDate = localDate3;
                Intrinsics.checkNotNullExpressionValue((Object)localDate3, (String)"minusDays(...)");
                break;
            }
            default: {
                localDate = tag;
            }
        }
        return localDate;
    }

    @NotNull
    public final LocalDate asLocalDate() {
        return this.ersterTag();
    }

    @NotNull
    public final Rechnungsmonat plusYears(int yearsToAdd) {
        return this.plusMonths(yearsToAdd * 12);
    }

    @NotNull
    public final Rechnungsmonat plusMonths(int monthsToAdd) {
        return monthsToAdd == 0 ? this : Companion.of(this.monate + monthsToAdd);
    }

    @NotNull
    public final Rechnungsmonat minusYears(int years) {
        return this.plusYears(-years);
    }

    @NotNull
    public final Rechnungsmonat minusMonths(int months) {
        return this.plusMonths(-months);
    }

    @JvmOverloads
    @NotNull
    public final String format(@Nullable String pattern, @Nullable Locale locale) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, locale);
        String string = this.asLocalDate().format(formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static /* synthetic */ String format$default(Rechnungsmonat rechnungsmonat, String string, Locale locale, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: format");
        }
        if ((n & 2) != 0) {
            locale = Locale.getDefault();
        }
        return rechnungsmonat.format(string, locale);
    }

    public int hashCode() {
        return this.monate;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Rechnungsmonat)) {
            return false;
        }
        return this.monate == ((Rechnungsmonat)other).monate;
    }

    @NotNull
    public String toString() {
        return "" + this.getMonat() + '/' + this.getJahr();
    }

    @Override
    public int compareTo(@NotNull Rechnungsmonat other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.monate - other.monate;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap(this);
    }

    @Override
    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid(this);
    }

    @JvmOverloads
    public Rechnungsmonat() {
        this(null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final String format(@Nullable String pattern) {
        return Rechnungsmonat.format$default(this, pattern, null, 2, null);
    }

    @JvmStatic
    private static final short asMonate(int monat, int jahr) {
        return Rechnungsmonat.Companion.asMonate(monat, jahr);
    }

    @JvmStatic
    @NotNull
    public static final Rechnungsmonat now() {
        return Companion.now();
    }

    @JvmStatic
    @NotNull
    public static final Rechnungsmonat of(@NotNull LocalDate date) {
        return Companion.of(date);
    }

    @JvmStatic
    @NotNull
    public static final Rechnungsmonat of(@NotNull String datum) {
        return Companion.of(datum);
    }

    @JvmStatic
    @NotNull
    public static final Rechnungsmonat of(int monat, int jahr) {
        return Companion.of(monat, jahr);
    }

    @JvmStatic
    @NotNull
    public static final Rechnungsmonat of(@NotNull Month monat, int jahr) {
        return Companion.of(monat, jahr);
    }

    @JvmStatic
    @NotNull
    public static final Rechnungsmonat of(int monate) {
        return Companion.of(monate);
    }

    public /* synthetic */ Rechnungsmonat(int monate, DefaultConstructorMarker $constructor_marker) {
        this(monate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0003J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u0006H\u0007J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0014H\u0007J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\tH\u0007J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\tH\u0007J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0007J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0004H\u0007J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J&\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J&\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/jfachwert/rechnung/Rechnungsmonat$Companion;", "", "()V", "MONTH", "", "NULL", "Lde/jfachwert/rechnung/Rechnungsmonat;", "VALID_MONTH_RANGE", "Lorg/apache/commons/lang3/Range;", "", "kotlin.jvm.PlatformType", "VALID_YEAR_RANGE", "WEAK_CACHE", "", "", "YEAR", "asMonate", "monat", "jahr", "guessLocalDate", "Ljava/time/LocalDate;", "ex", "Ljava/time/format/DateTimeParseException;", "isDigit", "", "number", "now", "of", "date", "Ljava/time/Month;", "monate", "datum", "toLocalDate", "verify", "context", "range", "value", "jfachwert"})
    @SourceDebugExtension(value={"SMAP\nRechnungsmonat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rechnungsmonat.kt\nde/jfachwert/rechnung/Rechnungsmonat$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,543:1\n37#2,2:544\n*S KotlinDebug\n*F\n+ 1 Rechnungsmonat.kt\nde/jfachwert/rechnung/Rechnungsmonat$Companion\n*L\n498#1:544,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final short asMonate(int monat, int jahr) {
            Range range = VALID_MONTH_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"access$getVALID_MONTH_RANGE$cp(...)");
            this.verify(Rechnungsmonat.MONTH, monat, (Range<Integer>)range);
            Range range2 = VALID_YEAR_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"access$getVALID_YEAR_RANGE$cp(...)");
            this.verify(Rechnungsmonat.YEAR, jahr, (Range<Integer>)range2);
            return (short)(jahr * 12 + monat - 1);
        }

        @JvmStatic
        @NotNull
        public final Rechnungsmonat now() {
            LocalDate localDate = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(...)");
            return this.of(localDate);
        }

        @JvmStatic
        @NotNull
        public final Rechnungsmonat of(@NotNull LocalDate date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return this.of(new Rechnungsmonat(date).monate);
        }

        @JvmStatic
        @NotNull
        public final Rechnungsmonat of(@NotNull String datum) {
            Intrinsics.checkNotNullParameter((Object)datum, (String)"datum");
            return this.of(new Rechnungsmonat(datum).monate);
        }

        @JvmStatic
        @NotNull
        public final Rechnungsmonat of(int monat, int jahr) {
            return this.of(this.asMonate(monat, jahr));
        }

        @JvmStatic
        @NotNull
        public final Rechnungsmonat of(@NotNull Month monat, int jahr) {
            Intrinsics.checkNotNullParameter((Object)monat, (String)"monat");
            return this.of(monat.getValue(), jahr);
        }

        @JvmStatic
        @NotNull
        public final Rechnungsmonat of(int monate) {
            Rechnungsmonat rechnungsmonat = WEAK_CACHE.computeIfAbsent((short)monate, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)rechnungsmonat, (String)"computeIfAbsent(...)");
            return rechnungsmonat;
        }

        private final LocalDate toLocalDate(String monat) {
            CharSequence charSequence = monat;
            Object object = new Regex("[/.\\s]");
            String string = "-";
            String normalized = object.replace(charSequence, string);
            object = new String[]{"-"};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)monat, (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] parts = thisCollection$iv.toArray(new String[0]);
            if (parts.length == 2) {
                normalized = "1-" + normalized;
            } else if (parts.length != 3) {
                throw new LocalizedIllegalArgumentException((Serializable)((Object)monat), Rechnungsmonat.MONTH, null, 4, null);
            }
            try {
                object = LocalDate.parse(normalized);
                Intrinsics.checkNotNull((Object)object);
            }
            catch (DateTimeParseException ex) {
                object = this.guessLocalDate(normalized, ex);
            }
            return object;
        }

        private final LocalDate guessLocalDate(String monat, DateTimeParseException ex) {
            String[] stringArray = new String[]{"d-MMM-yyyy", "d-MM-yyyy", "yyyy-MMM-d", "yyyy-MM-d", "MMM-d-yyyy"};
            for (String pattern : stringArray) {
                Locale[] localeArray;
                Intrinsics.checkNotNullExpressionValue((Object)Locale.getAvailableLocales(), (String)"getAvailableLocales(...)");
                for (Locale locale : localeArray) {
                    try {
                        LocalDate localDate = LocalDate.parse(monat, DateTimeFormatter.ofPattern(pattern, locale));
                        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(...)");
                        return localDate;
                    }
                    catch (DateTimeParseException ignored) {
                        ExceptionsKt.addSuppressed((Throwable)ex, (Throwable)new IllegalArgumentException(ignored.getMessage() + " / '" + monat + "' does not match '" + pattern + '\''));
                    }
                }
            }
            throw new InvalidValueException((Serializable)((Object)monat), Rechnungsmonat.MONTH, ex);
        }

        private final int verify(String context, String value, Range<Integer> range) {
            int number = Integer.parseInt(value);
            return this.verify(context, number, range);
        }

        private final int verify(String context, int number, Range<Integer> range) {
            if (!range.contains((Object)number)) {
                throw new LocalizedIllegalArgumentException((Serializable)Integer.valueOf(number), context, range);
            }
            return number;
        }

        private final boolean isDigit(String number) {
            return StringUtils.isNumeric((CharSequence)number);
        }

        private static final Rechnungsmonat of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Rechnungsmonat)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DayOfWeek.values().length];
            try {
                nArray[DayOfWeek.SATURDAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DayOfWeek.SUNDAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

