/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.steuer;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.math.PackedDecimal;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.Mod11Verfahren;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.steuer.Steuernummer;
import java.io.Serializable;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u0000 \r2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\r\u000eB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lde/jfachwert/steuer/Steuernummer;", "Lde/jfachwert/AbstractFachwert;", "Lde/jfachwert/math/PackedDecimal;", "nr", "", "(Ljava/lang/String;)V", "pzVerfahren", "Lde/jfachwert/KSimpleValidator;", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "pruefziffer", "", "getPruefziffer", "()I", "Companion", "Validator", "jfachwert"})
public class Steuernummer
extends AbstractFachwert<PackedDecimal, Steuernummer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Validator VALIDATOR = new Validator();
    @NotNull
    private static final WeakHashMap<String, Steuernummer> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Steuernummer NULL = new Steuernummer("", new NullValidator());

    public Steuernummer(@NotNull String nr, @NotNull KSimpleValidator<PackedDecimal> pzVerfahren) {
        Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
        Intrinsics.checkNotNullParameter(pzVerfahren, (String)"pzVerfahren");
        super((Serializable)PackedDecimal.Companion.of(nr), pzVerfahren);
    }

    public /* synthetic */ Steuernummer(String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(string, kSimpleValidator);
    }

    public Steuernummer(@NotNull String nr) {
        Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
        this(nr, VALIDATOR);
    }

    public final int getPruefziffer() {
        return VALIDATOR.getPruefziffer((PackedDecimal)this.getCode());
    }

    @JvmStatic
    @NotNull
    public static final Steuernummer of(@NotNull String nr) {
        return Companion.of(nr);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/jfachwert/steuer/Steuernummer$Companion;", "", "()V", "NULL", "Lde/jfachwert/steuer/Steuernummer;", "VALIDATOR", "Lde/jfachwert/steuer/Steuernummer$Validator;", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "", "of", "nr", "validate", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Steuernummer of(@NotNull String nr) {
            Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
            Steuernummer steuernummer = WEAK_CACHE.computeIfAbsent(nr, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)steuernummer, (String)"computeIfAbsent(...)");
            return steuernummer;
        }

        @NotNull
        public final String validate(@NotNull String nr) {
            Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
            return VALIDATOR.validate(nr);
        }

        private static final Steuernummer of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Steuernummer)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lde/jfachwert/steuer/Steuernummer$Validator;", "Lde/jfachwert/KSimpleValidator;", "Lde/jfachwert/math/PackedDecimal;", "()V", "getPruefziffer", "", "nr", "validate", "value", "", "Companion", "jfachwert"})
    public static class Validator
    implements KSimpleValidator<PackedDecimal> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Mod11Verfahren MOD11 = new Mod11Verfahren(10);

        @Override
        @NotNull
        public PackedDecimal validate(@NotNull PackedDecimal value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.validate(value.toString());
            return value;
        }

        @Override
        @NotNull
        public String validate(@NotNull String nr) {
            Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
            LengthValidator.Companion.validate(nr, 10, 13);
            return nr.length() == 11 ? (String)((Object)MOD11.verify((Serializable)((Object)nr))) : nr;
        }

        public final int getPruefziffer(@NotNull PackedDecimal nr) {
            Intrinsics.checkNotNullParameter((Object)nr, (String)"nr");
            return Integer.parseInt(MOD11.getPruefziffer(nr.toString()));
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public PackedDecimal verify(@NotNull PackedDecimal value) {
            return (PackedDecimal)KSimpleValidator.DefaultImpls.verify(this, (Serializable)value);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/jfachwert/steuer/Steuernummer$Validator$Companion;", "", "()V", "MOD11", "Lde/jfachwert/pruefung/Mod11Verfahren;", "jfachwert"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

