/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.zeit;

import de.jfachwert.KFachwert;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import java.math.BigInteger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0086\u0081\u0002\u0018\u0000 ;2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u0003:\u0001;B\u000f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\b\u0010$\u001a\u00020\u0017H\u0002J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:\u00a8\u0006<"}, d2={"Lde/jfachwert/zeit/Zeiteinheit;", "", "Lde/jfachwert/KFachwert;", "Ljava/time/temporal/TemporalUnit;", "duration", "Ljava/time/Duration;", "(Ljava/lang/String;ILjava/time/Duration;)V", "addTo", "R", "Ljava/time/temporal/Temporal;", "temporal", "amount", "", "(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;", "between", "temporal1Inclusive", "temporal2Exclusive", "getDuration", "isDateBased", "", "isDurationEstimated", "isTimeBased", "toCenturies", "Ljava/math/BigInteger;", "n", "toChronoUnit", "Ljava/time/temporal/ChronoUnit;", "toDays", "toDecades", "toHours", "toJahrmillionen", "toMicros", "toMillenia", "toMillis", "toMinutes", "toMonths", "toNanos", "toSeconds", "toTimeUnit", "Ljava/util/concurrent/TimeUnit;", "toWeeks", "toYears", "NANOSECONDS", "MICROSECONDS", "MILLISECONDS", "SECONDS", "MINUTES", "HOURS", "HALF_DAYS", "DAYS", "WEEKS", "MONTHS", "YEARS", "DECADES", "CENTURIES", "MILLENNIA", "ERAS", "FOREVER", "UNBEKANNT", "Companion", "jfachwert"})
public final class Zeiteinheit
extends Enum<Zeiteinheit>
implements KFachwert,
TemporalUnit {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Duration duration;
    private static final Logger logger;
    public static final /* enum */ Zeiteinheit NANOSECONDS;
    public static final /* enum */ Zeiteinheit MICROSECONDS;
    public static final /* enum */ Zeiteinheit MILLISECONDS;
    public static final /* enum */ Zeiteinheit SECONDS;
    public static final /* enum */ Zeiteinheit MINUTES;
    public static final /* enum */ Zeiteinheit HOURS;
    public static final /* enum */ Zeiteinheit HALF_DAYS;
    public static final /* enum */ Zeiteinheit DAYS;
    public static final /* enum */ Zeiteinheit WEEKS;
    public static final /* enum */ Zeiteinheit MONTHS;
    public static final /* enum */ Zeiteinheit YEARS;
    public static final /* enum */ Zeiteinheit DECADES;
    public static final /* enum */ Zeiteinheit CENTURIES;
    public static final /* enum */ Zeiteinheit MILLENNIA;
    public static final /* enum */ Zeiteinheit ERAS;
    public static final /* enum */ Zeiteinheit FOREVER;
    public static final /* enum */ Zeiteinheit UNBEKANNT;
    private static final /* synthetic */ Zeiteinheit[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Zeiteinheit(Duration duration) {
        this.duration = duration;
    }

    @NotNull
    public final TimeUnit toTimeUnit() {
        for (TimeUnit unit : EntriesMappings.entries$0) {
            if (!this.name().equals(unit.name())) continue;
            return unit;
        }
        throw new LocalizedIllegalArgumentException(this, "keine Umwandlung moeglich", null, 4, null);
    }

    @NotNull
    public final ChronoUnit toChronoUnit() {
        ChronoUnit chronoUnit;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                chronoUnit = ChronoUnit.NANOS;
                break;
            }
            case 2: {
                chronoUnit = ChronoUnit.MICROS;
                break;
            }
            case 3: {
                chronoUnit = ChronoUnit.MILLIS;
                break;
            }
            case 4: {
                chronoUnit = ChronoUnit.SECONDS;
                break;
            }
            case 5: {
                chronoUnit = ChronoUnit.MINUTES;
                break;
            }
            case 6: {
                chronoUnit = ChronoUnit.HOURS;
                break;
            }
            case 7: {
                chronoUnit = ChronoUnit.HALF_DAYS;
                break;
            }
            case 8: {
                chronoUnit = ChronoUnit.DAYS;
                break;
            }
            case 9: {
                chronoUnit = ChronoUnit.WEEKS;
                break;
            }
            case 10: {
                chronoUnit = ChronoUnit.MONTHS;
                break;
            }
            case 11: {
                chronoUnit = ChronoUnit.YEARS;
                break;
            }
            case 12: {
                chronoUnit = ChronoUnit.DECADES;
                break;
            }
            case 13: {
                chronoUnit = ChronoUnit.CENTURIES;
                break;
            }
            case 14: {
                chronoUnit = ChronoUnit.MILLENNIA;
                break;
            }
            case 15: {
                chronoUnit = ChronoUnit.ERAS;
                break;
            }
            default: {
                chronoUnit = ChronoUnit.FOREVER;
            }
        }
        return chronoUnit;
    }

    @NotNull
    public final BigInteger toNanos(long n) {
        BigInteger bigInteger = this.toNanos().multiply(BigInteger.valueOf(n));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
        return bigInteger;
    }

    private final BigInteger toNanos() {
        try {
            BigInteger bigInteger = BigInteger.valueOf(this.duration.toNanos());
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            return bigInteger;
        }
        catch (ArithmeticException ex) {
            logger.log(Level.FINE, this.duration + "' ist zu gross fuer Nanosekunden:", ex);
            BigInteger bigInteger = BigInteger.valueOf(this.duration.toSeconds()).multiply(BigInteger.valueOf(1000000000L));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
            return bigInteger;
        }
    }

    @NotNull
    public final BigInteger toMicros(long n) {
        BigInteger bigInteger = this.toNanos().multiply(BigInteger.valueOf(n)).divide(MICROSECONDS.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toMillis(long n) {
        BigInteger bigInteger = this.toNanos().multiply(BigInteger.valueOf(n)).divide(MILLISECONDS.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toSeconds(long n) {
        BigInteger bigInteger = BigInteger.valueOf(this.duration.toSeconds()).multiply(BigInteger.valueOf(n));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toMinutes(long n) {
        BigInteger bigInteger = BigInteger.valueOf(this.duration.toMinutes()).multiply(BigInteger.valueOf(n));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toHours(long n) {
        BigInteger bigInteger = BigInteger.valueOf(this.duration.toHours()).multiply(BigInteger.valueOf(n));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toDays(long n) {
        BigInteger bigInteger = BigInteger.valueOf(this.duration.toDays()).multiply(BigInteger.valueOf(n));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toWeeks(long n) {
        BigInteger bigInteger = this.toNanos().multiply(BigInteger.valueOf(n)).divide(WEEKS.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toMonths(long n) {
        BigInteger bigInteger = this.toNanos().multiply(BigInteger.valueOf(n)).divide(MONTHS.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toYears(long n) {
        BigInteger bigInteger = this.toNanos().multiply(BigInteger.valueOf(n)).divide(YEARS.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toDecades(long n) {
        BigInteger bigInteger = this.toNanos().multiply(BigInteger.valueOf(n)).divide(DECADES.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toCenturies(long n) {
        BigInteger bigInteger = this.toNanos().multiply(BigInteger.valueOf(n)).divide(CENTURIES.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toMillenia(long n) {
        BigInteger bigInteger = this.toNanos().multiply(BigInteger.valueOf(n)).divide(MILLENNIA.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
        return bigInteger;
    }

    @NotNull
    public final BigInteger toJahrmillionen(long n) {
        BigInteger bigInteger = this.toNanos().multiply(BigInteger.valueOf(n)).divide(ERAS.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
        return bigInteger;
    }

    @Override
    @NotNull
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public boolean isDurationEstimated() {
        return this.duration.toSeconds() < Long.MAX_VALUE;
    }

    @Override
    public boolean isDateBased() {
        return this.isDurationEstimated() && this.compareTo((Enum)DAYS) >= 0;
    }

    @Override
    public boolean isTimeBased() {
        return this.compareTo((Enum)DAYS) < 0;
    }

    @Override
    @NotNull
    public <R extends Temporal> R addTo(@NotNull R temporal, long amount) {
        Intrinsics.checkNotNullParameter(temporal, (String)"temporal");
        Temporal temporal2 = temporal.plus(amount, this.toChronoUnit());
        Intrinsics.checkNotNull((Object)temporal2, (String)"null cannot be cast to non-null type R of de.jfachwert.zeit.Zeiteinheit.addTo");
        return (R)temporal2;
    }

    @Override
    public long between(@NotNull Temporal temporal1Inclusive, @NotNull Temporal temporal2Exclusive) {
        Intrinsics.checkNotNullParameter((Object)temporal1Inclusive, (String)"temporal1Inclusive");
        Intrinsics.checkNotNullParameter((Object)temporal2Exclusive, (String)"temporal2Exclusive");
        return temporal1Inclusive.until(temporal2Exclusive, this.toChronoUnit());
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap(this);
    }

    @Override
    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid(this);
    }

    public static Zeiteinheit[] values() {
        return (Zeiteinheit[])$VALUES.clone();
    }

    public static Zeiteinheit valueOf(String value) {
        return Enum.valueOf(Zeiteinheit.class, value);
    }

    @NotNull
    public static EnumEntries<Zeiteinheit> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @NotNull
    public static final Zeiteinheit of(@NotNull TimeUnit timeUnit) {
        return Companion.of(timeUnit);
    }

    @JvmStatic
    @NotNull
    public static final Zeiteinheit of(@NotNull TemporalUnit unit) {
        return Companion.of(unit);
    }

    static {
        Duration duration = Duration.ofNanos(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        NANOSECONDS = new Zeiteinheit(duration);
        Duration duration2 = Duration.ofNanos(1000L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofNanos(...)");
        MICROSECONDS = new Zeiteinheit(duration2);
        Duration duration3 = Duration.ofMillis(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMillis(...)");
        MILLISECONDS = new Zeiteinheit(duration3);
        Duration duration4 = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(...)");
        SECONDS = new Zeiteinheit(duration4);
        Duration duration5 = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration5, (String)"ofMinutes(...)");
        MINUTES = new Zeiteinheit(duration5);
        Duration duration6 = Duration.ofHours(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration6, (String)"ofHours(...)");
        HOURS = new Zeiteinheit(duration6);
        Duration duration7 = Duration.ofHours(12L);
        Intrinsics.checkNotNullExpressionValue((Object)duration7, (String)"ofHours(...)");
        HALF_DAYS = new Zeiteinheit(duration7);
        Duration duration8 = Duration.ofDays(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration8, (String)"ofDays(...)");
        DAYS = new Zeiteinheit(duration8);
        Duration duration9 = Duration.ofDays(7L);
        Intrinsics.checkNotNullExpressionValue((Object)duration9, (String)"ofDays(...)");
        WEEKS = new Zeiteinheit(duration9);
        Duration duration10 = Duration.ofSeconds(2629746L);
        Intrinsics.checkNotNullExpressionValue((Object)duration10, (String)"ofSeconds(...)");
        MONTHS = new Zeiteinheit(duration10);
        Duration duration11 = Duration.ofSeconds(31556952L);
        Intrinsics.checkNotNullExpressionValue((Object)duration11, (String)"ofSeconds(...)");
        YEARS = new Zeiteinheit(duration11);
        Duration duration12 = Duration.ofSeconds(315569520L);
        Intrinsics.checkNotNullExpressionValue((Object)duration12, (String)"ofSeconds(...)");
        DECADES = new Zeiteinheit(duration12);
        Duration duration13 = Duration.ofSeconds(3155695200L);
        Intrinsics.checkNotNullExpressionValue((Object)duration13, (String)"ofSeconds(...)");
        CENTURIES = new Zeiteinheit(duration13);
        Duration duration14 = Duration.ofSeconds(31556952000L);
        Intrinsics.checkNotNullExpressionValue((Object)duration14, (String)"ofSeconds(...)");
        MILLENNIA = new Zeiteinheit(duration14);
        Duration duration15 = Duration.ofSeconds(31556952000000L);
        Intrinsics.checkNotNullExpressionValue((Object)duration15, (String)"ofSeconds(...)");
        ERAS = new Zeiteinheit(duration15);
        Duration duration16 = Duration.ofSeconds(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)duration16, (String)"ofSeconds(...)");
        FOREVER = new Zeiteinheit(duration16);
        Duration duration17 = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration17, (String)"ZERO");
        UNBEKANNT = new Zeiteinheit(duration17);
        $VALUES = zeiteinheitArray = new Zeiteinheit[]{Zeiteinheit.NANOSECONDS, Zeiteinheit.MICROSECONDS, Zeiteinheit.MILLISECONDS, Zeiteinheit.SECONDS, Zeiteinheit.MINUTES, Zeiteinheit.HOURS, Zeiteinheit.HALF_DAYS, Zeiteinheit.DAYS, Zeiteinheit.WEEKS, Zeiteinheit.MONTHS, Zeiteinheit.YEARS, Zeiteinheit.DECADES, Zeiteinheit.CENTURIES, Zeiteinheit.MILLENNIA, Zeiteinheit.ERAS, Zeiteinheit.FOREVER, Zeiteinheit.UNBEKANNT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        logger = Logger.getLogger(Zeiteinheit.class.getName());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lde/jfachwert/zeit/Zeiteinheit$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Ljava/util/logging/Logger;", "of", "Lde/jfachwert/zeit/Zeiteinheit;", "unit", "Ljava/time/temporal/TemporalUnit;", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        @NotNull
        public final Zeiteinheit of(@NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            for (Zeiteinheit einheit : Zeiteinheit.getEntries()) {
                if (!timeUnit.name().equals(einheit.name())) continue;
                return einheit;
            }
            return UNBEKANNT;
        }

        @JvmStatic
        @NotNull
        public final Zeiteinheit of(@NotNull TemporalUnit unit) {
            Zeiteinheit zeiteinheit;
            block19: {
                block20: {
                    TemporalUnit temporalUnit;
                    block18: {
                        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
                        temporalUnit = unit;
                        if (!(temporalUnit instanceof Zeiteinheit)) break block18;
                        zeiteinheit = (Zeiteinheit)unit;
                        break block19;
                    }
                    if (!(temporalUnit instanceof ChronoUnit)) break block20;
                    switch (WhenMappings.$EnumSwitchMapping$0[((ChronoUnit)unit).ordinal()]) {
                        case 1: {
                            zeiteinheit = NANOSECONDS;
                            break block19;
                        }
                        case 2: {
                            zeiteinheit = MICROSECONDS;
                            break block19;
                        }
                        case 3: {
                            zeiteinheit = MILLISECONDS;
                            break block19;
                        }
                        case 4: {
                            zeiteinheit = SECONDS;
                            break block19;
                        }
                        case 5: {
                            zeiteinheit = MINUTES;
                            break block19;
                        }
                        case 6: {
                            zeiteinheit = HOURS;
                            break block19;
                        }
                        case 7: {
                            zeiteinheit = HALF_DAYS;
                            break block19;
                        }
                        case 8: {
                            zeiteinheit = DAYS;
                            break block19;
                        }
                        case 9: {
                            zeiteinheit = WEEKS;
                            break block19;
                        }
                        case 10: {
                            zeiteinheit = MONTHS;
                            break block19;
                        }
                        case 11: {
                            zeiteinheit = YEARS;
                            break block19;
                        }
                        case 12: {
                            zeiteinheit = DECADES;
                            break block19;
                        }
                        case 13: {
                            zeiteinheit = CENTURIES;
                            break block19;
                        }
                        case 14: {
                            zeiteinheit = MILLENNIA;
                            break block19;
                        }
                        case 15: {
                            zeiteinheit = ERAS;
                            break block19;
                        }
                        case 16: {
                            zeiteinheit = FOREVER;
                            break block19;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                zeiteinheit = UNBEKANNT;
            }
            return zeiteinheit;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ChronoUnit.values().length];
                try {
                    nArray[ChronoUnit.NANOS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.MICROS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.MILLIS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.SECONDS.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.MINUTES.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.HOURS.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.HALF_DAYS.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.DAYS.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.WEEKS.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.MONTHS.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.YEARS.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.DECADES.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.CENTURIES.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.MILLENNIA.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.ERAS.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChronoUnit.FOREVER.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<TimeUnit> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])TimeUnit.values());
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Zeiteinheit.values().length];
            try {
                nArray[Zeiteinheit.NANOSECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.MICROSECONDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.MILLISECONDS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.SECONDS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.MINUTES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.HOURS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.HALF_DAYS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.DAYS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.WEEKS.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.MONTHS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.YEARS.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.DECADES.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.CENTURIES.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.MILLENNIA.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Zeiteinheit.ERAS.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

