/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.zeit;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.Localized;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import de.jfachwert.zeit.Zeiteinheit;
import de.jfachwert.zeit.Zeitpunkt;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 62\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00032\u00020\u0004:\u00016B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u0002J\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0000J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000J\u0018\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u000fJ\u0006\u0010#\u001a\u00020\u0002J\u0006\u0010$\u001a\u00020%J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\u000e\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'J\u0006\u0010*\u001a\u00020\u0007J\u0006\u0010+\u001a\u00020\u0007J\b\u0010,\u001a\u00020\u0007H\u0016J\u001a\u0010,\u001a\u00020\u00072\b\b\u0002\u0010-\u001a\u00020\u00072\b\b\u0002\u0010&\u001a\u00020'J\u0010\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u000fH\u0002J\u0006\u00100\u001a\u000201J\u0018\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u00104\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u000fH\u0016\u00a8\u00067"}, d2={"Lde/jfachwert/zeit/Zeitpunkt;", "Lde/jfachwert/AbstractFachwert;", "Ljava/math/BigInteger;", "Lde/jfachwert/Localized;", "Ljava/time/temporal/Temporal;", "()V", "code", "", "(Ljava/lang/String;)V", "t", "(Ljava/math/BigInteger;)V", "compareTo", "", "other", "getLong", "", "field", "Ljava/time/temporal/TemporalField;", "getNanos", "getTimeInMillis", "getTimeInNanos", "getTimeInYears", "isAfter", "", "isBefore", "isOutOfLocalDateTime", "isSupported", "unit", "Ljava/time/temporal/TemporalUnit;", "minus", "plus", "amountToAdd", "toDate", "Ljava/util/Date;", "toEpochSecond", "toEpochSecondExact", "toLocalDate", "Ljava/time/LocalDate;", "offset", "Ljava/time/ZoneOffset;", "toLocalDateTime", "Ljava/time/LocalDateTime;", "toLongString", "toShortString", "toString", "pattern", "toStringInYears", "years", "toTimestamp", "Ljava/sql/Timestamp;", "until", "endExclusive", "with", "newValue", "Companion", "jfachwert"})
public class Zeitpunkt
extends AbstractFachwert<BigInteger, Zeitpunkt>
implements Localized,
Temporal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = Logger.getLogger(Zeitpunkt.class.getName());
    @NotNull
    private static final WeakHashMap<BigInteger, Zeitpunkt> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Zeitpunkt EPOCH;
    @JvmField
    @NotNull
    public static final Zeitpunkt MIN;
    @JvmField
    @NotNull
    public static final Zeitpunkt MAX;

    public Zeitpunkt(@NotNull BigInteger t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        super(t, null, 2, null);
    }

    public Zeitpunkt() {
        this(Zeitpunkt.Companion.currentTimeNanos());
    }

    public Zeitpunkt(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this(Zeitpunkt.Companion.toNanos(code));
    }

    @NotNull
    public final BigInteger getTimeInNanos() {
        return (BigInteger)this.getCode();
    }

    public final long getTimeInMillis() {
        return ((BigInteger)this.getCode()).divide(Zeiteinheit.MILLISECONDS.toNanos(1L)).longValue();
    }

    public final long getTimeInYears() {
        return ((BigInteger)this.getCode()).divide(Zeiteinheit.YEARS.toNanos(1L)).longValue();
    }

    public final int getNanos() {
        return ((BigInteger)this.getCode()).mod(Zeiteinheit.SECONDS.toNanos(1L)).intValue();
    }

    public final long toEpochSecond() {
        return this.toEpochSecondExact().longValue();
    }

    @NotNull
    public final BigInteger toEpochSecondExact() {
        BigInteger bigInteger = ((BigInteger)this.getCode()).divide(Zeiteinheit.SECONDS.toNanos(1L));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
        return bigInteger;
    }

    @NotNull
    public final Zeitpunkt minus(@NotNull Zeitpunkt t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        BigInteger bigInteger = ((BigInteger)this.getCode()).subtract((BigInteger)t.getCode());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
        return Companion.of(bigInteger);
    }

    @NotNull
    public final Zeitpunkt plus(@NotNull Zeitpunkt t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        BigInteger bigInteger = ((BigInteger)this.getCode()).add((BigInteger)t.getCode());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"add(...)");
        return Companion.of(bigInteger);
    }

    @Override
    public int compareTo(@NotNull Zeitpunkt other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ((BigInteger)this.getCode()).compareTo((BigInteger)other.getCode());
    }

    public final boolean isBefore(@NotNull Zeitpunkt t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return ((BigInteger)this.getCode()).compareTo((BigInteger)t.getCode()) < 0;
    }

    public final boolean isAfter(@NotNull Zeitpunkt t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return ((BigInteger)this.getCode()).compareTo((BigInteger)t.getCode()) > 0;
    }

    @NotNull
    public final Timestamp toTimestamp() {
        Timestamp timestamp = Timestamp.valueOf(this.toLocalDateTime());
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"valueOf(...)");
        return timestamp;
    }

    @NotNull
    public final LocalDate toLocalDate() {
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        Intrinsics.checkNotNullExpressionValue((Object)zoneOffset, (String)"UTC");
        return this.toLocalDate(zoneOffset);
    }

    @NotNull
    public final LocalDate toLocalDate(@NotNull ZoneOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        LocalDate localDate = this.toLocalDateTime(offset).toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
        return localDate;
    }

    @NotNull
    public final LocalDateTime toLocalDateTime() {
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        Intrinsics.checkNotNullExpressionValue((Object)zoneOffset, (String)"UTC");
        return this.toLocalDateTime(zoneOffset);
    }

    @NotNull
    public final LocalDateTime toLocalDateTime(@NotNull ZoneOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        if (this.isOutOfLocalDateTime()) {
            throw new IllegalStateException("Zeitpunkt " + this.getCode() + " kann nicht auf LocalDateTime abgebildet werden.");
        }
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(this.toEpochSecond(), this.getNanos(), offset);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofEpochSecond(...)");
        return localDateTime;
    }

    private final boolean isOutOfLocalDateTime() {
        BigInteger sec = this.toEpochSecondExact();
        return sec.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || sec.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0;
    }

    @NotNull
    public final Date toDate() {
        return new Date(this.getTimeInMillis());
    }

    @Override
    @NotNull
    public Zeitpunkt plus(long amountToAdd, @NotNull TemporalUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        LocalDateTime localDateTime = this.toLocalDateTime().plus(amountToAdd, unit);
        Intrinsics.checkNotNull((Object)localDateTime);
        return Companion.of(localDateTime);
    }

    @Override
    public boolean isSupported(@NotNull TemporalUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return true;
    }

    @Override
    public boolean isSupported(@NotNull TemporalField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.toLocalDateTime().isSupported(field);
    }

    @Override
    public long getLong(@NotNull TemporalField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.toLocalDateTime().getLong(field);
    }

    @Override
    @NotNull
    public Zeitpunkt with(@NotNull TemporalField field, long newValue) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        LocalDateTime localDateTime = this.toLocalDateTime().with(field, newValue);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"with(...)");
        return Companion.of(localDateTime);
    }

    @Override
    public long until(@NotNull Temporal endExclusive, @NotNull TemporalUnit unit) {
        Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Zeitpunkt endZeit = Companion.of(endExclusive);
        Zeiteinheit zeiteinheit = Zeiteinheit.Companion.of(unit);
        return this.toLocalDateTime().until(endZeit.toLocalDateTime(), zeiteinheit.toChronoUnit());
    }

    @Override
    @NotNull
    public String toString() {
        return this.toShortString();
    }

    @NotNull
    public final String toLongString() {
        if (this.isOutOfLocalDateTime()) {
            return this.toStringInYears(this.getTimeInYears());
        }
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        Intrinsics.checkNotNullExpressionValue((Object)zoneOffset, (String)"UTC");
        return this.toString("yyyy-MM-dd HH:mm:ss.n", zoneOffset);
    }

    private final String toStringInYears(long years) {
        long jahre = years;
        String bundleKey = "years_after";
        if (years < 0L) {
            jahre = -years;
            bundleKey = "years_before";
        }
        if (jahre < 1000000L) {
            Object[] objectArray = new Object[]{jahre, ""};
            return this.getLocalizedMessage(bundleKey, objectArray);
        }
        NumberFormat nf = NumberFormat.getInstance();
        BigDecimal mille = BigDecimal.valueOf(jahre).divide(BigDecimal.valueOf(1000000L), 1, RoundingMode.HALF_DOWN);
        if (mille.compareTo(BigDecimal.valueOf(1000L)) < 0) {
            Object[] objectArray = new Object[]{nf.format(mille), this.getLocalizedString("million") + ' '};
            return this.getLocalizedMessage(bundleKey, objectArray);
        }
        BigDecimal mrd = mille.divide(BigDecimal.valueOf(1000L), 1, RoundingMode.HALF_DOWN);
        Object[] objectArray = new Object[]{nf.format(mrd), this.getLocalizedString("billion") + ' '};
        return this.getLocalizedMessage(bundleKey, objectArray);
    }

    @NotNull
    public final String toShortString() {
        String s2 = this.toLongString();
        if (!StringsKt.endsWith$default((String)s2, (String)"000000", (boolean)false, (int)2, null)) {
            return s2;
        }
        String string = s2.substring(0, s2.length() - 6);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        s2 = string;
        if (!StringsKt.endsWith$default((String)s2, (String)".000", (boolean)false, (int)2, null)) {
            return s2;
        }
        String string2 = s2.substring(0, s2.length() - 4);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        s2 = string2;
        if (!StringsKt.endsWith$default((String)s2, (String)":00", (boolean)false, (int)2, null)) {
            return s2;
        }
        String string3 = s2.substring(0, s2.length() - 3);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        s2 = string3;
        if (!StringsKt.endsWith$default((String)s2, (String)"00:00", (boolean)false, (int)2, null)) {
            return s2;
        }
        String string4 = s2.substring(0, s2.length() - 5);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    @NotNull
    public final String toString(@NotNull String pattern, @NotNull ZoneOffset offset) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        String datePattern = StringsKt.removeSuffix((String)pattern, (CharSequence)".n");
        DateTimeFormatterBuilder dtfb = new DateTimeFormatterBuilder().appendOptional(DateTimeFormatter.ofPattern(datePattern));
        DateTimeFormatter formatter = dtfb.toFormatter();
        String formattedDate = formatter.format(this.toLocalDateTime(offset));
        if (StringsKt.endsWith$default((String)pattern, (String)".n", (boolean)false, (int)2, null)) {
            String string = "%s.%09d";
            Object[] objectArray = new Object[]{formattedDate, this.getNanos()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }
        Intrinsics.checkNotNull((Object)formattedDate);
        return formattedDate;
    }

    public static /* synthetic */ String toString$default(Zeitpunkt zeitpunkt, String string, ZoneOffset zoneOffset, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toString");
        }
        if ((n & 1) != 0) {
            string = "yyyy-MM-dd HH:mm:ss.n";
        }
        if ((n & 2) != 0) {
            ZoneOffset zoneOffset2 = ZoneOffset.UTC;
            Intrinsics.checkNotNullExpressionValue((Object)zoneOffset2, (String)"UTC");
            zoneOffset = zoneOffset2;
        }
        return zeitpunkt.toString(string, zoneOffset);
    }

    @Override
    @NotNull
    public String getLocalizedString(@NotNull String key) {
        return Localized.DefaultImpls.getLocalizedString(this, key);
    }

    @Override
    @NotNull
    public String getLocalizedMessage(@NotNull String key, Object ... args) {
        return Localized.DefaultImpls.getLocalizedMessage(this, key, args);
    }

    @JvmStatic
    @NotNull
    public static final Zeitpunkt of(@NotNull BigInteger code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final Zeitpunkt of(@NotNull BigInteger code, @NotNull TimeUnit unit) {
        return Companion.of(code, unit);
    }

    @JvmStatic
    @NotNull
    public static final Zeitpunkt of(@NotNull BigInteger code, @NotNull Zeiteinheit unit) {
        return Companion.of(code, unit);
    }

    @JvmStatic
    @NotNull
    public static final Zeitpunkt of(long code, @NotNull Zeiteinheit unit) {
        return Companion.of(code, unit);
    }

    @JvmStatic
    @NotNull
    public static final Zeitpunkt of(@NotNull String code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final Zeitpunkt of(@NotNull LocalDate t) {
        return Companion.of(t);
    }

    @JvmStatic
    @NotNull
    public static final Zeitpunkt of(@NotNull Temporal t) {
        return Companion.of(t);
    }

    @JvmStatic
    @NotNull
    public static final Zeitpunkt of(@NotNull Date t) {
        return Companion.of(t);
    }

    @JvmStatic
    @NotNull
    public static final Zeitpunkt now() {
        return Companion.now();
    }

    static {
        BigInteger bigInteger = BigInteger.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
        EPOCH = new Zeitpunkt(bigInteger);
        MIN = new Zeitpunkt(new BigInteger("-435500000000000000000000000"));
        MAX = new Zeitpunkt(new BigInteger("999999999999999999999999999999"));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\tH\u0007J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0016H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0019H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u001aH\u0007J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0010H\u0007J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/jfachwert/zeit/Zeitpunkt$Companion;", "", "()V", "EPOCH", "Lde/jfachwert/zeit/Zeitpunkt;", "MAX", "MIN", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Ljava/math/BigInteger;", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "currentTimeNanos", "dateToNanos", "s", "", "now", "of", "code", "unit", "Lde/jfachwert/zeit/Zeiteinheit;", "Ljava/util/concurrent/TimeUnit;", "t", "Ljava/time/LocalDate;", "Ljava/time/temporal/Temporal;", "Ljava/util/Date;", "", "toNanos", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Zeitpunkt of(@NotNull BigInteger code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Zeitpunkt zeitpunkt = WEAK_CACHE.computeIfAbsent(code, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)zeitpunkt, (String)"computeIfAbsent(...)");
            return zeitpunkt;
        }

        @JvmStatic
        @NotNull
        public final Zeitpunkt of(@NotNull BigInteger code, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            BigInteger bigInteger = code.multiply(BigInteger.valueOf(unit.toNanos(1L)));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
            return this.of(bigInteger);
        }

        @JvmStatic
        @NotNull
        public final Zeitpunkt of(@NotNull BigInteger code, @NotNull Zeiteinheit unit) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            BigInteger bigInteger = code.multiply(unit.toNanos(1L));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
            return this.of(bigInteger);
        }

        @JvmStatic
        @NotNull
        public final Zeitpunkt of(long code, @NotNull Zeiteinheit unit) {
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            BigInteger bigInteger = BigInteger.valueOf(code);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            return this.of(bigInteger, unit);
        }

        @JvmStatic
        @NotNull
        public final Zeitpunkt of(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            try {
                return this.of(new BigInteger(code));
            }
            catch (NumberFormatException ex) {
                log.log(Level.FINE, '\'' + code + "' ist keine Zahl und wird als Datum behandelt:", ex);
                return this.of(this.dateToNanos(code));
            }
        }

        @JvmStatic
        @NotNull
        public final Zeitpunkt of(@NotNull LocalDate t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            LocalDateTime localDateTime = t.atStartOfDay();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"atStartOfDay(...)");
            return this.of(localDateTime);
        }

        @JvmStatic
        @NotNull
        public final Zeitpunkt of(@NotNull Temporal t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Temporal temporal = t;
            if (temporal instanceof Zeitpunkt) {
                return (Zeitpunkt)t;
            }
            if (temporal instanceof LocalDateTime) {
                BigInteger bigInteger = Zeiteinheit.SECONDS.toNanos(((LocalDateTime)t).toEpochSecond(ZoneOffset.UTC)).add(BigInteger.valueOf(((LocalDateTime)t).getNano()));
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"add(...)");
                return this.of(bigInteger);
            }
            throw new UnsupportedOperationException(t + " kann nicht zu Zeitpunkt konvertiert werden");
        }

        @JvmStatic
        @NotNull
        public final Zeitpunkt of(@NotNull Date t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            BigInteger nanos = Zeiteinheit.MILLISECONDS.toNanos(t.getTime());
            return this.of(nanos);
        }

        @JvmStatic
        @NotNull
        public final Zeitpunkt now() {
            return new Zeitpunkt(this.currentTimeNanos());
        }

        private final BigInteger currentTimeNanos() {
            LocalDateTime now = LocalDateTime.now(ZoneOffset.UTC);
            BigInteger bigInteger = Zeiteinheit.SECONDS.toNanos(now.toEpochSecond(ZoneOffset.UTC)).add(BigInteger.valueOf(now.getNano()));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"add(...)");
            return bigInteger;
        }

        private final BigInteger toNanos(String s2) {
            BigInteger bigInteger;
            try {
                bigInteger = new BigInteger(s2);
            }
            catch (IllegalArgumentException ex) {
                log.log(Level.FINE, '\'' + s2 + "' ist keine Zahl und wird als Datum behandelt.");
                log.log(Level.FINER, "Details:", ex);
                bigInteger = this.dateToNanos(s2);
            }
            return bigInteger;
        }

        private final BigInteger dateToNanos(String s2) {
            String[] stringArray = new String[]{"yyyy-MM-dd", "dd-MMM-yyyy", "dd-MM-yyyy", "yyyy-MMM-dd", "MMM-dd-yyyy", "dd MMM yyyy", "dd MM yyyy", "yyyy MMM dd", "yyyy MM dd", "MMM dd yyyy", "dd.MMM.yyyy", "dd.MM.yyyy", "yyyy.MMM.dd", "MMM.dd.yyyy"};
            String[] datePatterns = stringArray;
            DateTimeFormatterBuilder dtfb = new DateTimeFormatterBuilder();
            for (String dp : datePatterns) {
                dtfb.appendOptional(DateTimeFormatter.ofPattern(dp + " H:m:s.SSSSSSSSS")).appendOptional(DateTimeFormatter.ofPattern(dp + " H:m:s.SSSSSSSS")).appendOptional(DateTimeFormatter.ofPattern(dp + " H:m:s.SSSSSSS")).appendOptional(DateTimeFormatter.ofPattern(dp + " H:m:s.SSSSSS")).appendOptional(DateTimeFormatter.ofPattern(dp + " H:m:s.SSSSS")).appendOptional(DateTimeFormatter.ofPattern(dp + " H:m:s.SSSS")).appendOptional(DateTimeFormatter.ofPattern(dp + " H:m:s.SSS")).appendOptional(DateTimeFormatter.ofPattern(dp + " H:m:s.SS")).appendOptional(DateTimeFormatter.ofPattern(dp + " H:m:s.S")).appendOptional(DateTimeFormatter.ofPattern(dp + " H:m:s")).appendOptional(DateTimeFormatter.ofPattern(dp + " H:m")).appendOptional(DateTimeFormatter.ofPattern(dp + " h:m")).appendOptional(DateTimeFormatter.ofPattern(dp + " K:m")).appendOptional(DateTimeFormatter.ofPattern(dp + " k:m")).appendOptional(DateTimeFormatter.ofPattern(dp));
            }
            dtfb.parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L);
            DateTimeFormatter formatter = dtfb.toFormatter();
            try {
                LocalDateTime ldt = LocalDateTime.parse(s2, formatter);
                long seconds = ldt.toEpochSecond(ZoneOffset.UTC);
                BigInteger bigInteger = Zeiteinheit.SECONDS.toNanos(seconds).add(BigInteger.valueOf(ldt.getNano()));
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"add(...)");
                return bigInteger;
            }
            catch (DateTimeParseException ex) {
                throw new LocalizedIllegalArgumentException((Serializable)((Object)s2), "unknown_time_format", ex);
            }
        }

        private static final Zeitpunkt of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Zeitpunkt)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

