/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.zeit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.jfachwert.KFachwert;
import de.jfachwert.util.ToFachwertSerializer;
import de.jfachwert.zeit.Zeitdauer;
import de.jfachwert.zeit.Zeiteinheit;
import de.jfachwert.zeit.Zeitpunkt;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToFachwertSerializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0017\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0000J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001d"}, d2={"Lde/jfachwert/zeit/Zeitraum;", "Lde/jfachwert/KFachwert;", "vonbis", "", "(Ljava/lang/String;)V", "map", "", "Lde/jfachwert/zeit/Zeitpunkt;", "(Ljava/util/Map;)V", "von", "bis", "(Lde/jfachwert/zeit/Zeitpunkt;Lde/jfachwert/zeit/Zeitpunkt;)V", "getBis", "()Lde/jfachwert/zeit/Zeitpunkt;", "getVon", "equals", "", "other", "", "getZeitdauer", "Lde/jfachwert/zeit/Zeitdauer;", "hashCode", "", "isAfter", "zeitraum", "isBefore", "toMap", "toString", "Companion", "jfachwert"})
public class Zeitraum
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Zeitpunkt von;
    @NotNull
    private final Zeitpunkt bis;
    @NotNull
    private static final WeakHashMap<Pair<Zeitpunkt, Zeitpunkt>, Zeitraum> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Zeitraum NULL = new Zeitraum(Zeitpunkt.EPOCH, Zeitpunkt.EPOCH);
    @JvmField
    @NotNull
    public static final Zeitraum PRAEKAMBRIUM = new Zeitraum(Zeitpunkt.Companion.of(-4600L, Zeiteinheit.ERAS), Zeitpunkt.Companion.of(-590L, Zeiteinheit.ERAS));
    @JvmField
    @NotNull
    public static final Zeitraum PALAEOZOLIKUM = new Zeitraum(Zeitpunkt.Companion.of(-590L, Zeiteinheit.ERAS), Zeitpunkt.Companion.of(-240L, Zeiteinheit.ERAS));
    @JvmField
    @NotNull
    public static final Zeitraum MESOZOIKUM = new Zeitraum(Zeitpunkt.Companion.of(-240L, Zeiteinheit.ERAS), Zeitpunkt.Companion.of(-65L, Zeiteinheit.ERAS));
    @JvmField
    @NotNull
    public static final Zeitraum KAENOZOIKUM = new Zeitraum(Zeitpunkt.Companion.of(-65L, Zeiteinheit.ERAS), Zeitpunkt.Companion.now());

    public Zeitraum(@NotNull Zeitpunkt von, @NotNull Zeitpunkt bis) {
        Intrinsics.checkNotNullParameter((Object)von, (String)"von");
        Intrinsics.checkNotNullParameter((Object)bis, (String)"bis");
        this.von = von;
        this.bis = bis;
    }

    @NotNull
    public final Zeitpunkt getVon() {
        return this.von;
    }

    @NotNull
    public final Zeitpunkt getBis() {
        return this.bis;
    }

    public Zeitraum(@NotNull String vonbis) {
        Intrinsics.checkNotNullParameter((Object)vonbis, (String)"vonbis");
        this(Zeitraum.Companion.split(vonbis));
    }

    @JsonCreator
    public Zeitraum(@NotNull Map<String, ? extends Zeitpunkt> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Zeitpunkt zeitpunkt = map.get("von");
        Intrinsics.checkNotNull((Object)zeitpunkt);
        Zeitpunkt zeitpunkt2 = map.get("bis");
        Intrinsics.checkNotNull((Object)zeitpunkt2);
        this(zeitpunkt, zeitpunkt2);
    }

    public final boolean isBefore(@NotNull Zeitraum zeitraum) {
        Intrinsics.checkNotNullParameter((Object)zeitraum, (String)"zeitraum");
        return this.bis.compareTo(zeitraum.von) >= 0;
    }

    public final boolean isAfter(@NotNull Zeitraum zeitraum) {
        Intrinsics.checkNotNullParameter((Object)zeitraum, (String)"zeitraum");
        return this.von.compareTo(zeitraum.bis) >= 0;
    }

    @NotNull
    public final Zeitdauer getZeitdauer() {
        return Zeitdauer.Companion.of(this.von, this.bis);
    }

    @NotNull
    public String toString() {
        return this.von + " - " + this.bis;
    }

    @NotNull
    public Map<String, Zeitpunkt> toMap() {
        Map map = new HashMap();
        map.put("von", this.von);
        map.put("bis", this.bis);
        return map;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Zeitraum)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.von, (Object)((Zeitraum)other).von) && Intrinsics.areEqual((Object)this.bis, (Object)((Zeitraum)other).bis);
    }

    public int hashCode() {
        return this.bis.hashCode();
    }

    @Override
    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid(this);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@NotNull String s2) {
        return Companion.of(s2);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@Nullable Date von, @Nullable Date bis) {
        return Companion.of(von, bis);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@Nullable Timestamp von, @Nullable Timestamp bis) {
        return Companion.of(von, bis);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@Nullable LocalDate von, @Nullable LocalDate bis) {
        return Companion.of(von, bis);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@Nullable LocalDateTime von, @Nullable LocalDateTime bis) {
        return Companion.of(von, bis);
    }

    @JvmStatic
    @NotNull
    public static final Zeitraum of(@Nullable Zeitpunkt von, @Nullable Zeitpunkt bis) {
        return Companion.of(von, bis);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0007J\u001c\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u001c\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u0011H\u0007J\u001c\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0012H\u0007J\u001c\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/jfachwert/zeit/Zeitraum$Companion;", "", "()V", "KAENOZOIKUM", "Lde/jfachwert/zeit/Zeitraum;", "MESOZOIKUM", "NULL", "PALAEOZOLIKUM", "PRAEKAMBRIUM", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lkotlin/Pair;", "Lde/jfachwert/zeit/Zeitpunkt;", "of", "von", "bis", "Ljava/sql/Timestamp;", "Ljava/time/LocalDate;", "Ljava/time/LocalDateTime;", "Ljava/util/Date;", "s", "", "split", "", "vonbis", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@NotNull String s2) {
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
            Map<String, Zeitpunkt> map = this.split(s2);
            Zeitpunkt zeitpunkt = map.get("von");
            Intrinsics.checkNotNull((Object)zeitpunkt);
            Zeitpunkt zeitpunkt2 = map.get("bis");
            Intrinsics.checkNotNull((Object)zeitpunkt2);
            return this.of(zeitpunkt, zeitpunkt2);
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@Nullable Date von, @Nullable Date bis) {
            Date date = von;
            Zeitpunkt t1 = date != null ? Zeitpunkt.Companion.of(date) : null;
            Date date2 = bis;
            Zeitpunkt t2 = date2 != null ? Zeitpunkt.Companion.of(date2) : null;
            return this.of(t1, t2);
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@Nullable Timestamp von, @Nullable Timestamp bis) {
            Timestamp timestamp = von;
            Zeitpunkt t1 = timestamp != null ? Zeitpunkt.Companion.of(timestamp) : null;
            Timestamp timestamp2 = bis;
            Zeitpunkt t2 = timestamp2 != null ? Zeitpunkt.Companion.of(timestamp2) : null;
            return this.of(t1, t2);
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@Nullable LocalDate von, @Nullable LocalDate bis) {
            LocalDate localDate = von;
            Zeitpunkt t1 = localDate != null ? Zeitpunkt.Companion.of(localDate) : null;
            LocalDate localDate2 = bis;
            Zeitpunkt t2 = localDate2 != null ? Zeitpunkt.Companion.of(localDate2) : null;
            return this.of(t1, t2);
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@Nullable LocalDateTime von, @Nullable LocalDateTime bis) {
            LocalDateTime localDateTime = von;
            Zeitpunkt t1 = localDateTime != null ? Zeitpunkt.Companion.of(localDateTime) : null;
            LocalDateTime localDateTime2 = bis;
            Zeitpunkt t2 = localDateTime2 != null ? Zeitpunkt.Companion.of(localDateTime2) : null;
            return this.of(t1, t2);
        }

        @JvmStatic
        @NotNull
        public final Zeitraum of(@Nullable Zeitpunkt von, @Nullable Zeitpunkt bis) {
            Zeitpunkt zeitpunkt;
            Zeitpunkt zeitpunkt2 = von;
            if (zeitpunkt2 == null) {
                zeitpunkt2 = Zeitpunkt.MIN;
            }
            if ((zeitpunkt = bis) == null) {
                zeitpunkt = Zeitpunkt.MAX;
            }
            Pair pair = new Pair((Object)zeitpunkt2, (Object)zeitpunkt);
            Zeitraum zeitraum = WEAK_CACHE.computeIfAbsent(pair, arg_0 -> Companion.of$lambda$0((Function1)new Function1<Pair<? extends Zeitpunkt, ? extends Zeitpunkt>, Zeitraum>((Pair<? extends Zeitpunkt, ? extends Zeitpunkt>)pair){
                final /* synthetic */ Pair<Zeitpunkt, Zeitpunkt> $pair;
                {
                    this.$pair = $pair;
                    super(1);
                }

                public final Zeitraum invoke(Pair<? extends Zeitpunkt, ? extends Zeitpunkt> it) {
                    return new Zeitraum((Zeitpunkt)this.$pair.getFirst(), (Zeitpunkt)this.$pair.getSecond());
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)zeitraum, (String)"computeIfAbsent(...)");
            return zeitraum;
        }

        private final Map<String, Zeitpunkt> split(String vonbis) {
            Map map = new HashMap();
            String string = vonbis.substring(0, vonbis.length() / 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String von = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String string2 = vonbis.substring(vonbis.length() / 2 + 1, vonbis.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String bis = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            map.put("von", Zeitpunkt.Companion.of(von));
            map.put("bis", Zeitpunkt.Companion.of(bis));
            return map;
        }

        private static final Zeitraum of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Zeitraum)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

