/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.med;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.PruefzifferVerfahren;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.LuhnVerfahren;
import de.jfachwert.pruefung.NullValidator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\b\u0016\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u0016\u0017B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016R\u0011\u0010\f\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lde/jfachwert/med/IK;", "Lde/jfachwert/AbstractFachwert;", "", "code", "validator", "Lde/jfachwert/KSimpleValidator;", "<init>", "(ILde/jfachwert/KSimpleValidator;)V", "", "(Ljava/lang/String;)V", "isValid", "", "klassifikation", "getKlassifikation", "()I", "regionalbereich", "getRegionalbereich", "seriennummer", "getSeriennummer", "pruefziffer", "getPruefziffer", "toString", "Validator", "Companion", "med"})
public class IK
extends AbstractFachwert<Integer, IK> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KSimpleValidator<Integer> VALIDATOR = new Validator();
    @NotNull
    private static final WeakHashMap<Integer, IK> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final IK NULL = new IK(0, (KSimpleValidator<Integer>)((KSimpleValidator)new NullValidator()));

    @JvmOverloads
    public IK(int code, @NotNull KSimpleValidator<Integer> validator) {
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        super((Serializable)Integer.valueOf(code), validator);
    }

    public /* synthetic */ IK(int n, KSimpleValidator kSimpleValidator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(n, kSimpleValidator);
    }

    public IK(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this(Integer.parseInt(code), null, 2, null);
    }

    public boolean isValid() {
        return VALIDATOR.isVald(this.getCode());
    }

    public final int getKlassifikation() {
        return ((Number)this.getCode()).intValue() / 10000000;
    }

    public final int getRegionalbereich() {
        return ((Number)this.getCode()).intValue() / 100000 % 100;
    }

    public final int getSeriennummer() {
        return ((Number)this.getCode()).intValue() / 10 % 10000;
    }

    public final int getPruefziffer() {
        return ((Number)this.getCode()).intValue() / 100000000;
    }

    @NotNull
    public String toString() {
        String string = "%09d";
        Object[] objectArray = new Object[]{this.getCode()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @JvmOverloads
    public IK(int code) {
        this(code, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final IK of(int ik) {
        return Companion.of(ik);
    }

    @JvmStatic
    @NotNull
    public static final IK of(@NotNull String ik) {
        return Companion.of(ik);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/jfachwert/med/IK$Companion;", "", "<init>", "()V", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lde/jfachwert/med/IK;", "NULL", "of", "ik", "", "validate", "nummer", "med"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IK of(int ik) {
            IK iK = WEAK_CACHE.computeIfAbsent(ik, arg_0 -> Companion.of$lambda$1(Companion::of$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)iK), (String)"computeIfAbsent(...)");
            return iK;
        }

        @JvmStatic
        @NotNull
        public final IK of(@NotNull String ik) {
            Intrinsics.checkNotNullParameter((Object)ik, (String)"ik");
            return this.of(Integer.parseInt(ik));
        }

        public final int validate(int nummer) {
            return ((Number)VALIDATOR.validate((Serializable)Integer.valueOf(nummer))).intValue();
        }

        private static final IK of$lambda$0(int code) {
            return new IK(code, null, 2, null);
        }

        private static final IK of$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (IK)((Object)$tmp0.invoke(p0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"Lde/jfachwert/med/IK$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "<init>", "()V", "validate", "value", "(I)Ljava/lang/Integer;", "isSpezialIK", "", "n", "Companion", "med"})
    public static final class Validator
    implements KSimpleValidator<Integer> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final PruefzifferVerfahren<String> MOD10 = (PruefzifferVerfahren)new LuhnVerfahren();
        @NotNull
        private static final LengthValidator<Integer> VALIDATOR9 = new LengthValidator(2, 9);

        @NotNull
        public Integer validate(int value) {
            int n = ((Number)VALIDATOR9.validate((Serializable)Integer.valueOf(value))).intValue();
            if (!this.isSpezialIK(n)) {
                String string = Integer.toString(n);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                MOD10.validate((Serializable)((Object)string));
            }
            return n;
        }

        private final boolean isSpezialIK(int n) {
            int klass = n / 10000000;
            return klass != 26 && klass != 34 || n % 10000000 == 9999999;
        }

        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject((KSimpleValidator)this, (Object)value);
        }

        @NotNull
        public Integer verify(int value) {
            return (Integer)KSimpleValidator.DefaultImpls.verify((KSimpleValidator)this, (Serializable)Integer.valueOf(value));
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/jfachwert/med/IK$Validator$Companion;", "", "<init>", "()V", "MOD10", "Lde/jfachwert/PruefzifferVerfahren;", "", "VALIDATOR9", "Lde/jfachwert/pruefung/LengthValidator;", "", "med"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

