/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.money.internal;

import de.jfachwert.money.Geldbetrag;
import de.jfachwert.money.GeldbetragFactory;
import de.jfachwert.money.internal.GeldbetragFactoryProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryException;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountFactoryProviderSpi;
import javax.money.spi.MonetaryAmountsSingletonSpi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\n\b\u0000\u0010\u000b*\u0004\u0018\u00010\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0006H\u0016J\u0010\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u000fH\u0016R&\u0010\u0004\u001a\u001a\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/jfachwert/money/internal/GeldbetragSingleton;", "Ljavax/money/spi/MonetaryAmountsSingletonSpi;", "<init>", "()V", "factories", "", "Ljava/lang/Class;", "Ljavax/money/MonetaryAmount;", "Ljavax/money/spi/MonetaryAmountFactoryProviderSpi;", "getAmountFactory", "Ljavax/money/MonetaryAmountFactory;", "T", "amountType", "getDefaultAmountType", "getAmountTypes", "", "money"})
public final class GeldbetragSingleton
implements MonetaryAmountsSingletonSpi {
    @NotNull
    private final Map<Class<? extends MonetaryAmount>, MonetaryAmountFactoryProviderSpi<?>> factories = new ConcurrentHashMap();

    public GeldbetragSingleton() {
        for (MonetaryAmountFactoryProviderSpi f : Bootstrap.getServices(MonetaryAmountFactoryProviderSpi.class)) {
            this.factories.putIfAbsent(f.getAmountType(), f);
        }
        this.factories.put(Geldbetrag.class, new GeldbetragFactoryProvider());
    }

    @NotNull
    public <T extends MonetaryAmount> MonetaryAmountFactory<T> getAmountFactory(@NotNull Class<T> amountType) {
        Intrinsics.checkNotNullParameter(amountType, (String)"amountType");
        if (Intrinsics.areEqual(Geldbetrag.class, amountType)) {
            return new GeldbetragFactory();
        }
        MonetaryAmountFactoryProviderSpi<?> f = this.factories.get(amountType);
        if (f != null) {
            MonetaryAmountFactory monetaryAmountFactory = f.createMonetaryAmountFactory();
            monetaryAmountFactory.setContext(monetaryAmountFactory.getMaximalMonetaryContext());
            Intrinsics.checkNotNull((Object)monetaryAmountFactory);
            return monetaryAmountFactory;
        }
        throw new MonetaryException("no MonetaryAmountFactory found for " + amountType);
    }

    @NotNull
    public Class<? extends MonetaryAmount> getDefaultAmountType() {
        return Geldbetrag.class;
    }

    @NotNull
    public Set<Class<? extends MonetaryAmount>> getAmountTypes() {
        return this.factories.keySet();
    }
}

