/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.money.internal;

import de.jfachwert.money.GeldbetragFactory;
import de.jfachwert.money.internal.GeldbetragFormatter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.money.AbstractContext;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatContextBuilder;
import javax.money.format.AmountFormatQuery;
import javax.money.format.MonetaryAmountFormat;
import javax.money.spi.Bootstrap;
import javax.money.spi.MonetaryAmountFormatProviderSpi;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u00050\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lde/jfachwert/money/internal/WaehrungsformatProvider;", "Ljavax/money/spi/MonetaryAmountFormatProviderSpi;", "<init>", "()V", "availableLocales", "", "Ljava/util/Locale;", "availableFormatNames", "", "", "kotlin.jvm.PlatformType", "Ljava/util/Set;", "getAmountFormats", "", "Ljavax/money/format/MonetaryAmountFormat;", "formatQuery", "Ljavax/money/format/AmountFormatQuery;", "getAvailableLocales", "getAvailableFormatNames", "getProviderName", "Companion", "money"})
public final class WaehrungsformatProvider
implements MonetaryAmountFormatProviderSpi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Locale> availableLocales;
    private final Set<String> availableFormatNames = Collections.unmodifiableSet(SetsKt.setOf((Object)"jfachwert"));
    @JvmField
    @NotNull
    public static final WaehrungsformatProvider INSTANCE = new WaehrungsformatProvider();

    public WaehrungsformatProvider() {
        Set locales = new HashSet();
        Locale locale = Locale.GERMANY;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"GERMANY");
        locales.add(locale);
        Locale[] localeArray = DecimalFormat.getAvailableLocales();
        List<Locale> list = Arrays.asList(Arrays.copyOf(localeArray, localeArray.length));
        Intrinsics.checkNotNullExpressionValue(list, (String)"asList(...)");
        locales.addAll((Collection)list);
        this.availableLocales = Collections.unmodifiableSet(locales);
    }

    @NotNull
    public Collection<MonetaryAmountFormat> getAmountFormats(@NotNull AmountFormatQuery formatQuery) {
        Intrinsics.checkNotNullParameter((Object)formatQuery, (String)"formatQuery");
        Collection amountFormats = new ArrayList();
        if (formatQuery.getProviderNames().contains(this.getProviderName()) || formatQuery.getMonetaryAmountFactory() instanceof GeldbetragFactory) {
            Locale locale = formatQuery.getLocale();
            AmountFormatContextBuilder builder = AmountFormatContextBuilder.of((String)"jfachwert");
            Locale locale2 = locale;
            if (locale2 == null) {
                locale2 = Locale.getDefault();
            }
            builder.setLocale(locale2);
            builder.importContext((AbstractContext)formatQuery, false);
            builder.setMonetaryAmountFactory(formatQuery.getMonetaryAmountFactory());
            AmountFormatContext amountFormatContext = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)amountFormatContext, (String)"build(...)");
            amountFormats.add(GeldbetragFormatter.Companion.of(amountFormatContext));
        } else {
            for (MonetaryAmountFormatProviderSpi spi : Bootstrap.getServices(MonetaryAmountFormatProviderSpi.class)) {
                if (spi instanceof WaehrungsformatProvider) continue;
                Collection collection = spi.getAmountFormats(formatQuery);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAmountFormats(...)");
                amountFormats.addAll(collection);
            }
        }
        return amountFormats;
    }

    @NotNull
    public Set<Locale> getAvailableLocales() {
        return this.availableLocales;
    }

    @NotNull
    public Set<String> getAvailableFormatNames() {
        Set<String> set = this.availableFormatNames;
        Intrinsics.checkNotNullExpressionValue(set, (String)"availableFormatNames");
        return set;
    }

    @NotNull
    public String getProviderName() {
        return "jfachwert";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/jfachwert/money/internal/WaehrungsformatProvider$Companion;", "", "<init>", "()V", "INSTANCE", "Lde/jfachwert/money/internal/WaehrungsformatProvider;", "money"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

