/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.money;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.money.GeldbetragFactory;
import de.jfachwert.money.Waehrung;
import de.jfachwert.money.internal.GeldbetragFormatter;
import de.jfachwert.money.internal.Zahlenwert;
import de.jfachwert.money.pruefung.exception.LocalizedMonetaryException;
import de.jfachwert.pruefung.NumberValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedArithmeticException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryContext;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.NumberValue;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryParseException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 _2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u00022\u00020\u0003:\u0002^_B#\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\f\u00a2\u0006\u0004\b\n\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u000e\u00a2\u0006\u0004\b\n\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0010\u00a2\u0006\u0004\b\n\u0010\u0011B\u0011\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\u0013B\u001d\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b\n\u0010\u0015J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0010J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0014J\b\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0001H\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0001H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0001H\u0016J\u0010\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0001H\u0016J\u0010\u0010%\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0001H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020 H\u0016J\b\u0010*\u001a\u00020 H\u0016J\b\u0010+\u001a\u00020 H\u0016J\b\u0010,\u001a\u00020 H\u0016J\b\u0010-\u001a\u00020 H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0012\u00100\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u00101\u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\fH\u0016J\u0010\u00102\u001a\u00020\u00012\u0006\u00103\u001a\u00020\u000eH\u0016J\u0012\u00102\u001a\u00020\u00012\b\u00103\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\fH\u0016J\u0010\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u00020\u000eH\u0016J\u0012\u00104\u001a\u00020\u00002\b\u00105\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u00106\u001a\u00020\u00002\u0006\u00105\u001a\u00020\fH\u0016J\u0010\u00106\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u000eH\u0016J\u0012\u00106\u001a\u00020\u00002\b\u00105\u001a\u0004\u0018\u00010\u0005H\u0016J\u001b\u00107\u001a\b\u0012\u0004\u0012\u00020\u0000082\u0006\u00105\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u00109J\u001b\u00107\u001a\b\u0012\u0004\u0012\u00020\u0000082\u0006\u00105\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010:J\u001d\u00107\u001a\b\u0012\u0004\u0012\u00020\u0000082\b\u00105\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010;J'\u0010<\u001a\b\u0012\u0004\u0012\u00020\u0000082\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001608\"\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010>J\u0010\u0010?\u001a\u00020\u00002\u0006\u00105\u001a\u00020\fH\u0016J\u0010\u0010?\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u000eH\u0016J\u0010\u0010?\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0005H\u0016J\u0010\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020/H\u0016J\b\u0010B\u001a\u00020\u0000H\u0016J\b\u0010C\u001a\u00020\u0000H\u0016J\b\u0010D\u001a\u00020\u0000H\u0016J\b\u0010E\u001a\u00020\u0000H\u0016J\u0011\u0010F\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010F\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0005H\u0086\u0002J\b\u0010G\u001a\u00020\u0007H\u0016J\b\u0010H\u001a\u00020(H\u0016J\u0006\u0010I\u001a\u00020\u0016J\u0006\u0010J\u001a\u00020\u000eJ\b\u0010K\u001a\u00020/H\u0016J\u0013\u0010L\u001a\u00020 2\b\u0010\u0012\u001a\u0004\u0018\u00010MH\u0096\u0002J\u0010\u0010N\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0001H\u0002J\u0010\u0010O\u001a\u00020P2\u0006\u0010\u0012\u001a\u00020\u0001H\u0002J\u0012\u0010Q\u001a\u00020\u00002\b\u0010R\u001a\u0004\u0018\u00010SH\u0016J#\u0010T\u001a\u0002HU\"\u0004\b\u0000\u0010U2\u000e\u0010T\u001a\n\u0012\u0004\u0012\u0002HU\u0018\u00010VH\u0016\u00a2\u0006\u0002\u0010WJ\u0006\u0010X\u001a\u00020\fJ\u0006\u0010Y\u001a\u00020\u0010J\b\u0010Z\u001a\u00020\u0010H\u0016J\u0006\u0010[\u001a\u00020\u0010J\u000e\u0010\\\u001a\u00020\u00102\u0006\u0010]\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u00a8\u0006`"}, d2={"Lde/jfachwert/money/Geldbetrag;", "Ljavax/money/MonetaryAmount;", "", "Lde/jfachwert/KFachwert;", "betrag", "", "currency", "Ljavax/money/CurrencyUnit;", "context", "Ljavax/money/MonetaryContext;", "<init>", "(Ljava/lang/Number;Ljavax/money/CurrencyUnit;Ljavax/money/MonetaryContext;)V", "", "(J)V", "", "(D)V", "", "(Ljava/lang/String;)V", "other", "(Ljavax/money/MonetaryAmount;)V", "Ljava/util/Currency;", "(Ljava/lang/Number;Ljava/util/Currency;)V", "Ljava/math/BigDecimal;", "getCurrency$annotations", "()V", "withCurrency", "unit", "waehrung", "getContext", "getFactory", "Lde/jfachwert/money/GeldbetragFactory;", "isGreaterThan", "", "amount", "isGreaterThanOrEqualTo", "isLessThan", "isLessThanOrEqualTo", "isEqualTo", "isNumberEqualTo", "value", "Ljavax/money/NumberValue;", "isNegative", "isNegativeOrZero", "isPositive", "isPositiveOrZero", "isZero", "signum", "", "add", "subtract", "multiply", "multiplicand", "divide", "divisor", "remainder", "divideAndRemainder", "", "(J)[Lde/jfachwert/money/Geldbetrag;", "(D)[Lde/jfachwert/money/Geldbetrag;", "(Ljava/lang/Number;)[Lde/jfachwert/money/Geldbetrag;", "toGeldbetragArray", "numbers", "([Ljava/math/BigDecimal;)[Lde/jfachwert/money/Geldbetrag;", "divideToIntegralValue", "scaleByPowerOfTen", "power", "abs", "negate", "plus", "stripTrailingZeros", "compareTo", "getCurrency", "getNumber", "getBetrag", "doubleValue", "hashCode", "equals", "", "hasSameCurrency", "checkCurrency", "", "with", "operator", "Ljavax/money/MonetaryOperator;", "query", "R", "Ljavax/money/MonetaryQuery;", "(Ljavax/money/MonetaryQuery;)Ljava/lang/Object;", "toCent", "toShortString", "toString", "toLongString", "format", "pattern", "Validator", "Companion", "money"})
@SourceDebugExtension(value={"SMAP\nGeldbetrag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geldbetrag.kt\nde/jfachwert/money/Geldbetrag\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,1375:1\n108#2:1376\n80#2,22:1377\n*S KotlinDebug\n*F\n+ 1 Geldbetrag.kt\nde/jfachwert/money/Geldbetrag\n*L\n133#1:1376\n133#1:1377,22\n*E\n"})
public class Geldbetrag
implements MonetaryAmount,
Comparable<MonetaryAmount>,
KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigDecimal betrag;
    @NotNull
    private final MonetaryContext context;
    @NotNull
    private final CurrencyUnit currency;
    @NotNull
    private static final GeldbetragFactory FACTORY = new GeldbetragFactory();
    @NotNull
    private static final GeldbetragFormatter DEFAULT_FORMATTER = new GeldbetragFormatter();
    @NotNull
    private static final NumberValidator NUMBER_VALIDATOR = new NumberValidator(null, null, 3, null);
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new Validator();
    @JvmField
    @NotNull
    public static final Geldbetrag ZERO;
    @JvmField
    @NotNull
    public static final Geldbetrag ONE;
    @JvmField
    @NotNull
    public static final Geldbetrag TEN;
    @JvmField
    @NotNull
    public static final Geldbetrag MIN_VALUE;
    @JvmField
    @NotNull
    public static final Geldbetrag MAX_VALUE;
    @JvmField
    @NotNull
    public static final Geldbetrag NULL;

    @JvmOverloads
    public Geldbetrag(@NotNull Number betrag, @NotNull CurrencyUnit currency, @NotNull MonetaryContext context) {
        Intrinsics.checkNotNullParameter((Object)betrag, (String)"betrag");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.betrag = Geldbetrag.Companion.toBigDecimal(betrag, context);
        this.currency = currency;
        this.context = context;
    }

    public /* synthetic */ Geldbetrag(Number number, CurrencyUnit currencyUnit, MonetaryContext monetaryContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            monetaryContext = FACTORY.getMonetaryContextOf(number);
        }
        this(number, currencyUnit, monetaryContext);
    }

    private static /* synthetic */ void getCurrency$annotations() {
    }

    public Geldbetrag(long betrag) {
        BigDecimal bigDecimal = BigDecimal.valueOf(betrag);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        this(bigDecimal, null, 2, null);
    }

    public Geldbetrag(double betrag) {
        BigDecimal bigDecimal = BigDecimal.valueOf(betrag);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        this(bigDecimal, null, 2, null);
    }

    public Geldbetrag(@NotNull String betrag) {
        Intrinsics.checkNotNullParameter((Object)betrag, (String)"betrag");
        this(Companion.valueOf(betrag));
    }

    public Geldbetrag(@NotNull MonetaryAmount other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        NumberValue numberValue = other.getNumber();
        Intrinsics.checkNotNullExpressionValue((Object)numberValue, (String)"getNumber(...)");
        this((Number)numberValue, Currency.getInstance(other.getCurrency().getCurrencyCode()));
    }

    @JvmOverloads
    public Geldbetrag(@NotNull Number betrag, @Nullable Currency currency) {
        Intrinsics.checkNotNullParameter((Object)betrag, (String)"betrag");
        Currency currency2 = currency;
        Intrinsics.checkNotNull((Object)currency2);
        this(betrag, Waehrung.Companion.of(currency2), null, 4, null);
    }

    public /* synthetic */ Geldbetrag(Number number, Currency currency, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            currency = Waehrung.DEFAULT_CURRENCY;
        }
        this(number, currency);
    }

    @NotNull
    public final Geldbetrag withCurrency(@NotNull CurrencyUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        String string = unit.getCurrencyCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCurrencyCode(...)");
        return this.withCurrency(string);
    }

    @NotNull
    public final Geldbetrag withCurrency(@NotNull String waehrung) {
        String normalized;
        Intrinsics.checkNotNullParameter((Object)waehrung, (String)"waehrung");
        String string = waehrung.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (StringsKt.equals((String)"DM", (String)(normalized = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (boolean)true)) {
            normalized = "DEM";
        }
        return this.withCurrency(Currency.getInstance(normalized));
    }

    @NotNull
    public final Geldbetrag withCurrency(@Nullable Currency currency) {
        return new Geldbetrag((Number)this.getNumber(), currency);
    }

    @NotNull
    public MonetaryContext getContext() {
        return this.context;
    }

    @NotNull
    public GeldbetragFactory getFactory() {
        return new GeldbetragFactory().setCurrency(this.currency).setNumber(this.betrag).setContext(this.context);
    }

    public boolean isGreaterThan(@NotNull MonetaryAmount amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return this.compareTo(amount) > 0;
    }

    public boolean isGreaterThanOrEqualTo(@NotNull MonetaryAmount amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return this.compareTo(amount) >= 0;
    }

    public boolean isLessThan(@NotNull MonetaryAmount amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return this.compareTo(amount) < 0;
    }

    public boolean isLessThanOrEqualTo(@NotNull MonetaryAmount amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        return this.compareTo(amount) <= 0;
    }

    public boolean isEqualTo(@NotNull MonetaryAmount other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.checkCurrency(other);
        NumberValue numberValue = other.getNumber();
        Intrinsics.checkNotNullExpressionValue((Object)numberValue, (String)"getNumber(...)");
        return this.isNumberEqualTo(numberValue);
    }

    private final boolean isNumberEqualTo(NumberValue value) {
        BigDecimal otherValue = Geldbetrag.Companion.toBigDecimal(value, this.context);
        return this.betrag.compareTo(otherValue) == 0;
    }

    public boolean isNegative() {
        return this.betrag.compareTo(BigDecimal.ZERO) < 0;
    }

    public boolean isNegativeOrZero() {
        return this.betrag.compareTo(BigDecimal.ZERO) <= 0;
    }

    public boolean isPositive() {
        return this.betrag.compareTo(BigDecimal.ZERO) > 0;
    }

    public boolean isPositiveOrZero() {
        return this.betrag.compareTo(BigDecimal.ZERO) >= 0;
    }

    public boolean isZero() {
        return this.betrag.compareTo(BigDecimal.ZERO) == 0;
    }

    public int signum() {
        return Geldbetrag.Companion.toBigDecimal(this.getNumber()).signum();
    }

    @NotNull
    public Geldbetrag add(@Nullable MonetaryAmount other) {
        if (this.betrag.compareTo(BigDecimal.ZERO) == 0) {
            MonetaryAmount monetaryAmount = other;
            Intrinsics.checkNotNull((Object)monetaryAmount);
            return Companion.valueOf(monetaryAmount);
        }
        MonetaryAmount monetaryAmount = other;
        Intrinsics.checkNotNull((Object)monetaryAmount);
        NumberValue numberValue = monetaryAmount.getNumber();
        Intrinsics.checkNotNullExpressionValue((Object)numberValue, (String)"getNumber(...)");
        BigDecimal n = Geldbetrag.Companion.toBigDecimal(numberValue, this.context);
        if (n.compareTo(BigDecimal.ZERO) == 0) {
            return this;
        }
        this.checkCurrency(other);
        BigDecimal bigDecimal = this.betrag.add(n);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"add(...)");
        return Companion.valueOf((Number)bigDecimal, this.currency);
    }

    @NotNull
    public Geldbetrag subtract(@Nullable MonetaryAmount amount) {
        MonetaryAmount monetaryAmount = amount;
        Intrinsics.checkNotNull((Object)monetaryAmount);
        return this.add(monetaryAmount.negate());
    }

    @NotNull
    public MonetaryAmount multiply(long multiplicand) {
        return this.multiply(BigDecimal.valueOf(multiplicand));
    }

    @NotNull
    public MonetaryAmount multiply(double multiplicand) {
        return this.multiply(Geldbetrag.Companion.toBigDecimal(multiplicand));
    }

    @NotNull
    public MonetaryAmount multiply(@Nullable Number multiplicand) {
        Number number = multiplicand;
        Intrinsics.checkNotNull((Object)number);
        BigDecimal d = Geldbetrag.Companion.toBigDecimal(number, this.context);
        if (BigDecimal.ONE.compareTo(d) == 0) {
            return this;
        }
        BigDecimal multiplied = this.betrag.multiply(d);
        Intrinsics.checkNotNull((Object)multiplied);
        return Companion.valueOf((Number)multiplied, this.currency);
    }

    @NotNull
    public Geldbetrag divide(long divisor) {
        return this.divide(BigDecimal.valueOf(divisor));
    }

    @NotNull
    public MonetaryAmount divide(double divisor) {
        MonetaryAmount monetaryAmount;
        if (Geldbetrag.Companion.isInfinite(divisor)) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
            monetaryAmount = Companion.valueOf((Number)bigDecimal, this.currency);
        } else {
            monetaryAmount = this.divide(BigDecimal.valueOf(divisor));
        }
        return monetaryAmount;
    }

    @NotNull
    public Geldbetrag divide(@Nullable Number divisor) {
        Geldbetrag geldbetrag;
        Number number = divisor;
        Intrinsics.checkNotNull((Object)number);
        BigDecimal d = Geldbetrag.Companion.toBigDecimal(number, this.context);
        if (BigDecimal.ONE.compareTo(d) == 0) {
            geldbetrag = this;
        } else {
            BigDecimal bigDecimal = this.betrag.setScale(4, RoundingMode.HALF_UP).divide(d, RoundingMode.HALF_UP);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"divide(...)");
            geldbetrag = Companion.valueOf((Number)bigDecimal, this.currency);
        }
        return geldbetrag;
    }

    @NotNull
    public Geldbetrag remainder(long divisor) {
        return this.remainder(BigDecimal.valueOf(divisor));
    }

    @NotNull
    public Geldbetrag remainder(double divisor) {
        return Geldbetrag.Companion.isInfinite(divisor) ? Companion.valueOf((Number)0, this.currency) : this.remainder(Geldbetrag.Companion.toBigDecimal(divisor));
    }

    @NotNull
    public Geldbetrag remainder(@Nullable Number divisor) {
        Number number = divisor;
        Intrinsics.checkNotNull((Object)number);
        BigDecimal bigDecimal = this.betrag.remainder(Geldbetrag.Companion.toBigDecimal(number, this.context));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"remainder(...)");
        return Companion.valueOf((Number)bigDecimal, this.currency);
    }

    @NotNull
    public Geldbetrag[] divideAndRemainder(long divisor) {
        return this.divideAndRemainder(BigDecimal.valueOf(divisor));
    }

    @NotNull
    public Geldbetrag[] divideAndRemainder(double divisor) {
        Geldbetrag[] geldbetragArray;
        if (Geldbetrag.Companion.isInfinite(divisor)) {
            BigDecimal[] bigDecimalArray = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
            geldbetragArray = this.toGeldbetragArray(bigDecimalArray);
        } else {
            geldbetragArray = this.divideAndRemainder(BigDecimal.valueOf(divisor));
        }
        return geldbetragArray;
    }

    @NotNull
    public Geldbetrag[] divideAndRemainder(@Nullable Number divisor) {
        Number number = divisor;
        Intrinsics.checkNotNull((Object)number);
        BigDecimal[] numbers = this.betrag.divideAndRemainder(Geldbetrag.Companion.toBigDecimal(number, this.context));
        return this.toGeldbetragArray(Arrays.copyOf(numbers, numbers.length));
    }

    private final Geldbetrag[] toGeldbetragArray(BigDecimal ... numbers) {
        int n = 0;
        int n2 = numbers.length;
        Geldbetrag[] geldbetragArray = new Geldbetrag[n2];
        while (n < n2) {
            int n3 = n++;
            geldbetragArray[n3] = Companion.valueOf((Number)numbers[n3], this.currency);
        }
        Geldbetrag[] betraege = geldbetragArray;
        return betraege;
    }

    @NotNull
    public Geldbetrag divideToIntegralValue(long divisor) {
        BigDecimal bigDecimal = BigDecimal.valueOf(divisor);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return this.divideToIntegralValue(bigDecimal);
    }

    @NotNull
    public Geldbetrag divideToIntegralValue(double divisor) {
        BigDecimal bigDecimal = BigDecimal.valueOf(divisor);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return this.divideToIntegralValue(bigDecimal);
    }

    @NotNull
    public Geldbetrag divideToIntegralValue(@NotNull Number divisor) {
        Intrinsics.checkNotNullParameter((Object)divisor, (String)"divisor");
        BigDecimal bigDecimal = this.betrag.divideToIntegralValue(Geldbetrag.Companion.toBigDecimal(divisor, this.context));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"divideToIntegralValue(...)");
        return Companion.valueOf((Number)bigDecimal, this.currency);
    }

    @NotNull
    public Geldbetrag scaleByPowerOfTen(int power) {
        BigDecimal scaled = this.betrag.scaleByPowerOfTen(power);
        Intrinsics.checkNotNull((Object)scaled);
        return Companion.roundedValueOf(scaled, this.getCurrency(), this.context);
    }

    @NotNull
    public Geldbetrag abs() {
        return this.betrag.compareTo(BigDecimal.ZERO) < 0 ? this.negate() : this;
    }

    @NotNull
    public Geldbetrag negate() {
        BigDecimal bigDecimal = this.betrag.negate();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"negate(...)");
        return Companion.valueOf((Number)bigDecimal, this.currency);
    }

    @NotNull
    public Geldbetrag plus() {
        return this.betrag.compareTo(BigDecimal.ZERO) < 0 ? this.negate() : this;
    }

    @NotNull
    public Geldbetrag stripTrailingZeros() {
        Geldbetrag geldbetrag;
        if (this.isZero()) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
            geldbetrag = Companion.valueOf((Number)bigDecimal, this.getCurrency());
        } else {
            BigDecimal bigDecimal = this.betrag.stripTrailingZeros();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"stripTrailingZeros(...)");
            geldbetrag = Companion.valueOf((Number)bigDecimal, this.getCurrency(), this.context);
        }
        return geldbetrag;
    }

    @Override
    public int compareTo(@NotNull MonetaryAmount other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string = this.getCurrency().getCurrencyCode();
        String string2 = other.getCurrency().getCurrencyCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCurrencyCode(...)");
        int compare = string.compareTo(string2);
        if (compare == 0) {
            NumberValue numberValue = other.getNumber();
            Intrinsics.checkNotNullExpressionValue((Object)numberValue, (String)"getNumber(...)");
            BigDecimal n = Geldbetrag.Companion.toBigDecimal(numberValue);
            return this.betrag.compareTo(n);
        }
        return compare;
    }

    @Override
    public final int compareTo(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(Companion.valueOf(other, this.currency));
    }

    @NotNull
    public CurrencyUnit getCurrency() {
        return this.currency;
    }

    @NotNull
    public NumberValue getNumber() {
        return new Zahlenwert(this.betrag);
    }

    @NotNull
    public final BigDecimal getBetrag() {
        BigDecimal bigDecimal = this.betrag.setScale(2, RoundingMode.HALF_UP);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"setScale(...)");
        return bigDecimal;
    }

    public final double doubleValue() {
        return this.betrag.doubleValue();
    }

    public int hashCode() {
        return this.betrag.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Geldbetrag)) {
            return false;
        }
        return !this.hasSameCurrency((MonetaryAmount)other) ? false : Intrinsics.areEqual((Object)this.toString(), (Object)((Geldbetrag)other).toString());
    }

    private final boolean hasSameCurrency(MonetaryAmount other) {
        Waehrung waehrung = Waehrung.Companion.of(this.getCurrency());
        CurrencyUnit currencyUnit = other.getCurrency();
        Intrinsics.checkNotNullExpressionValue((Object)currencyUnit, (String)"getCurrency(...)");
        return Intrinsics.areEqual((Object)waehrung, (Object)Waehrung.Companion.of(currencyUnit));
    }

    private final void checkCurrency(MonetaryAmount other) {
        if (!this.hasSameCurrency(other)) {
            Object[] objectArray = new Object[]{this, other};
            throw new LocalizedMonetaryException("different currencies", objectArray);
        }
    }

    @NotNull
    public Geldbetrag with(@Nullable MonetaryOperator operator) {
        Geldbetrag geldbetrag;
        Objects.requireNonNull(operator);
        try {
            MonetaryOperator monetaryOperator = operator;
            Intrinsics.checkNotNull((Object)monetaryOperator);
            MonetaryAmount monetaryAmount = monetaryOperator.apply((MonetaryAmount)this);
            Intrinsics.checkNotNull((Object)monetaryAmount, (String)"null cannot be cast to non-null type de.jfachwert.money.Geldbetrag");
            geldbetrag = (Geldbetrag)monetaryAmount;
        }
        catch (MonetaryException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            Object[] objectArray = new Object[]{operator, ex};
            throw new LocalizedMonetaryException("operator failed", objectArray);
        }
        return geldbetrag;
    }

    public <R> R query(@Nullable MonetaryQuery<R> query) {
        Object object;
        Objects.requireNonNull(query);
        try {
            MonetaryQuery<R> monetaryQuery = query;
            Intrinsics.checkNotNull(monetaryQuery);
            object = monetaryQuery.queryFrom((MonetaryAmount)this);
        }
        catch (MonetaryException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            Object[] objectArray = new Object[]{query, ex};
            throw new LocalizedMonetaryException("query failed", objectArray);
        }
        return (R)object;
    }

    public final long toCent() {
        return this.betrag.movePointRight(2).longValueExact();
    }

    @NotNull
    public final String toShortString() {
        return this.format("$#");
    }

    @NotNull
    public String toString() {
        String string = DEFAULT_FORMATTER.format(this);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final String toLongString() {
        NumberFormat formatter = DecimalFormat.getInstance();
        formatter.setMinimumFractionDigits(this.context.getMaxScale());
        formatter.setMinimumFractionDigits(this.context.getMaxScale());
        return formatter.format(this.betrag) + " " + this.currency;
    }

    @NotNull
    public final String format(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        GeldbetragFormatter formatter = GeldbetragFormatter.Companion.of(pattern);
        String string = formatter.format(this);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap((KFachwert)this);
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    @JvmOverloads
    public Geldbetrag(@NotNull Number betrag, @NotNull CurrencyUnit currency) {
        Intrinsics.checkNotNullParameter((Object)betrag, (String)"betrag");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        this(betrag, currency, null, 4, null);
    }

    @JvmOverloads
    public Geldbetrag(@NotNull Number betrag) {
        Intrinsics.checkNotNullParameter((Object)betrag, (String)"betrag");
        this(betrag, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag fromCent(long cents) {
        return Companion.fromCent(cents);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geldbetrag ofMinor(@NotNull CurrencyUnit currency, long amountMinor, int fractionDigits) {
        return Companion.ofMinor(currency, amountMinor, fractionDigits);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull String other) {
        return Companion.of(other);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull String other) {
        return Companion.valueOf(other);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(long value) {
        return Companion.of(value);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(long value) {
        return Companion.valueOf(value);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(double value) {
        return Companion.of(value);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(double value) {
        return Companion.valueOf(value);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull Number value, @NotNull String currency) {
        return Companion.of(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull Number value, @NotNull String currency) {
        return Companion.valueOf(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull Number value) {
        return Companion.of(value);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull Number value, @NotNull Currency currency) {
        return Companion.of(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull Number value, @NotNull Currency currency) {
        return Companion.valueOf(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull Number value, @NotNull CurrencyUnit currency) {
        return Companion.of(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull Number value, @NotNull CurrencyUnit currency) {
        return Companion.valueOf(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull Number value, @NotNull String currency, @NotNull MonetaryContext monetaryContext) {
        return Companion.of(value, currency, monetaryContext);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull Number value, @NotNull String currency, @NotNull MonetaryContext monetaryContext) {
        return Companion.valueOf(value, currency, monetaryContext);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
        return Companion.of(value, currency, monetaryContext);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
        return Companion.valueOf(value, currency, monetaryContext);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag roundedValueOf(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
        return Companion.roundedValueOf(value, currency, monetaryContext);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geldbetrag parse(@Nullable CharSequence text, @NotNull MonetaryAmountFormat formatter) {
        return Companion.parse(text, formatter);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag from(@NotNull MonetaryAmount other) {
        return Companion.from(other);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull MonetaryAmount other) {
        return Companion.of(other);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull MonetaryAmount other) {
        return Companion.valueOf(other);
    }

    @JvmStatic
    @NotNull
    public static final String validate(@NotNull String zahl) {
        return Companion.validate(zahl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geldbetrag ofMinor(@NotNull CurrencyUnit currency, long amountMinor) {
        return Companion.ofMinor(currency, amountMinor);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geldbetrag parse(@Nullable CharSequence text) {
        return Companion.parse(text);
    }

    static {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
        ZERO = new Geldbetrag(bigDecimal, null, 2, null);
        BigDecimal bigDecimal2 = BigDecimal.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"ONE");
        ONE = new Geldbetrag(bigDecimal2, null, 2, null);
        BigDecimal bigDecimal3 = BigDecimal.TEN;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"TEN");
        TEN = new Geldbetrag(bigDecimal3, null, 2, null);
        BigDecimal bigDecimal4 = BigDecimal.valueOf(Long.MIN_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"valueOf(...)");
        MIN_VALUE = new Geldbetrag(bigDecimal4, null, 2, null);
        BigDecimal bigDecimal5 = BigDecimal.valueOf(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"valueOf(...)");
        MAX_VALUE = new Geldbetrag(bigDecimal5, null, 2, null);
        NULL = ZERO;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\"\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\fH\u0007J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\fH\u0007J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0016H\u0007J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0016H\u0007J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0007J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\fH\u0007J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\fH\u0007J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"H\u0007J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020#H\u0007J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020#H\u0007J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u0007J \u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u0007J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0007J \u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0007J \u0010&\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0007J\u001c\u0010'\u001a\u00020\u000e2\b\u0010(\u001a\u0004\u0018\u00010)2\b\b\u0002\u0010*\u001a\u00020+H\u0007J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020-H\u0007J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020-H\u0007J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020-H\u0007J\u0010\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\fH\u0007J\u0010\u00100\u001a\u0002012\u0006\u0010 \u001a\u000202H\u0002J\u0018\u00100\u001a\u0002012\u0006\u0010 \u001a\u0002022\u0006\u00103\u001a\u00020%H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020!H\u0002J\u0018\u00100\u001a\u0002012\u0006\u0010 \u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u00107\u001a\u0002012\u0006\u0010 \u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010 \u001a\u00020\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lde/jfachwert/money/Geldbetrag$Companion;", "", "<init>", "()V", "FACTORY", "Lde/jfachwert/money/GeldbetragFactory;", "DEFAULT_FORMATTER", "Lde/jfachwert/money/internal/GeldbetragFormatter;", "NUMBER_VALIDATOR", "Lde/jfachwert/pruefung/NumberValidator;", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "ZERO", "Lde/jfachwert/money/Geldbetrag;", "ONE", "TEN", "MIN_VALUE", "MAX_VALUE", "NULL", "fromCent", "cents", "", "ofMinor", "currency", "Ljavax/money/CurrencyUnit;", "amountMinor", "fractionDigits", "", "of", "other", "valueOf", "value", "", "", "Ljava/util/Currency;", "monetaryContext", "Ljavax/money/MonetaryContext;", "roundedValueOf", "parse", "text", "", "formatter", "Ljavax/money/format/MonetaryAmountFormat;", "from", "Ljavax/money/MonetaryAmount;", "validate", "zahl", "toBigDecimal", "Ljava/math/BigDecimal;", "Ljavax/money/NumberValue;", "mc", "isInfinite", "", "divisor", "toBigDecimalRounded", "money"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag fromCent(long cents) {
            return de.jfachwert.money.Geldbetrag$Companion.ofMinor$default(this, Waehrung.Companion.of("EUR"), cents, 0, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geldbetrag ofMinor(@NotNull CurrencyUnit currency, long amountMinor, int fractionDigits) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            BigDecimal bigDecimal = BigDecimal.valueOf(amountMinor, fractionDigits);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            return this.of((Number)bigDecimal, currency);
        }

        public static /* synthetic */ Geldbetrag ofMinor$default(Companion companion, CurrencyUnit currencyUnit, long l, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = currencyUnit.getDefaultFractionDigits();
            }
            return companion.ofMinor(currencyUnit, l, n);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull String other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.valueOf(other);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull String other) {
            Geldbetrag geldbetrag;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            try {
                MonetaryAmount monetaryAmount = DEFAULT_FORMATTER.parse((CharSequence)other);
                Intrinsics.checkNotNull((Object)monetaryAmount, (String)"null cannot be cast to non-null type de.jfachwert.money.Geldbetrag");
                geldbetrag = (Geldbetrag)monetaryAmount;
            }
            catch (MonetaryParseException ex) {
                throw new IllegalArgumentException(other, ex);
            }
            return geldbetrag;
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(long value) {
            return this.valueOf(new Geldbetrag(value));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(long value) {
            return this.valueOf(new Geldbetrag(value));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(double value) {
            return this.valueOf(new Geldbetrag(value));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(double value) {
            return this.valueOf(new Geldbetrag(value));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull Number value, @NotNull String currency) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            return this.valueOf(value, currency);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull Number value, @NotNull String currency) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            return this.valueOf(value, Waehrung.Companion.toCurrency(currency));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull Number value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.valueOf(value, Waehrung.EUR);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull Number value, @NotNull Currency currency) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            return this.valueOf(value, currency);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull Number value, @NotNull Currency currency) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            return this.valueOf(new Geldbetrag(value, currency));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull Number value, @NotNull CurrencyUnit currency) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            return this.valueOf(value, currency);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull Number value, @NotNull CurrencyUnit currency) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            return this.valueOf(new Geldbetrag(value, currency, null, 4, null));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull Number value, @NotNull String currency, @NotNull MonetaryContext monetaryContext) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            Intrinsics.checkNotNullParameter((Object)monetaryContext, (String)"monetaryContext");
            return this.valueOf(value, currency, monetaryContext);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull Number value, @NotNull String currency, @NotNull MonetaryContext monetaryContext) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            Intrinsics.checkNotNullParameter((Object)monetaryContext, (String)"monetaryContext");
            return this.valueOf(value, Waehrung.Companion.of(currency), monetaryContext);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            Intrinsics.checkNotNullParameter((Object)monetaryContext, (String)"monetaryContext");
            return this.valueOf(value, currency, monetaryContext);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            Intrinsics.checkNotNullParameter((Object)monetaryContext, (String)"monetaryContext");
            return this.valueOf(new Geldbetrag(value, currency, monetaryContext));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag roundedValueOf(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            Intrinsics.checkNotNullParameter((Object)monetaryContext, (String)"monetaryContext");
            BigDecimal roundedValue = this.toBigDecimalRounded(value, monetaryContext);
            return this.valueOf(new Geldbetrag(roundedValue, currency, monetaryContext));
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geldbetrag parse(@Nullable CharSequence text, @NotNull MonetaryAmountFormat formatter) {
            Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
            MonetaryAmount monetaryAmount = formatter.parse(text);
            Intrinsics.checkNotNullExpressionValue((Object)monetaryAmount, (String)"parse(...)");
            return this.from(monetaryAmount);
        }

        public static /* synthetic */ Geldbetrag parse$default(Companion companion, CharSequence charSequence, MonetaryAmountFormat monetaryAmountFormat, int n, Object object) {
            if ((n & 2) != 0) {
                monetaryAmountFormat = DEFAULT_FORMATTER;
            }
            return companion.parse(charSequence, monetaryAmountFormat);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag from(@NotNull MonetaryAmount other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.of(other);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull MonetaryAmount other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.valueOf(other);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull MonetaryAmount other) {
            Geldbetrag geldbetrag;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (other instanceof Geldbetrag) {
                return (Geldbetrag)other;
            }
            BigDecimal value = (BigDecimal)other.getNumber().numberValue(BigDecimal.class);
            if (Intrinsics.areEqual((Object)value, (Object)BigDecimal.ZERO)) {
                geldbetrag = ZERO;
            } else {
                Intrinsics.checkNotNull((Object)value);
                Geldbetrag geldbetrag2 = new Geldbetrag(value, null, 2, null);
                CurrencyUnit currencyUnit = other.getCurrency();
                Intrinsics.checkNotNullExpressionValue((Object)currencyUnit, (String)"getCurrency(...)");
                geldbetrag = geldbetrag2.withCurrency(currencyUnit);
            }
            return geldbetrag;
        }

        @JvmStatic
        @NotNull
        public final String validate(@NotNull String zahl) {
            Intrinsics.checkNotNullParameter((Object)zahl, (String)"zahl");
            return (String)((Object)VALIDATOR.validate((Serializable)((Object)zahl)));
        }

        private final BigDecimal toBigDecimal(NumberValue value) {
            Number number = value.numberValue(BigDecimal.class);
            Intrinsics.checkNotNullExpressionValue((Object)number, (String)"numberValue(...)");
            return (BigDecimal)number;
        }

        private final BigDecimal toBigDecimal(NumberValue value, MonetaryContext mc) {
            Number n = this.toBigDecimal(value);
            return this.toBigDecimal(n, mc);
        }

        private final BigDecimal toBigDecimal(double value) {
            NUMBER_VALIDATOR.verifyNumber((Number)value);
            BigDecimal bigDecimal = BigDecimal.valueOf(value);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            return bigDecimal;
        }

        private final boolean isInfinite(double divisor) {
            if (divisor == Double.POSITIVE_INFINITY || divisor == Double.NEGATIVE_INFINITY) {
                return true;
            }
            if (Double.isNaN(divisor)) {
                throw new ArithmeticException("invalid number: NaN");
            }
            return false;
        }

        private final BigDecimal toBigDecimal(Number value, MonetaryContext monetaryContext) {
            BigDecimal rounded;
            BigDecimal n = this.toBigDecimal(value);
            if (n.compareTo(rounded = this.toBigDecimalRounded(value, monetaryContext)) != 0) {
                throw new LocalizedArithmeticException((Serializable)value, "lost_precision");
            }
            return n;
        }

        private final BigDecimal toBigDecimalRounded(Number value, MonetaryContext monetaryContext) {
            BigDecimal bigDecimal;
            int scale;
            BigDecimal n = this.toBigDecimal(value);
            RoundingMode roundingMode = (RoundingMode)((Object)monetaryContext.get(RoundingMode.class));
            if (roundingMode == null) {
                roundingMode = RoundingMode.HALF_UP;
            }
            if ((scale = monetaryContext.getMaxScale()) <= 0) {
                bigDecimal = n;
            } else {
                BigDecimal scaled;
                BigDecimal bigDecimal2 = scaled = n.setScale(scale, roundingMode);
                Intrinsics.checkNotNull((Object)bigDecimal2);
                bigDecimal = bigDecimal2;
            }
            return bigDecimal;
        }

        private final BigDecimal toBigDecimal(Number value) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Zahlenwert) {
                return ((Zahlenwert)((Object)value)).numberValue(BigDecimal.class);
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(value.doubleValue());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            return bigDecimal;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geldbetrag ofMinor(@NotNull CurrencyUnit currency, long amountMinor) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            return de.jfachwert.money.Geldbetrag$Companion.ofMinor$default(this, currency, amountMinor, 0, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geldbetrag parse(@Nullable CharSequence text) {
            return de.jfachwert.money.Geldbetrag$Companion.parse$default(this, text, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lde/jfachwert/money/Geldbetrag$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "<init>", "()V", "validate", "value", "money"})
    public static final class Validator
    implements KSimpleValidator<String> {
        @NotNull
        public String validate(@NotNull String value) {
            String string;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                string = Companion.valueOf(value).toString();
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidValueException((Serializable)((Object)value), "money_amount", (Throwable)ex);
            }
            return string;
        }

        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject((KSimpleValidator)this, (Object)value);
        }

        @NotNull
        public String verify(@NotNull String value) {
            return (String)((Object)KSimpleValidator.DefaultImpls.verify((KSimpleValidator)this, (Serializable)((Serializable)((Object)value))));
        }
    }
}

