/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.money;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.money.pruefung.exception.LocalizedUnknownCurrencyException;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyContext;
import javax.money.CurrencyUnit;
import javax.money.UnknownCurrencyException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0017\u0018\u0000 !2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0003:\u0002!\"B\u001f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0011\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0003H\u0096\u0002J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lde/jfachwert/money/Waehrung;", "Lde/jfachwert/KFachwert;", "", "Ljavax/money/CurrencyUnit;", "code", "Ljava/util/Currency;", "validator", "Lde/jfachwert/KSimpleValidator;", "<init>", "(Ljava/util/Currency;Lde/jfachwert/KSimpleValidator;)V", "", "(Ljava/lang/String;)V", "(Ljava/util/Currency;)V", "getCode", "()Ljava/util/Currency;", "currency", "getCurrency", "getCurrencyCode", "getNumericCode", "", "getDefaultFractionDigits", "getContext", "Ljavax/money/CurrencyContext;", "symbol", "getSymbol", "()Ljava/lang/String;", "compareTo", "other", "equals", "", "", "hashCode", "toString", "Companion", "Validator", "money"})
public class Waehrung
implements KFachwert,
Comparable<CurrencyUnit>,
CurrencyUnit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Currency code;
    private static final Logger log = Logger.getLogger(Waehrung.class.getName());
    @NotNull
    private static final Map<String, Waehrung> CACHE = new HashMap();
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new Validator();
    @JvmField
    @NotNull
    public static final Currency DEFAULT_CURRENCY = de.jfachwert.money.Waehrung$Companion.access$getDefaultCurrency(Companion);
    @JvmField
    @NotNull
    public static final Waehrung DEFAULT = new Waehrung(DEFAULT_CURRENCY);
    @JvmField
    @NotNull
    public static final Waehrung EUR = Companion.of("EUR");
    @JvmField
    @NotNull
    public static final Waehrung NULL = new Waehrung("XXX");

    protected Waehrung(@NotNull Currency code, @NotNull KSimpleValidator<Currency> validator) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        this.code = (Currency)validator.verify((Serializable)code);
    }

    @NotNull
    public final Currency getCode() {
        return this.code;
    }

    public Waehrung(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this(Companion.toCurrency(code));
    }

    public Waehrung(@NotNull Currency code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this(code, (KSimpleValidator<Currency>)((KSimpleValidator)new NullValidator()));
    }

    @NotNull
    public final Currency getCurrency() {
        return this.code;
    }

    @NotNull
    public String getCurrencyCode() {
        String string = this.code.getCurrencyCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCurrencyCode(...)");
        return string;
    }

    public int getNumericCode() {
        return this.code.getNumericCode();
    }

    public int getDefaultFractionDigits() {
        return this.code.getDefaultFractionDigits();
    }

    @NotNull
    public CurrencyContext getContext() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @NotNull
    public final String getSymbol() {
        String string = this.code.getSymbol();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSymbol(...)");
        return string;
    }

    @Override
    public int compareTo(@NotNull CurrencyUnit other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string = this.getCurrencyCode();
        String string2 = other.getCurrencyCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCurrencyCode(...)");
        return string.compareTo(string2);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Waehrung)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.code, (Object)((Waehrung)other).code);
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getCurrencyCode();
    }

    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap((KFachwert)this);
    }

    public boolean isValid() {
        return KFachwert.DefaultImpls.isValid((KFachwert)this);
    }

    @JvmStatic
    @NotNull
    public static final Waehrung of(@NotNull Currency currency) {
        return Companion.of(currency);
    }

    @JvmStatic
    @NotNull
    public static final Waehrung of(@NotNull CurrencyUnit currencyUnit) {
        return Companion.of(currencyUnit);
    }

    @JvmStatic
    @NotNull
    public static final Waehrung of(@NotNull String currency) {
        return Companion.of(currency);
    }

    @JvmStatic
    @NotNull
    public static final Currency toCurrency(@NotNull String name) {
        return Companion.toCurrency(name);
    }

    @JvmStatic
    @NotNull
    public static final String validate(@NotNull String code) {
        return Companion.validate(code);
    }

    @JvmStatic
    @NotNull
    public static final String getSymbol(@NotNull CurrencyUnit cu) {
        return Companion.getSymbol(cu);
    }

    static {
        CACHE.put(DEFAULT_CURRENCY.getCurrencyCode(), DEFAULT);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\nH\u0007J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\nH\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J!\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\n2\n\u0010\u001d\u001a\u00060\u001fj\u0002`\u001eH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0007J\u0010\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0016H\u0007R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lde/jfachwert/money/Waehrung$Companion;", "", "<init>", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "Ljava/util/logging/Logger;", "CACHE", "", "", "Lde/jfachwert/money/Waehrung;", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "DEFAULT_CURRENCY", "Ljava/util/Currency;", "DEFAULT", "EUR", "NULL", "of", "currency", "currencyUnit", "Ljavax/money/CurrencyUnit;", "toCurrency", "name", "matchesCurrency", "", "c", "toFallbackCurrency", "iae", "Lkotlin/IllegalArgumentException;", "Ljava/lang/IllegalArgumentException;", "(Ljava/lang/String;Ljava/lang/IllegalArgumentException;)Ljava/util/Currency;", "validate", "code", "getSymbol", "cu", "defaultCurrency", "getDefaultCurrency", "()Ljava/util/Currency;", "money"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Waehrung of(@NotNull Currency currency) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            String key = currency.getCurrencyCode();
            Waehrung waehrung = CACHE.computeIfAbsent(key, arg_0 -> Companion.of$lambda$1(arg_0 -> Companion.of$lambda$0(currency, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)waehrung, (String)"computeIfAbsent(...)");
            return waehrung;
        }

        @JvmStatic
        @NotNull
        public final Waehrung of(@NotNull CurrencyUnit currencyUnit) {
            Waehrung waehrung;
            Intrinsics.checkNotNullParameter((Object)currencyUnit, (String)"currencyUnit");
            if (currencyUnit instanceof Waehrung) {
                waehrung = (Waehrung)currencyUnit;
            } else {
                String string = currencyUnit.getCurrencyCode();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCurrencyCode(...)");
                waehrung = this.of(string);
            }
            return waehrung;
        }

        @JvmStatic
        @NotNull
        public final Waehrung of(@NotNull String currency) {
            Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
            return this.of(this.toCurrency(currency));
        }

        @JvmStatic
        @NotNull
        public final Currency toCurrency(@NotNull String name) {
            Currency currency;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            try {
                currency = Currency.getInstance(name);
            }
            catch (IllegalArgumentException iae) {
                Object object;
                if (name.length() <= 3) {
                    for (Currency c : Currency.getAvailableCurrencies()) {
                        Intrinsics.checkNotNull((Object)c);
                        if (!this.matchesCurrency(name, c)) continue;
                        return c;
                    }
                    object = this.toFallbackCurrency(name, iae);
                } else {
                    Currency currency2;
                    try {
                        String string = name.substring(0, 3);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        currency2 = this.toCurrency(string);
                    }
                    catch (LocalizedUnknownCurrencyException ex) {
                        throw new LocalizedUnknownCurrencyException(name, (Throwable)((Object)ex));
                    }
                    object = currency2;
                }
                currency = object;
            }
            return currency;
        }

        private final boolean matchesCurrency(String name, Currency c) {
            return StringsKt.equals((String)name, (String)c.getCurrencyCode(), (boolean)true) || StringsKt.equals((String)name, (String)c.getSymbol(), (boolean)true);
        }

        private final Currency toFallbackCurrency(String name, IllegalArgumentException iae) {
            if (!Intrinsics.areEqual((Object)name, (Object)"\u20ac")) {
                throw new LocalizedUnknownCurrencyException(name, iae);
            }
            Currency currency = Currency.getInstance("EUR");
            Intrinsics.checkNotNull((Object)currency);
            return currency;
        }

        @JvmStatic
        @NotNull
        public final String validate(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return (String)((Object)VALIDATOR.validate((Serializable)((Object)code)));
        }

        @JvmStatic
        @NotNull
        public final String getSymbol(@NotNull CurrencyUnit cu) {
            String string;
            Intrinsics.checkNotNullParameter((Object)cu, (String)"cu");
            try {
                string = this.of(cu).getSymbol();
            }
            catch (IllegalArgumentException ex) {
                log.log(Level.FINE, "Kann das Symbol fuer '" + cu + "' nicht ermitteln:", ex);
                string = cu.getCurrencyCode();
            }
            return string;
        }

        private final Currency getDefaultCurrency() {
            Locale[] localeArray = new Locale[]{Locale.getDefault(), Locale.GERMANY, Locale.GERMAN};
            for (Locale loc : localeArray) {
                try {
                    Currency currency = Currency.getInstance(loc);
                    Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"getInstance(...)");
                    return currency;
                }
                catch (IllegalArgumentException iae) {
                    log.log(Level.FINE, "Keine Waehrung fuer Locale '" + loc + "' verhanden - versuche es mit einer anderen.");
                    log.log(Level.FINER, "Details:", iae);
                }
            }
            Currency currency = Currency.getAvailableCurrencies().iterator().next();
            Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"next(...)");
            return currency;
        }

        private static final Waehrung of$lambda$0(Currency $currency, String string) {
            Intrinsics.checkNotNullParameter((Object)$currency, (String)"$currency");
            return new Waehrung($currency);
        }

        private static final Waehrung of$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Waehrung)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Currency access$getDefaultCurrency(Companion $this) {
            return $this.getDefaultCurrency();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lde/jfachwert/money/Waehrung$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "<init>", "()V", "validate", "value", "money"})
    public static final class Validator
    implements KSimpleValidator<String> {
        @NotNull
        public String validate(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                Companion.toCurrency(value);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidValueException((Serializable)((Object)value), "currency", (Throwable)ex);
            }
            catch (UnknownCurrencyException ex) {
                throw new InvalidValueException((Serializable)((Object)value), "currency", (Throwable)ex);
            }
            return value;
        }

        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject((KSimpleValidator)this, (Object)value);
        }

        @NotNull
        public String verify(@NotNull String value) {
            return (String)((Object)KSimpleValidator.DefaultImpls.verify((KSimpleValidator)this, (Serializable)((Serializable)((Object)value))));
        }
    }
}

