/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.money.internal;

import de.jfachwert.Text;
import de.jfachwert.money.Geldbetrag;
import de.jfachwert.money.Waehrung;
import de.jfachwert.money.pruefung.exception.LocalizedMonetaryParseException;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.NumberValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.ValidationException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatContextBuilder;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryParseException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bB\u0011\b\u0012\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\u000bJ\b\u0010\f\u001a\u00020\u0003H\u0016J!\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0011j\u0002`\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010&\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lde/jfachwert/money/internal/GeldbetragFormatter;", "Ljavax/money/format/MonetaryAmountFormat;", "context", "Ljavax/money/format/AmountFormatContext;", "pattern", "", "<init>", "(Ljavax/money/format/AmountFormatContext;Ljava/lang/String;)V", "()V", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "getContext", "print", "", "appendable", "Lkotlin/text/Appendable;", "Ljava/lang/Appendable;", "amount", "Ljavax/money/MonetaryAmount;", "(Ljava/lang/Appendable;Ljavax/money/MonetaryAmount;)V", "getFractionDigits", "", "currency", "Ljavax/money/CurrencyUnit;", "getCurrencyString", "cu", "getFormatter", "Ljava/text/NumberFormat;", "parse", "text", "", "getMonetaryAmount", "cry", "Ljava/util/Currency;", "n", "Ljava/math/BigDecimal;", "queryFrom", "toString", "Companion", "money"})
@SourceDebugExtension(value={"SMAP\nGeldbetragFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeldbetragFormatter.kt\nde/jfachwert/money/internal/GeldbetragFormatter\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,220:1\n108#2:221\n80#2,22:222\n*S KotlinDebug\n*F\n+ 1 GeldbetragFormatter.kt\nde/jfachwert/money/internal/GeldbetragFormatter\n*L\n175#1:221\n175#1:222,22\n*E\n"})
public final class GeldbetragFormatter
implements MonetaryAmountFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AmountFormatContext context;
    @NotNull
    private final String pattern;
    @NotNull
    private static final Map<Locale, Locale> MAPPED_LOCALES = new HashMap();
    private static final AmountFormatContext DEFAULT_CONTEXT = AmountFormatContextBuilder.of((String)"jfachwert").setLocale(Locale.getDefault()).build();

    private GeldbetragFormatter(AmountFormatContext context, String pattern) {
        this.context = context;
        this.pattern = pattern;
    }

    /* synthetic */ GeldbetragFormatter(AmountFormatContext amountFormatContext, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "#.##\u00a0$$$";
        }
        this(amountFormatContext, string);
    }

    public GeldbetragFormatter() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        this(locale);
    }

    private GeldbetragFormatter(Locale locale) {
        AmountFormatContext amountFormatContext = AmountFormatContextBuilder.of((String)"jfachwert").setLocale(locale).build();
        Intrinsics.checkNotNullExpressionValue((Object)amountFormatContext, (String)"build(...)");
        this(amountFormatContext, null, 2, null);
    }

    @NotNull
    public AmountFormatContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(@NotNull Appendable appendable, @NotNull MonetaryAmount amount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"appendable");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        CurrencyUnit currency = amount.getCurrency();
        Intrinsics.checkNotNull((Object)currency);
        int fractionDigits = this.getFractionDigits(currency);
        String currencyString = this.getCurrencyString(currency);
        AmountFormatContext amountFormatContext = this.context;
        synchronized (amountFormatContext) {
            boolean bl = false;
            Locale locale = this.context.getLocale();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocale(...)");
            NumberFormat formatter = this.getFormatter(locale);
            formatter.setMinimumFractionDigits(fractionDigits);
            formatter.setMaximumFractionDigits(fractionDigits);
            String s = formatter.format(amount.getNumber());
            CharSequence charSequence = this.pattern;
            Regex regex = new Regex("#\\.?#*");
            String string = s;
            Intrinsics.checkNotNull((Object)string);
            s = regex.replace(charSequence, string);
            s = StringsKt.replace$default((String)StringsKt.replace$default((String)s, (String)"$$$", (String)"$", (boolean)false, (int)4, null), (String)"$", (String)currencyString, (boolean)false, (int)4, null);
            Appendable appendable2 = appendable.append(s);
        }
    }

    private final int getFractionDigits(CurrencyUnit currency) {
        Regex regex = new Regex("[^#\\.]");
        CharSequence charSequence = this.pattern;
        String string = "";
        String numberPattern = regex.replace(charSequence, string);
        if (StringsKt.contains$default((CharSequence)numberPattern, (char)'.', (boolean)false, (int)2, null)) {
            int fractionDigits = StringsKt.substringAfter$default((String)numberPattern, (char)'.', null, (int)2, null).length();
            return fractionDigits;
        }
        return 0;
    }

    private final String getCurrencyString(CurrencyUnit cu) {
        if (StringsKt.contains$default((CharSequence)this.pattern, (CharSequence)"$$$", (boolean)false, (int)2, null)) {
            String string = cu.getCurrencyCode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCurrencyCode(...)");
            return string;
        }
        Currency currency = Currency.getInstance(cu.getCurrencyCode());
        String string = currency.getSymbol(this.context.getLocale());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSymbol(...)");
        return string;
    }

    private final NumberFormat getFormatter(Locale locale) {
        NumberFormat formatter = NumberFormat.getInstance(locale);
        String s = formatter.format(0L);
        if (!Intrinsics.areEqual((Object)"0", (Object)s)) {
            formatter = NumberFormat.getInstance();
        }
        NumberFormat numberFormat = formatter;
        Intrinsics.checkNotNull((Object)numberFormat);
        return numberFormat;
    }

    @NotNull
    public MonetaryAmount parse(@NotNull CharSequence text) throws MonetaryParseException {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = Objects.toString(text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.parse(string);
    }

    private final MonetaryAmount parse(String text) throws MonetaryParseException {
        MonetaryAmount monetaryAmount;
        String trimmed;
        String[] parts;
        String $this$trim$iv = (String)((Object)new NullValidator().validate((Serializable)((Object)text)));
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if ((parts = StringUtils.splitByCharacterType((String)StringUtils.upperCase((String)(trimmed = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())))).length == 0) {
            throw new InvalidValueException((Serializable)((Object)text), "money amount");
        }
        Currency cry = Waehrung.DEFAULT_CURRENCY;
        Intrinsics.checkNotNull((Object)parts);
        String currencyString = GeldbetragFormatter.Companion.findCurrencyString(parts);
        try {
            String string = StringUtils.remove((String)trimmed, (String)currencyString);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remove(...)");
            trimmed = Text.Companion.trim(string);
            BigDecimal n = new BigDecimal(new NumberValidator(null, null, 3, null).validate(trimmed));
            if (StringUtils.isNotEmpty((CharSequence)currencyString)) {
                cry = Waehrung.Companion.toCurrency(currencyString);
            }
            monetaryAmount = this.getMonetaryAmount(cry, n);
        }
        catch (IllegalArgumentException ex) {
            throw new LocalizedMonetaryParseException(text, ex);
        }
        catch (ValidationException ex) {
            throw new LocalizedMonetaryParseException(text, ex);
        }
        return monetaryAmount;
    }

    private final MonetaryAmount getMonetaryAmount(Currency cry, BigDecimal n) {
        MonetaryAmount monetaryAmount;
        MonetaryAmountFactory amountFactory = (MonetaryAmountFactory)this.context.get(MonetaryAmountFactory.class);
        if (amountFactory == null) {
            monetaryAmount = Geldbetrag.Companion.of((Number)n, cry);
        } else {
            MonetaryAmount monetaryAmount2 = amountFactory.setNumber((Number)n).setCurrency(cry.toString()).create();
            Intrinsics.checkNotNull((Object)monetaryAmount2);
            monetaryAmount = monetaryAmount2;
        }
        return monetaryAmount;
    }

    @NotNull
    public String queryFrom(@NotNull MonetaryAmount amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        String string = Objects.toString(amount);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.context.getLocale() + ")";
    }

    @JvmStatic
    @NotNull
    public static final GeldbetragFormatter of(@NotNull Locale locale) {
        return Companion.of(locale);
    }

    @JvmStatic
    @NotNull
    public static final GeldbetragFormatter of(@NotNull AmountFormatContext context) {
        return Companion.of(context);
    }

    @JvmStatic
    @NotNull
    public static final GeldbetragFormatter of(@NotNull String pattern) {
        return Companion.of(pattern);
    }

    public /* synthetic */ GeldbetragFormatter(AmountFormatContext context, String pattern, DefaultConstructorMarker $constructor_marker) {
        this(context, pattern);
    }

    static {
        MAPPED_LOCALES.put(new Locale("de_DE"), Locale.GERMANY);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001b\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0015"}, d2={"Lde/jfachwert/money/internal/GeldbetragFormatter$Companion;", "", "<init>", "()V", "MAPPED_LOCALES", "", "Ljava/util/Locale;", "DEFAULT_CONTEXT", "Ljavax/money/format/AmountFormatContext;", "kotlin.jvm.PlatformType", "Ljavax/money/format/AmountFormatContext;", "of", "Lde/jfachwert/money/internal/GeldbetragFormatter;", "locale", "context", "pattern", "", "findCurrencyString", "parts", "", "([Ljava/lang/String;)Ljava/lang/String;", "money"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GeldbetragFormatter of(@NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Locale mapped = MAPPED_LOCALES.getOrDefault(locale, locale);
            AmountFormatContext context = AmountFormatContextBuilder.of((String)"jfachwert").setLocale(mapped).build();
            Intrinsics.checkNotNull((Object)context);
            return this.of(context);
        }

        @JvmStatic
        @NotNull
        public final GeldbetragFormatter of(@NotNull AmountFormatContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new GeldbetragFormatter(context, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final GeldbetragFormatter of(@NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            AmountFormatContext amountFormatContext = DEFAULT_CONTEXT;
            Intrinsics.checkNotNullExpressionValue((Object)amountFormatContext, (String)"access$getDEFAULT_CONTEXT$cp(...)");
            return new GeldbetragFormatter(amountFormatContext, pattern, null);
        }

        private final String findCurrencyString(String[] parts) {
            CharSequence charSequence = parts[0];
            new Regex("[0-9]+").matches(charSequence);
            if (!StringUtils.isNumericSpace((CharSequence)parts[0]) && !new Regex("[+-]+").matches(charSequence = (CharSequence)parts[0])) {
                return parts[0];
            }
            return !StringUtils.isNumericSpace((CharSequence)parts[parts.length - 1]) ? parts[parts.length - 1] : "";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

