/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.core.feature;

import de.jiac.micro.agent.IScheduler;
import de.jiac.micro.agent.memory.IFact;
import de.jiac.micro.agent.memory.IShortTermMemory;
import de.jiac.micro.core.feature.AbstractPeriodicRunnable;
import de.jiac.micro.core.feature.AbstractSchedulable;
import de.jiac.micro.core.feature.AbstractSporadicRunnable;
import de.jiac.micro.core.feature.PeriodicParameters;
import de.jiac.micro.core.feature.SporadicParameters;
import de.jiac.micro.core.scope.AbstractScopeAwareRunner;
import java.util.Vector;
import org.slf4j.Logger;

public final class PrimitiveScheduler
implements IScheduler {
    protected final Logger logger;
    private final PeriodicScheduler _periodicScheduler;
    private final SporadicScheduler _sporadicScheduler;

    public PrimitiveScheduler(Logger logger) {
        this.logger = logger;
        this._periodicScheduler = new PeriodicScheduler();
        this._sporadicScheduler = new SporadicScheduler();
    }

    public void addSchedulable(AbstractSchedulable schedulable) {
        if (schedulable instanceof AbstractPeriodicRunnable) {
            this._periodicScheduler.add((PeriodicParameters)schedulable.getParameters(), -1);
        } else {
            this._sporadicScheduler.add((SporadicParameters)schedulable.getParameters());
        }
    }

    public boolean containsSchedulable(AbstractSchedulable schedulable) {
        if (schedulable instanceof AbstractPeriodicRunnable) {
            return this._periodicScheduler.contains(((AbstractPeriodicRunnable)schedulable).getPeriodicParameters());
        }
        return this._sporadicScheduler.contains(((AbstractSporadicRunnable)schedulable).getSporadicParameters());
    }

    public void removeSchedulable(AbstractSchedulable schedulable) {
        if (schedulable instanceof AbstractPeriodicRunnable) {
            this._periodicScheduler.remove((PeriodicParameters)schedulable.getParameters());
        } else {
            this._sporadicScheduler.remove((SporadicParameters)schedulable.getParameters());
        }
    }

    public void start() {
        try {
            this._sporadicScheduler.start();
            this._sporadicScheduler.waitForState(5000, (byte)1);
        }
        catch (InterruptedException ie) {
            this.logger.error("could not start sporadic scheduler", (Throwable)ie);
        }
        try {
            this._periodicScheduler.start();
            this._periodicScheduler.waitForState(5000, (byte)1);
        }
        catch (InterruptedException e) {
            this.logger.error("could not start periodic scheduler", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this._periodicScheduler.stop();
            this._periodicScheduler.waitForState(5000, (byte)2);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            this._sporadicScheduler.stop();
            this._sporadicScheduler.waitForState(5000, (byte)2);
        }
        catch (InterruptedException ie) {
            this.logger.error("could not start sporadic scheduler", (Throwable)ie);
        }
    }

    public IShortTermMemory getShortTermMemory() {
        return this._sporadicScheduler;
    }

    private final class SporadicScheduler
    extends AbstractScopeAwareRunner
    implements IShortTermMemory {
        private Vector _queue = new Vector();
        private boolean _changed = false;

        protected SporadicScheduler() {
            super("SporadicScheduler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notice(IFact newStuff) {
            if (this.isCancelled()) {
                return;
            }
            Vector vector = this._queue;
            synchronized (vector) {
                for (int i = 0; i < this._queue.size(); ++i) {
                    SporadicParameters sp = (SporadicParameters)this._queue.elementAt(i);
                    sp.data.addData(newStuff);
                    this._changed = true;
                }
                this._queue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() {
            int index = 0;
            int numData = 0;
            long nextArrival = Long.MAX_VALUE;
            while (!this.isCancelled()) {
                SporadicParameters actual;
                block15: {
                    long startTime;
                    Vector vector = this._queue;
                    synchronized (vector) {
                        if (index >= this._queue.size()) {
                            if (this._changed) {
                                this._changed = false;
                                index = 0;
                            } else {
                                long currentTime = System.currentTimeMillis();
                                try {
                                    if (nextArrival > currentTime) {
                                        this._queue.wait(nextArrival - currentTime);
                                    } else {
                                        this._queue.wait();
                                    }
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                            }
                            nextArrival = Long.MAX_VALUE;
                            continue;
                        }
                        actual = (SporadicParameters)this._queue.elementAt(index++);
                        startTime = System.currentTimeMillis();
                        long allowedNextArrival = actual.lastExecution + actual.getMinimumInterarrival();
                        if (allowedNextArrival > startTime) {
                            nextArrival = nextArrival > allowedNextArrival ? allowedNextArrival : nextArrival;
                            continue;
                        }
                        numData = actual.data.size();
                        if (numData <= 0) {
                            continue;
                        }
                    }
                    actual.lastExecution = startTime;
                    try {
                        ((AbstractSporadicRunnable)actual.schedulable).runShort(actual.data);
                    }
                    catch (Exception e) {
                        if (!PrimitiveScheduler.this.logger.isErrorEnabled()) break block15;
                        PrimitiveScheduler.this.logger.error("uncaught exception in: '" + String.valueOf(actual.schedulable) + "'", (Throwable)e);
                    }
                }
                actual.data.reset(numData);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void add(SporadicParameters sp) {
            Vector vector = this._queue;
            synchronized (vector) {
                if (!this._queue.contains(sp)) {
                    this._queue.addElement(sp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean contains(SporadicParameters sp) {
            Vector vector = this._queue;
            synchronized (vector) {
                return this._queue.contains(sp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove(SporadicParameters sp) {
            Vector vector = this._queue;
            synchronized (vector) {
                this._queue.removeElement(sp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unblock() {
            Vector vector = this._queue;
            synchronized (vector) {
                this._queue.notify();
            }
        }
    }

    private final class PeriodicScheduler
    extends AbstractScopeAwareRunner {
        private Vector _queue = new Vector();

        protected PeriodicScheduler() {
            super("PeriodicScheduler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() {
            PeriodicParameters actual = null;
            while (!this.isCancelled()) {
                long startTime;
                Vector vector;
                block18: {
                    vector = this._queue;
                    synchronized (vector) {
                        if (this._queue.isEmpty()) {
                            try {
                                this._queue.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            continue;
                        }
                        actual = this.getMin();
                        startTime = System.currentTimeMillis();
                        if (actual.nextExecutionTime > startTime) {
                            try {
                                this._queue.wait(actual.nextExecutionTime - startTime);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    try {
                        actual.lastExecution = startTime;
                        ((AbstractPeriodicRunnable)actual.schedulable).runShort();
                    }
                    catch (Exception e) {
                        if (!PrimitiveScheduler.this.logger.isErrorEnabled()) break block18;
                        PrimitiveScheduler.this.logger.error("uncaught exception in: '" + actual.schedulable.toString() + "'", (Throwable)e);
                    }
                }
                vector = this._queue;
                synchronized (vector) {
                    long currentTime = System.currentTimeMillis();
                    actual.estimatedDuration = (actual.estimatedDuration + (currentTime - startTime)) / 2L;
                    if (actual.getPeriod() <= 0L) {
                        this._queue.removeElement(actual);
                    } else if (this._queue.contains(actual)) {
                        actual.nextExecutionTime = Math.max(actual.nextExecutionTime + actual.getPeriod(), currentTime);
                    }
                }
                Thread.yield();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void add(PeriodicParameters pars, int index) {
            Vector vector = this._queue;
            synchronized (vector) {
                long firstTime;
                long time = pars.start;
                long currentTime = System.currentTimeMillis();
                if (!this._queue.contains(pars)) {
                    if (index != -1) {
                        this._queue.insertElementAt(pars, index);
                    } else {
                        this._queue.addElement(pars);
                    }
                    firstTime = time;
                } else {
                    firstTime = time > pars.nextExecutionTime ? time : pars.nextExecutionTime;
                }
                pars.nextExecutionTime = firstTime > currentTime ? firstTime : currentTime;
                this._queue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean contains(PeriodicParameters pars) {
            Vector vector = this._queue;
            synchronized (vector) {
                return this._queue.contains(pars);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove(PeriodicParameters pars) {
            pars.nextExecutionTime = -1L;
            Vector vector = this._queue;
            synchronized (vector) {
                if (this._queue.removeElement(pars)) {
                    this._queue.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unblock() {
            Vector vector = this._queue;
            synchronized (vector) {
                this._queue.notify();
            }
        }

        private PeriodicParameters getMin() {
            PeriodicParameters result = null;
            for (int i = 0; i < this._queue.size(); ++i) {
                PeriodicParameters actual = (PeriodicParameters)this._queue.elementAt(i);
                if (result == null) {
                    result = (PeriodicParameters)this._queue.elementAt(i);
                    continue;
                }
                if (actual.nextExecutionTime >= result.nextExecutionTime) continue;
                result = actual;
            }
            return result;
        }
    }
}

