/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.internal.core;

import com.github.libxjava.lang.IClassLoader;
import de.jiac.micro.agent.IConnectionFactory;
import de.jiac.micro.agent.memory.IShortTermMemory;
import de.jiac.micro.core.IHandle;
import de.jiac.micro.core.feature.PrimitiveScheduler;
import de.jiac.micro.core.handle.IResourceHandle;
import de.jiac.micro.core.io.IStreamConnection;
import de.jiac.micro.internal.agent.SimpleLongTermMemory;
import de.jiac.micro.internal.core.AbstractAgent;
import de.jiac.micro.internal.io.ConnectionMapperFactory;
import de.jiac.micro.util.List;
import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import org.slf4j.Logger;

public class NonRTAgent
extends AbstractAgent {
    private PrimitiveScheduler _scheduler;

    public void cleanup() {
        super.cleanup();
        this.removeHandle((IHandle)this._scheduler);
        this._scheduler = null;
    }

    public void initialise() {
        this._scheduler = new PrimitiveScheduler(this.getLogger());
        this.addHandle((IHandle)this._scheduler);
        this.addHandle((IHandle)new SimpleLongTermMemory());
        this.addHandle((IHandle)new AgentAccess());
        super.initialise();
    }

    public void start() {
        this._scheduler.start();
        super.start();
    }

    public void stop() {
        super.stop();
        this._scheduler.stop();
    }

    final synchronized Connection establishConnection(String uri) throws IOException {
        int colon = uri.indexOf(58);
        if (colon <= 0) {
            return null;
        }
        String scheme = uri.substring(0, colon);
        List.Node n = this.installedElements.head();
        List.Node end = this.installedElements.tail();
        while ((n = n.next()) != end) {
            IConnectionFactory factory;
            Connection c;
            AbstractAgent.ElementContext context = (AbstractAgent.ElementContext)n;
            if (context.scheme == null || !context.scheme.equalsIgnoreCase(scheme) || (c = (factory = (IConnectionFactory)context.getElement()).openConnection(uri)) == null) continue;
            return c;
        }
        return null;
    }

    protected final IShortTermMemory getShortTermMemory() {
        return this._scheduler.getShortTermMemory();
    }

    protected class AgentAccess
    implements IResourceHandle {
        public synchronized void close(Connection con) {
            block3: {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (IOException ioe) {
                    Logger logger = NonRTAgent.this.getLogger();
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("error while closing connection", (Throwable)ioe);
                }
            }
        }

        public synchronized Connection open(String url) throws IOException {
            return this.open(url, false);
        }

        public synchronized IStreamConnection openStreamConnection(String url) throws IOException {
            return (IStreamConnection)this.open(url, true);
        }

        private Connection open(String url, boolean stream) throws IOException {
            Connection c = NonRTAgent.this.establishConnection(url);
            if (c == null) {
                c = Connector.open((String)url);
            }
            if (stream) {
                Connection unmapped = c;
                IClassLoader classLoader = NonRTAgent.this.getClassLoader();
                try {
                    c = ConnectionMapperFactory.getStreamConnection((IClassLoader)classLoader, (String)url, (Connection)c);
                }
                catch (IOException ioe) {
                    this.close(unmapped);
                    throw ioe;
                }
            }
            return c;
        }
    }
}

