/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.midlet;

import com.github.libxjava.io.BinaryDeserialiserStream;
import com.github.libxjava.io.BinarySerialiserStream;
import com.github.libxjava.io.ByteArrayInputBuffer;
import com.github.libxjava.io.ByteArrayOutputBuffer;
import com.github.libxjava.lang.IClassLoader;
import de.jiac.micro.core.IContainer;
import de.jiac.micro.core.scope.Scope;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RMSStore {
    private final String _storeName;
    private RecordStore _store = null;
    BinaryDeserialiserStream deserialiser;
    ByteArrayInputBuffer inputBuffer;
    private BinarySerialiserStream _serialiser;
    private ByteArrayOutputBuffer _outputBuffer;
    private StoreFilter _filter;

    public RMSStore() {
        IContainer container = Scope.getContainer();
        this._storeName = container.toString();
    }

    public synchronized Object retrieve(String id) throws IOException {
        this.checkStore();
        int index = this.search(id);
        if (index >= 0) {
            try {
                return this.deserialiser.readObject();
            }
            catch (Exception e) {
                throw new IOException("could not deserialise object: " + e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object store(String id, Object obj) throws IOException {
        Object old;
        block14: {
            if (id == null) {
                throw new IOException("id must not be null");
            }
            this.checkStore();
            if (this._serialiser == null) {
                this._outputBuffer = new ByteArrayOutputBuffer();
                this._serialiser = new BinarySerialiserStream((OutputStream)this._outputBuffer);
            }
            old = null;
            try {
                this._serialiser.writeUTF(id);
                this._serialiser.writeObject(obj);
                this._serialiser.flush();
                int index = this.search(id);
                try {
                    if (index >= 0) {
                        try {
                            old = this.deserialiser.readObject();
                        }
                        catch (Exception e) {
                            old = null;
                        }
                        this._store.setRecord(index, this._outputBuffer.getByteArrayReference(), 0, this._outputBuffer.size());
                        break block14;
                    }
                    this._store.addRecord(this._outputBuffer.getByteArrayReference(), 0, this._outputBuffer.size());
                }
                catch (Exception e) {
                    throw new IOException("could not write object to database: " + e.getMessage());
                }
            }
            finally {
                try {
                    this._serialiser.flush();
                }
                catch (IOException ioe) {}
                this._outputBuffer.reset();
            }
        }
        return old;
    }

    private void checkStore() throws IOException {
        if (this._store == null) {
            try {
                this._store = RecordStore.openRecordStore((String)this._storeName, (boolean)true);
                if (this._store == null) {
                    throw new IOException("could not create new store");
                }
            }
            catch (RecordStoreException e) {
                throw new IOException("could not initialise store: " + e.getMessage());
            }
        }
    }

    private int search(String key) throws IOException {
        if (this.deserialiser == null) {
            this.inputBuffer = new ByteArrayInputBuffer();
            IClassLoader classLoader = Scope.getContainer().getClassLoader();
            this.deserialiser = new BinaryDeserialiserStream(classLoader, (InputStream)this.inputBuffer);
        }
        if (this._filter == null) {
            this._filter = new StoreFilter();
        }
        this._filter.key = key;
        try {
            RecordEnumeration records = this._store.enumerateRecords((RecordFilter)this._filter, null, false);
            int count = records.numRecords();
            if (count > 1) {
                throw new IOException("store is corrupted and contains key more then once");
            }
            return count == 1 ? records.nextRecordId() : -1;
        }
        catch (RecordStoreException e) {
            throw new IOException("could not search for key: " + e.getMessage());
        }
    }

    class StoreFilter
    implements RecordFilter {
        String key;

        StoreFilter() {
        }

        public boolean matches(byte[] candidate) {
            RMSStore.this.deserialiser.flush();
            RMSStore.this.inputBuffer.setInput(candidate);
            try {
                return RMSStore.this.deserialiser.readUTF().equals(this.key);
            }
            catch (IOException ioe) {
                throw new RuntimeException("could not deserialise record");
            }
        }
    }
}

