/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.internal.midp.ui;

import de.jiac.micro.core.scope.NodeScope;
import de.jiac.micro.internal.NodeLauncher;
import java.util.Hashtable;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

final class MIDPPlatformMonitor
implements CommandListener {
    private static final Command BACK = new Command("Back", 2, 0);
    private static final Command EXIT = new Command("Exit", 6, 2);
    private static final String MAIN = "main";
    private Ticker _headline;
    private List _monitor;
    private String _currentScreen = "";
    private final Display __display;
    private Hashtable _agentUIs = new Hashtable();
    private final NodeScope _scope;
    static /* synthetic */ Class class$de$jiac$micro$internal$NodeLauncher;

    public MIDPPlatformMonitor() {
        this._headline = new Ticker("Platform Monitor");
        this._monitor = new List("Agents", 3);
        this._monitor.addCommand(EXIT);
        this._monitor.setCommandListener((CommandListener)this);
        this.__display = Display.getDisplay((MIDlet)((NodeLauncher)NodeScope.getNodeHandle((Class)(class$de$jiac$micro$internal$NodeLauncher == null ? (class$de$jiac$micro$internal$NodeLauncher = MIDPPlatformMonitor.class$("de.jiac.micro.internal.NodeLauncher")) : class$de$jiac$micro$internal$NodeLauncher))));
        this.__display.setCurrent((Displayable)this._monitor);
        this._currentScreen = MAIN;
        this._scope = NodeScope.getNodeScope();
    }

    public synchronized void addAgent(String name) {
        int size = this._monitor.size();
        int pos = -1;
        for (int i = 0; i < size; ++i) {
            String element = this._monitor.getString(i);
            if (element.compareTo(name) <= 0) continue;
            pos = i;
            break;
        }
        if (pos >= 0) {
            this._monitor.insert(pos, name, null);
        } else {
            this._monitor.append(name, null);
        }
    }

    public synchronized void destroy() {
        this._agentUIs.clear();
        this._agentUIs = null;
        this._currentScreen = "";
        this._monitor = null;
        this._headline = null;
    }

    public synchronized void removeAgent(String name) {
        int size = this._monitor.size();
        for (int i = 0; i < size; ++i) {
            String element = this._monitor.getString(i);
            if (!element.equals(name)) continue;
            this._monitor.delete(i);
            break;
        }
        this._agentUIs.remove(name);
        if (this._currentScreen.equals(name)) {
            this.__display.setCurrent((Displayable)this._monitor);
            this._currentScreen = MAIN;
        }
    }

    public synchronized void setAgentUI(String name, Displayable ui, CommandListener listener) {
        this._agentUIs.put(name, new UIEntry(ui, listener));
        this.setCurrent(name, ui);
    }

    public synchronized void setCurrent(String name, Displayable ui) {
        UIEntry entry = (UIEntry)this._agentUIs.get(name);
        if (entry != null) {
            entry.ui = ui;
            if (this._currentScreen.equals(name)) {
                this.displayCustom(entry.ui);
            }
        }
    }

    public synchronized void commandAction(Command c, Displayable d) {
        UIEntry entry;
        if (c == EXIT) {
            this._scope.signal((byte)0);
            return;
        }
        if (c == BACK) {
            this.__display.setCurrent((Displayable)this._monitor);
            this._currentScreen = MAIN;
        } else if (d == this._monitor) {
            String element;
            UIEntry entry2;
            int index = this._monitor.getSelectedIndex();
            if (index >= 0 && index < this._monitor.size() && (entry2 = (UIEntry)this._agentUIs.get(element = this._monitor.getString(index))) != null && entry2.ui != null) {
                this.displayCustom(entry2.ui);
                this._currentScreen = element;
            }
        } else if (!this._currentScreen.equals(MAIN) && (entry = (UIEntry)this._agentUIs.get(this._currentScreen)) != null && entry.listener != null) {
            entry.listener.commandAction(c, d);
            d.setCommandListener((CommandListener)this);
        }
    }

    private void displayCustom(Displayable d) {
        d.addCommand(BACK);
        this.__display.setCurrent(d);
        d.setCommandListener((CommandListener)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class UIEntry {
        CommandListener listener;
        Displayable ui;

        public UIEntry(Displayable d, CommandListener l) {
            this.ui = d;
            this.listener = l;
        }
    }
}

