/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.sunspot.aodv;

import com.github.libxjava.io.BinaryDeserialiserStream;
import com.github.libxjava.io.BinarySerialiserStream;
import com.github.libxjava.io.IDeserialiser;
import com.github.libxjava.io.ISerialiser;
import com.github.libxjava.io.ReferenceCache;
import com.github.libxjava.lang.IClassLoader;
import com.sun.spot.peripheral.radio.IProtocolManager;
import com.sun.spot.peripheral.radio.LowPan;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.peripheral.radio.mhrp.aodv.AODVManager;
import com.sun.spot.peripheral.radio.routing.interfaces.IRoutingManager;
import com.sun.spot.util.IEEEAddress;
import de.jiac.micro.agent.handle.ICommunicationHandle;
import de.jiac.micro.core.IAgent;
import de.jiac.micro.core.IHandle;
import de.jiac.micro.core.io.IAddress;
import de.jiac.micro.core.io.IMessage;
import de.jiac.micro.core.io.IMulticastAddress;
import de.jiac.micro.core.io.IUnicastAddress;
import de.jiac.micro.core.scope.AbstractScopeAwareRunner;
import de.jiac.micro.core.scope.AgentScope;
import de.jiac.micro.core.scope.Scope;
import de.jiac.micro.internal.core.AbstractNodeComponent;
import de.jiac.micro.internal.io.Message;
import de.jiac.micro.sunspot.aodv.Address;
import de.jiac.micro.sunspot.aodv.IMessageListener;
import de.jiac.micro.sunspot.aodv.MessageID;
import de.jiac.micro.sunspot.aodv.MessageInputStream;
import de.jiac.micro.sunspot.aodv.MessageOutputStream;
import de.jiac.micro.sunspot.aodv.ProtocolManager;
import de.jiac.micro.util.List;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.slf4j.Logger;

public class AODVNodeComponent
extends AbstractNodeComponent
implements IHandle {
    protected long nodeAddress;
    private final Hashtable _listeners = new Hashtable();
    private final Hashtable _groups = new Hashtable();
    private final MessageProcessor _processor = new MessageProcessor();
    private BinarySerialiserStream _serialiser;
    private MessageOutputStream _messageOutput;
    private BinaryDeserialiserStream _deserialiser;
    private MessageInputStream _messageInput;
    private ProtocolManager _protocol;
    private ReferenceCache _cache = null;
    static /* synthetic */ Class class$de$jiac$micro$sunspot$aodv$AODVNodeComponent$AODVCommunicator;

    private static String getAgentKey() {
        return String.valueOf(AgentScope.getAgentScope().hashCode());
    }

    public void cleanup() {
        this._processor.stop();
        this._protocol.stop();
        LowPan.getInstance().deregisterProtocol((byte)-34);
        RadioFactory.getRadioPolicyManager().setRxOn(false);
        super.cleanup();
    }

    public void initialise() {
        super.initialise();
        this._protocol = new ProtocolManager(LowPan.getInstance());
        this._messageOutput = new MessageOutputStream(this._protocol);
        this._serialiser = this._cache != null ? this._cache.createSerialiser((OutputStream)((Object)this._messageOutput)) : new BinarySerialiserStream((OutputStream)((Object)this._messageOutput));
        this.nodeAddress = RadioFactory.getRadioPolicyManager().getIEEEAddress();
        RadioFactory.setProperty((String)"IEEE_ADDRESS", (String)new IEEEAddress(this.nodeAddress).asDottedHex());
        RadioFactory.getRadioPolicyManager().setRxOn(true);
        this._messageInput = new MessageInputStream(this._protocol);
        IClassLoader cl = Scope.getContainer().getClassLoader();
        this._deserialiser = this._cache != null ? this._cache.createDeserialiser(cl, (InputStream)((Object)this._messageInput)) : new BinaryDeserialiserStream(cl, (InputStream)((Object)this._messageInput));
        LowPan.getInstance().setRoutingManager((IRoutingManager)AODVManager.getInstance());
        LowPan.getInstance().registerProtocol((byte)-34, (IProtocolManager)this._protocol);
        this._protocol.start();
        this._processor.start();
    }

    public void register(IMessageListener listener) {
        AODVCommunicator comm = this.register(AODVNodeComponent.getAgentKey(), listener);
        if (comm != null) {
            AgentScope.getAgentReference().addHandle((IHandle)comm);
        }
    }

    public void setReferenceCache(ReferenceCache cache) {
        this._cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AODVCommunicator register(String key, IMessageListener listener) {
        Hashtable hashtable = this._listeners;
        synchronized (hashtable) {
            IMessageListener oldListener = this._listeners.put(key, listener);
            if (oldListener != null && oldListener != listener) {
                throw new Error("implementation error");
            }
            if (oldListener == null) {
                return new AODVCommunicator(key);
            }
            return null;
        }
    }

    public void unregister(IMessageListener listener) {
        IAgent agentRef;
        IHandle commHandle;
        if (this.unregister(AODVNodeComponent.getAgentKey(), listener) && (commHandle = (agentRef = AgentScope.getAgentReference()).getHandle(class$de$jiac$micro$sunspot$aodv$AODVNodeComponent$AODVCommunicator == null ? (class$de$jiac$micro$sunspot$aodv$AODVNodeComponent$AODVCommunicator = AODVNodeComponent.class$("de.jiac.micro.sunspot.aodv.AODVNodeComponent$AODVCommunicator")) : class$de$jiac$micro$sunspot$aodv$AODVNodeComponent$AODVCommunicator)) != null) {
            agentRef.removeHandle(commHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unregister(String selector, IMessageListener listener) {
        Hashtable hashtable = this._listeners;
        synchronized (hashtable) {
            IMessageListener oldListener = (IMessageListener)this._listeners.get(selector);
            if (oldListener != listener) {
                throw new Error("implementation error");
            }
            Enumeration addresses = this._groups.keys();
            while (addresses.hasMoreElements()) {
                Address group = (Address)addresses.nextElement();
                this.changeGroupAssociation(selector, group, false);
            }
            this._listeners.remove(selector);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalProcessMessage() {
        BinaryDeserialiserStream binaryDeserialiserStream = this._deserialiser;
        synchronized (binaryDeserialiserStream) {
            Logger logger = Scope.getContainer().getLogger("AODV");
            logger.info("try to read message... ");
            MessageID mid = this._protocol.nextAvailableMessage();
            logger.info(" new message available: " + mid.toString());
            this._messageInput.setMessageID(mid);
            try {
                Message message = new Message();
                message.deserialise((IDeserialiser)this._deserialiser);
                logger.info(" message deserialised");
                String targetStr = message.getHeader("target-address");
                Address targetAddress = Address.parseAddress(targetStr);
                Hashtable hashtable = this._listeners;
                synchronized (hashtable) {
                    switch (targetAddress.getType()) {
                        case 0: {
                            String agentName = targetAddress.getSelector();
                            IMessageListener agent = (IMessageListener)this._listeners.get(agentName);
                            if (agent == null) {
                                logger.warn("MessageLayer: received message for unknown agent '" + targetStr + "'");
                                break;
                            }
                            agent.processMessage((IMessage)message);
                            break;
                        }
                        case 1: {
                            List members = (List)this._groups.get(targetAddress);
                            if (members == null) {
                                logger.warn("MessageLayer: received message for unknown group '" + targetStr + "'");
                                break;
                            }
                            List.Node n = members.head();
                            List.Node end = members.tail();
                            while ((n = n.next()) != end) {
                                String agentKey = (String)n.value();
                                IMessageListener agent = (IMessageListener)this._listeners.get(agentKey);
                                agent.processMessage((IMessage)message);
                            }
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this._deserialiser.flush();
                this._protocol.clearIncoming(mid);
            }
        }
    }

    protected void addHandlesOn(AgentScope scope) {
        scope.getContainerReference().addHandle((IHandle)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeGroupAssociation(String selector, Address group, boolean join) {
        Hashtable hashtable = this._listeners;
        synchronized (hashtable) {
            IMessageListener listener = (IMessageListener)this._listeners.get(selector);
            if (listener == null) {
                throw new Error("implementation error");
            }
            List groupMembers = (List)this._groups.get(group);
            if (join) {
                if (groupMembers == null) {
                    groupMembers = new List();
                    this._groups.put(group, groupMembers);
                }
                if (!groupMembers.contains((Object)selector)) {
                    groupMembers.addLast((Object)selector);
                }
            } else if (groupMembers != null) {
                groupMembers.remove((Object)selector);
                if (groupMembers.size() <= 0) {
                    this._groups.remove(group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalSendMessage(String selector, Address target, Message message) throws IOException {
        IUnicastAddress sourceAddress = Address.createUnicastAddress(this.nodeAddress, selector);
        message.setHeader("source-address", sourceAddress.toString());
        message.setHeader("target-address", target.toString());
        BinarySerialiserStream binarySerialiserStream = this._serialiser;
        synchronized (binarySerialiserStream) {
            MessageID mid;
            switch (target.getType()) {
                case 0: {
                    mid = this._protocol.newOutgoingMessageID(target.getNodeAddress(), false);
                    break;
                }
                case 1: {
                    mid = this._protocol.newOutgoingMessageID(0L, true);
                    break;
                }
                default: {
                    throw new IOException("unknown address type: '" + target + "'");
                }
            }
            this._messageOutput.setMessageID(mid);
            try {
                message.serialise((ISerialiser)this._serialiser);
            }
            finally {
                this._serialiser.flush();
                this._protocol.clearOutgoing(mid);
            }
        }
    }

    protected IHandle getNodeHandle() {
        return this;
    }

    protected void removeHandlesFrom(AgentScope scope) {
        scope.getContainerReference().removeHandle((IHandle)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class MessageProcessor
    extends AbstractScopeAwareRunner {
        protected MessageProcessor() {
            super("MessageProcessor");
        }

        protected void doRun() {
            while (!this.isCancelled()) {
                AODVNodeComponent.this.internalProcessMessage();
            }
        }
    }

    private final class AODVCommunicator
    implements ICommunicationHandle {
        private final String _selector;

        protected AODVCommunicator(String selector) {
            this._selector = selector;
        }

        public IMessage createMessage() {
            return new Message();
        }

        public IUnicastAddress[] getLocalAddresses() {
            return new IUnicastAddress[]{Address.createUnicastAddress(AODVNodeComponent.this.nodeAddress, this._selector)};
        }

        public IMulticastAddress getMulticastAddressForName(String groupName) {
            return Address.createMulticastAddress(groupName);
        }

        public IAddress getAddressForString(String addressStr) {
            return Address.parseAddress(addressStr);
        }

        public void joinGroup(IMulticastAddress address) {
            AODVNodeComponent.this.changeGroupAssociation(this._selector, (Address)address, true);
        }

        public void leaveGroup(IMulticastAddress address) {
            AODVNodeComponent.this.changeGroupAssociation(this._selector, (Address)address, false);
        }

        public void sendMessage(IAddress address, IMessage message) throws IOException {
            AODVNodeComponent.this.internalSendMessage(this._selector, (Address)address, (Message)message);
        }
    }
}

