/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.sunspot.aodv;

import de.jiac.micro.core.io.IMulticastAddress;
import de.jiac.micro.core.io.IUnicastAddress;

public class Address
implements IMulticastAddress,
IUnicastAddress {
    private byte _type;
    private String _address;
    private String _agentId;
    private String _nodeAddressAsString;
    private long _nodeAddress;
    private String _groupName;

    public static IMulticastAddress createMulticastAddress(String groupName) {
        return new Address(1, "mc://" + groupName);
    }

    public static IUnicastAddress createUnicastAddress(long nodeID, String agentID) {
        return new Address(0, "uc://" + nodeID + "#" + agentID);
    }

    public static Address parseAddress(String addressStr) {
        byte type;
        String prefix = addressStr.substring(0, 5);
        if (prefix.equals("uc://")) {
            type = 0;
        } else if (prefix.equals("mc://")) {
            type = 1;
        } else {
            throw new IllegalArgumentException("invalid address string '" + addressStr + "'");
        }
        return new Address(type, addressStr);
    }

    public Address(byte type, String address) {
        this._type = type;
        this._address = address;
        this.initFields();
    }

    public byte getType() {
        return this._type;
    }

    public String toString() {
        return this._address;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getTargetId() {
        if (this._type != 0) {
            throw new RuntimeException("operation not available for '" + this._address + "'");
        }
        return this._nodeAddressAsString;
    }

    public long getNodeAddress() {
        if (this._type != 0) {
            throw new RuntimeException("operation not available for '" + this._address + "'");
        }
        return this._nodeAddress;
    }

    public String getSelector() {
        if (this._type != 0) {
            throw new RuntimeException("operation not available for '" + this._address + "'");
        }
        return this._agentId;
    }

    public String getGroupName() {
        if (this._type != 1) {
            throw new RuntimeException("operation not available for '" + this._address + "'");
        }
        return this._groupName;
    }

    private void initFields() {
        switch (this._type) {
            case 0: {
                int hashmark = this._address.indexOf(35);
                this._nodeAddressAsString = this._address.substring(5, hashmark);
                this._agentId = this._address.substring(hashmark + 1);
                this._nodeAddress = Long.parseLong(this._nodeAddressAsString);
                break;
            }
            case 1: {
                this._groupName = this._address.substring(5);
            }
        }
    }
}

