/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.sunspot.aodv;

import com.github.libxjava.io.ByteArrayInputBuffer;
import com.github.libxjava.io.ByteArrayOutputBuffer;
import com.sun.spot.peripheral.radio.IProtocolManager;
import com.sun.spot.peripheral.radio.IncomingData;
import com.sun.spot.peripheral.radio.LowPan;
import com.sun.spot.peripheral.radio.LowPanHeaderInfo;
import com.sun.spot.util.Queue;
import de.jiac.micro.core.scope.AbstractScopeAwareRunner;
import java.io.IOException;

public class DiscoveryProtocolManager
implements IProtocolManager {
    public static final byte PROTOCOL_NUM = -33;
    static final byte MAX_HOPS = 2;
    private static final int MAX_SIZE = 79;
    private final ByteArrayOutputBuffer _writeBuffer;
    private final ByteArrayInputBuffer _readBuffer;
    private final StringBuffer _idBuffer;
    private final BeaconProcessor _processor;
    private final IDiscoveryListener _listener;

    public DiscoveryProtocolManager(IDiscoveryListener listener) {
        this._listener = listener;
        this._processor = new BeaconProcessor();
        this._writeBuffer = new ByteArrayOutputBuffer(79);
        this._readBuffer = new ByteArrayInputBuffer();
        this._idBuffer = new StringBuffer();
    }

    public void processIncomingData(byte[] payload, LowPanHeaderInfo headerInfo) {
        this._processor.packets.put((Object)new IncomingData(payload, headerInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendIdentification(String identification) throws IOException {
        ByteArrayOutputBuffer byteArrayOutputBuffer = this._writeBuffer;
        synchronized (byteArrayOutputBuffer) {
            try {
                for (int i = 0; i < identification.length(); ++i) {
                    this._writeBuffer.write((int)identification.charAt(i));
                }
                if (this._writeBuffer.size() > 79) {
                    throw new IOException("identification is too large");
                }
                LowPan.getInstance().sendBroadcast((byte)-33, this._writeBuffer.getByteArrayReference(), 0, this._writeBuffer.size(), 2);
            }
            finally {
                this._writeBuffer.resetNew();
            }
        }
    }

    public void start() {
        this._processor.packets.empty();
        LowPan.getInstance().registerProtocol((byte)-33, (IProtocolManager)this);
        this._processor.start();
    }

    public void stop() {
        LowPan.getInstance().deregisterProtocol((byte)-33);
        this._processor.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processIncomingData(IncomingData incoming) {
        ByteArrayInputBuffer byteArrayInputBuffer = this._readBuffer;
        synchronized (byteArrayInputBuffer) {
            byte[] oldBuf = this._readBuffer.getByteArrayReference();
            try {
                this._readBuffer.setInput(incoming.payload);
                for (int i = 0; i < incoming.payload.length; ++i) {
                    this._idBuffer.append((char)(incoming.payload[i] & 0xFF));
                }
                this._listener.notifyDiscovered(incoming.headerInfo.originator, this._idBuffer.toString(), incoming.headerInfo.rssi);
            }
            finally {
                this._readBuffer.setInput(oldBuf);
                this._idBuffer.setLength(0);
            }
        }
    }

    private final class BeaconProcessor
    extends AbstractScopeAwareRunner {
        protected final Queue packets = new Queue();

        protected BeaconProcessor() {
            super("BeaconProcessor");
        }

        protected void doRun() {
            while (!this.isCancelled()) {
                try {
                    IncomingData incoming = (IncomingData)this.packets.get();
                    DiscoveryProtocolManager.this.processIncomingData(incoming);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface IDiscoveryListener {
        public void notifyDiscovered(long var1, String var3, int var4);
    }
}

