/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.sunspot.aodv;

import com.sun.spot.peripheral.radio.IncomingData;
import com.sun.squawk.util.IntHashtable;
import de.jiac.micro.sunspot.aodv.MessageID;
import java.io.IOException;

class MessageFragments {
    private static final long MAX_WAIT = 2000L;
    final MessageID mid;
    private final IntHashtable _sortedFragments;
    private int _seqToRead;
    private boolean _lastRead = false;

    MessageFragments(int messageNum, int source) {
        this.mid = new MessageID(messageNum, source);
        this._seqToRead = 1;
        this._sortedFragments = new IntHashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newFragment(IncomingData incoming) {
        int seq = incoming.payload[1] & 0xFF;
        IntHashtable intHashtable = this._sortedFragments;
        synchronized (intHashtable) {
            if (this._sortedFragments.put(seq, (Object)incoming) != null) {
                System.err.println("multiple data segment " + seq);
            }
            if (this._seqToRead == seq) {
                this._sortedFragments.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readFragment(byte[] buffer) throws IOException {
        IncomingData incoming;
        IntHashtable intHashtable = this._sortedFragments;
        synchronized (intHashtable) {
            if (this._lastRead) {
                return -1;
            }
            long deadline = System.currentTimeMillis() + 2000L;
            while (!this._sortedFragments.containsKey(this._seqToRead)) {
                long toWait = deadline - System.currentTimeMillis();
                if (toWait <= 0L) {
                    throw new IOException("waiting for segment " + this._seqToRead + " timed out");
                }
                try {
                    this._sortedFragments.wait(2000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("operation was interrupted");
                }
            }
            incoming = (IncomingData)this._sortedFragments.remove(this._seqToRead);
            this._lastRead = incoming.payload[2] == 1;
            this._seqToRead = (this._seqToRead + 1) % 256;
        }
        int numBytes = incoming.payload.length - 3;
        System.arraycopy(incoming.payload, 3, buffer, 0, numBytes);
        return numBytes;
    }
}

