/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.sunspot.aodv;

import com.sun.spot.peripheral.radio.RadioFactory;

public final class MessageID {
    private static int NUM = 0;
    final int messageNum;
    final int source;

    public static int getId(int messageNum, int source) {
        return source << 8 | messageNum;
    }

    private static synchronized int nextNum() {
        int nn = NUM;
        NUM = (NUM + 1) % 256;
        return nn;
    }

    MessageID() {
        this(MessageID.nextNum(), (int)(RadioFactory.getRadioPolicyManager().getIEEEAddress() & 0xFFFFL));
    }

    MessageID(int messageNum, int source) {
        this.messageNum = messageNum;
        this.source = source;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageID) {
            return ((MessageID)obj).getId() == this.getId();
        }
        return false;
    }

    public int hashCode() {
        return this.getId();
    }

    public int getId() {
        return MessageID.getId(this.messageNum, this.source);
    }

    public String toString() {
        return Integer.toHexString(this.getId());
    }
}

