/*
 * Decompiled with CFR 0.152.
 */
package de.jiac.micro.sunspot.aodv;

import com.github.libxjava.concurrent.AbstractSingleThreadRunner;
import com.sun.spot.peripheral.ChannelBusyException;
import com.sun.spot.peripheral.NoRouteException;
import com.sun.spot.peripheral.radio.ILowPan;
import com.sun.spot.peripheral.radio.IProtocolManager;
import com.sun.spot.peripheral.radio.IncomingData;
import com.sun.spot.peripheral.radio.LowPanHeaderInfo;
import com.sun.spot.peripheral.radio.RadioFactory;
import com.sun.spot.util.Queue;
import com.sun.squawk.util.IntHashtable;
import de.jiac.micro.sunspot.aodv.MessageFragments;
import de.jiac.micro.sunspot.aodv.MessageID;
import de.jiac.micro.sunspot.aodv.MessageState;
import java.io.IOException;
import java.util.Hashtable;

final class ProtocolManager
implements IProtocolManager {
    static final byte PROTOCOL_NUM = -34;
    static final byte MAX_HOPS = 3;
    static final byte NUM_OFFSET = 0;
    static final byte SEQ_OFFSET = 1;
    static final byte CTRL_OFFSET = 2;
    static final byte DATA_OFFSET = 3;
    protected final Queue incomingQueue = new Queue();
    private final InputHandler _inputHandler = new InputHandler();
    private final ILowPan _lowpan;
    private final IntHashtable _incomingMessageFragments;
    private final Hashtable _outgoingMessageStates;

    ProtocolManager(ILowPan lowpan) {
        this._lowpan = lowpan;
        this._incomingMessageFragments = new IntHashtable();
        this._outgoingMessageStates = new Hashtable();
    }

    public void processIncomingData(byte[] payload, LowPanHeaderInfo headerInfo) {
        this.incomingQueue.put((Object)new IncomingData(payload, headerInfo));
    }

    public void send(MessageID mid, byte[] payload, int length, boolean last) throws IOException, ChannelBusyException, NoRouteException {
        MessageState ms = (MessageState)this._outgoingMessageStates.get(mid);
        if (ms == null) {
            throw new IOException("invalid message id: " + mid);
        }
        int newSeq = (ms.lastOutgoingSeq + 1) % 256;
        ms.size += length;
        ms.lastOutgoingSeq = newSeq;
        payload[0] = (byte)ms.mid.messageNum;
        payload[1] = (byte)newSeq;
        byte by = payload[2] = last ? (byte)1 : 0;
        if (ms.broadcast) {
            this._lowpan.sendBroadcast((byte)-34, payload, 0, length, 3);
        } else {
            this._lowpan.send((byte)127, (byte)-34, ms.targetAddress, payload, 0, length);
        }
        if (last) {
            // empty if block
        }
    }

    public void clearOutgoing(MessageID mid) {
        this._outgoingMessageStates.remove(mid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIncoming(MessageID mid) {
        IntHashtable intHashtable = this._incomingMessageFragments;
        synchronized (intHashtable) {
            this._incomingMessageFragments.remove(mid.getId());
        }
    }

    public MessageID newOutgoingMessageID(long targetAddress, boolean broadcast) {
        MessageID mid = new MessageID();
        MessageState ms = new MessageState(mid);
        ms.targetAddress = targetAddress;
        ms.broadcast = broadcast;
        this._outgoingMessageStates.put(mid, ms);
        return mid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readMessageFragment(MessageID mid, byte[] buffer) throws IOException {
        MessageFragments mf;
        IntHashtable intHashtable = this._incomingMessageFragments;
        synchronized (intHashtable) {
            mf = (MessageFragments)this._incomingMessageFragments.get(mid.getId());
        }
        if (mf == null) {
            return -1;
        }
        return mf.readFragment(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageID nextAvailableMessage() {
        IntHashtable intHashtable = this._incomingMessageFragments;
        synchronized (intHashtable) {
            while (this._incomingMessageFragments.isEmpty()) {
                try {
                    this._incomingMessageFragments.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            MessageFragments mf = (MessageFragments)this._incomingMessageFragments.elements().nextElement();
            return mf.mid;
        }
    }

    public void start() {
        this._inputHandler.start();
    }

    public void stop() {
        this._inputHandler.stop();
        this.incomingQueue.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processIncomingData(IncomingData incoming) {
        MessageFragments mf;
        int source = (int)(incoming.headerInfo.sourceAddress & 0xFFFFL);
        int num = incoming.payload[0] & 0xFF;
        int id = MessageID.getId(num, source);
        IntHashtable intHashtable = this._incomingMessageFragments;
        synchronized (intHashtable) {
            mf = (MessageFragments)this._incomingMessageFragments.get(id);
            if (mf == null) {
                mf = new MessageFragments(num, source);
                this._incomingMessageFragments.put(id, (Object)mf);
                this._incomingMessageFragments.notify();
            }
        }
        mf.newFragment(incoming);
    }

    private final class InputHandler
    extends AbstractSingleThreadRunner {
        public InputHandler() {
            super("InputHandler");
        }

        protected void doRun() {
            while (!this.isCancelled()) {
                IncomingData incoming = (IncomingData)ProtocolManager.this.incomingQueue.get();
                if (incoming == null) continue;
                ProtocolManager.this.processIncomingData(incoming);
            }
        }

        protected void forkExecution(Runnable runnable, String name) {
            Thread thr = new Thread(runnable, name);
            RadioFactory.setAsDaemonThread((Thread)thr);
            thr.start();
        }
    }
}

