/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm;

import de.dailab.jiac.common.aamm.IModelBase;
import de.dailab.jiac.common.aamm.ISingleFileConfiguration;
import de.dailab.jiac.common.aamm.ext.SingleFileConfiguration;
import java.util.Hashtable;

abstract class ModelBase
implements IModelBase {
    protected transient Hashtable<String, Object> metaData = new Hashtable();

    protected ModelBase() {
    }

    @Override
    public Object clone() {
        ModelBase result;
        try {
            result = (ModelBase)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError((Object)cnse);
        }
        result.metaData = new Hashtable();
        result.metaData.putAll(this.metaData);
        return result;
    }

    @Override
    public void apply(IModelBase.IModelVisitor visitor) {
        visitor.visitModel(this);
    }

    @Override
    public void copyMetaData(IModelBase target) {
        ModelBase tmb = (ModelBase)target;
        tmb.metaData.clear();
        tmb.metaData.putAll(this.metaData);
    }

    @Override
    public final Object getMetaData(String key) {
        return this.metaData.get(key);
    }

    @Override
    public final void setMetaData(String key, Object data) {
        if (data != null) {
            this.metaData.put(key, data);
        } else {
            this.metaData.remove(key);
        }
    }

    @Override
    public ISingleFileConfiguration getConfiguration() {
        return (SingleFileConfiguration)this.metaData.get("model-parent-reference");
    }
}

