/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm;

import de.dailab.jiac.common.aamm.ICollectionType;
import de.dailab.jiac.common.aamm.IComplexType;
import de.dailab.jiac.common.aamm.IEntryType;
import de.dailab.jiac.common.aamm.IModelBase;
import de.dailab.jiac.common.aamm.IPropertyType;
import de.dailab.jiac.common.aamm.ListPropertyType;
import de.dailab.jiac.common.aamm.MapPropertyType;
import java.util.List;

final class PropertyMerge {
    PropertyMerge() {
    }

    static void mergePropertyIntoChild(ListPropertyType list, IComplexType child) {
        assert (list.append == null);
        ListPropertyType childList = (ListPropertyType)PropertyMerge.findProperty(list.getClass(), child, list.getName());
        if (childList != null) {
            if (childList.isAppend()) {
                childList.getItems().addAll(0, (List)((IModelBase)((Object)list.getItems())).clone());
                childList.setAppend(null);
            }
        } else {
            child.getProperties().add((ListPropertyType)list.clone());
        }
    }

    static void mergePropertyIntoChild(MapPropertyType map, IComplexType child) {
        assert (map.append == null);
        MapPropertyType childMap = (MapPropertyType)PropertyMerge.findProperty(map.getClass(), child, map.getName());
        if (childMap != null) {
            if (childMap.isAppend()) {
                for (IEntryType entry : map.getEntries()) {
                    boolean foundKey = false;
                    for (IEntryType childEntry : childMap.getEntries()) {
                        if (!childEntry.getKey().equals(entry.getKey())) continue;
                        foundKey = true;
                        break;
                    }
                    if (foundKey) continue;
                    childMap.getEntries().add(0, (IEntryType)entry.clone());
                }
                childMap.setAppend(null);
            }
        } else {
            child.getProperties().add((MapPropertyType)map.clone());
        }
    }

    static void mergePropertyIntoChild(IPropertyType property, IComplexType child) {
        assert (!ICollectionType.class.isInstance(property));
        Object childProp = PropertyMerge.findProperty(property.getClass(), child, property.getName());
        if (childProp == null) {
            child.getProperties().add((IPropertyType)property.clone());
        }
    }

    private static <P extends IPropertyType> P findProperty(Class<P> propertyType, IComplexType child, String name) {
        for (IPropertyType property : child.getProperties()) {
            if (!property.getName().equals(name)) continue;
            assert (propertyType.isInstance(property));
            return (P)((IPropertyType)propertyType.cast(property));
        }
        return null;
    }
}

