/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.beans;

import de.dailab.jiac.common.aamm.beans.ClassDescriptor;
import de.dailab.jiac.common.aamm.beans.ClassInfo;
import de.dailab.jiac.common.aamm.beans.FeatureDescriptor;
import de.dailab.jiac.common.aamm.beans.GenericBeanInfo;
import de.dailab.jiac.common.aamm.beans.IndexedPropertyDescriptor;
import de.dailab.jiac.common.aamm.beans.MappedPropertyDescriptor;
import de.dailab.jiac.common.aamm.beans.MethodDescriptor;
import de.dailab.jiac.common.aamm.beans.PropertyDescriptor;
import de.dailab.jiac.common.aamm.beans.ReflectUtil;
import java.beans.IntrospectionException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class Introspector {
    private static final boolean DEBUG = false;
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int IGNORE_ALL_BEANINFO = 3;
    private static Map<Class<?>, Reference<Method[]>> declaredMethodCache = Collections.synchronizedMap(new WeakHashMap());
    private static Map<Class<?>, ClassInfo> beanInfoCache = Collections.synchronizedMap(new WeakHashMap());
    private Class<?> beanClass;
    private ClassInfo superBeanInfo;
    private ClassInfo[] additionalBeanInfo;
    private Map<String, MethodDescriptor> methods;
    private Map<String, PropertyDescriptor> properties;
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private HashMap<String, List<PropertyDescriptor>> pdStore = new HashMap();

    public static Class<?> loadClass(Class<?> sibling, String className) throws ClassNotFoundException {
        ClassLoader cl = sibling.getClassLoader();
        if (cl != null) {
            try {
                return cl.loadClass(className);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            cl = ClassLoader.getSystemClassLoader();
            if (cl != null) {
                return cl.loadClass(className);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        cl = Thread.currentThread().getContextClassLoader();
        return cl.loadClass(className);
    }

    public static boolean isList(Class<?> clazz) {
        Class<?> listClass;
        try {
            listClass = Introspector.loadClass(clazz, "java.util.List");
        }
        catch (Exception outerE) {
            try {
                listClass = Introspector.loadClass(clazz, "java.util.Vector");
            }
            catch (Exception innerE) {
                throw new AssertionError((Object)("could not load list class: " + outerE.getMessage() + "; " + innerE.getMessage()));
            }
        }
        return listClass.isAssignableFrom(clazz);
    }

    public static Class<?> getListComponentType(Class<?> listClass) {
        try {
            return Introspector.loadClass(listClass, "java.lang.Object");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean isMap(Class<?> clazz) {
        Class<?> mapClass;
        try {
            mapClass = Introspector.loadClass(clazz, "java.util.Map");
        }
        catch (Exception outerE) {
            try {
                mapClass = Introspector.loadClass(clazz, "java.util.Hashtable");
            }
            catch (Exception innerE) {
                throw new AssertionError((Object)("could not load map class: " + outerE.getMessage() + "; " + innerE.getMessage()));
            }
        }
        return mapClass.isAssignableFrom(clazz);
    }

    public static Class<?> getMapComponentType(Class<?> mapClass) {
        return Introspector.getMapTypeParameter(mapClass, 1);
    }

    public static Class<?> getMapKeyType(Class<?> mapClass) {
        return Introspector.getMapTypeParameter(mapClass, 0);
    }

    private static Class<?> getMapTypeParameter(Class<?> mapClass, int index) {
        try {
            return Introspector.loadClass(mapClass, "java.lang.Object");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean areEqual(Class<?> c1, Class<?> c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1 == c2) {
            return true;
        }
        return c1.getName().equals(c2.getName());
    }

    public static ClassInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        if (!ReflectUtil.isPackageAccessible(beanClass)) {
            return new Introspector(beanClass, null, 1).getBeanInfo();
        }
        ClassInfo bi = beanInfoCache.get(beanClass);
        if (bi == null) {
            bi = new Introspector(beanClass, null, 1).getBeanInfo();
            beanInfoCache.put(beanClass, bi);
        }
        return bi;
    }

    public static ClassInfo getBeanInfo(Class<?> beanClass, int flags) throws IntrospectionException {
        return Introspector.getBeanInfo(beanClass, null, flags);
    }

    public static ClassInfo getBeanInfo(Class<?> beanClass, Class<?> stopClass) throws IntrospectionException {
        return Introspector.getBeanInfo(beanClass, stopClass, 1);
    }

    private static ClassInfo getBeanInfo(Class<?> beanClass, Class<?> stopClass, int flags) throws IntrospectionException {
        ClassInfo bi = stopClass == null && flags == 1 ? Introspector.getBeanInfo(beanClass) : new Introspector(beanClass, stopClass, flags).getBeanInfo();
        return bi;
    }

    private static int getHierarchyDepth(Class<?> cls) {
        Class<?>[] intfs;
        ClassInfo bi = beanInfoCache.get(cls);
        if (bi != null) {
            return bi.getClassDescriptor().getHierarchyDepth();
        }
        int spdepth = -1;
        Class<?> spcls = cls.getSuperclass();
        if (spcls != null) {
            spdepth = Introspector.getHierarchyDepth(spcls);
        }
        if ((intfs = cls.getInterfaces()) != null) {
            for (int i = 0; i < intfs.length; ++i) {
                int idepth = Introspector.getHierarchyDepth(intfs[i]);
                if (idepth <= spdepth) continue;
                spdepth = idepth;
            }
        }
        return spdepth + 1;
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static void flushCaches() {
        beanInfoCache.clear();
        declaredMethodCache.clear();
    }

    public static void flushFromCaches(Class<?> clz) {
        if (clz == null) {
            throw new NullPointerException();
        }
        beanInfoCache.remove(clz);
        declaredMethodCache.remove(clz);
    }

    private static String makeQualifiedMethodName(String name, String[] params) {
        StringBuffer sb = new StringBuffer(name);
        sb.append('=');
        for (int i = 0; i < params.length; ++i) {
            sb.append(':');
            sb.append(params[i]);
        }
        return sb.toString();
    }

    private Introspector(Class<?> beanClass, Class<?> stopClass, int flags) throws IntrospectionException {
        Class<?> superClass;
        this.beanClass = beanClass;
        if (stopClass != null) {
            boolean isSuper = false;
            for (Class<?> c = beanClass.getSuperclass(); c != null; c = c.getSuperclass()) {
                if (c != stopClass) continue;
                isSuper = true;
            }
            if (!isSuper) {
                throw new IntrospectionException(stopClass.getName() + " not superclass of " + beanClass.getName());
            }
        }
        if ((superClass = beanClass.getSuperclass()) != stopClass) {
            int newFlags = flags;
            if (newFlags == 2) {
                newFlags = 1;
            }
            this.superBeanInfo = Introspector.getBeanInfo(superClass, stopClass, newFlags);
        }
        ArrayList<ClassInfo> intfBeanInfos = new ArrayList<ClassInfo>();
        for (Class<?> intf : beanClass.getInterfaces()) {
            intfBeanInfos.add(Introspector.getBeanInfo(intf));
        }
        this.additionalBeanInfo = intfBeanInfos.toArray(new ClassInfo[intfBeanInfos.size()]);
    }

    private ClassInfo getBeanInfo() {
        ClassDescriptor bd = this.getTargetClassDescriptor();
        MethodDescriptor[] mds = this.getTargetMethodInfo();
        PropertyDescriptor[] pds = this.getTargetPropertyInfo();
        GenericBeanInfo result = new GenericBeanInfo(bd, pds, mds);
        return result;
    }

    private MethodDescriptor[] getTargetMethodInfo() {
        int i;
        int i2;
        Object explicitMethods;
        if (this.methods == null) {
            this.methods = new HashMap<String, MethodDescriptor>(100);
        }
        if ((explicitMethods = null) == null && this.superBeanInfo != null) {
            MethodDescriptor[] supers = this.superBeanInfo.getMethodDescriptors();
            for (i2 = 0; i2 < supers.length; ++i2) {
                this.addMethod(supers[i2]);
            }
        }
        for (i = 0; i < this.additionalBeanInfo.length; ++i) {
            MethodDescriptor[] additional = this.additionalBeanInfo[i].getMethodDescriptors();
            if (additional == null) continue;
            for (int j = 0; j < additional.length; ++j) {
                this.addMethod(additional[j]);
            }
        }
        if (explicitMethods != null) {
            for (i = 0; i < (explicitMethods).length; ++i) {
                this.addMethod((MethodDescriptor)explicitMethods[i]);
            }
        } else {
            Method[] methodList = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (i2 = 0; i2 < methodList.length; ++i2) {
                Method method = methodList[i2];
                if (method == null) continue;
                MethodDescriptor md = new MethodDescriptor(method);
                this.addMethod(md);
            }
        }
        MethodDescriptor[] result = new MethodDescriptor[this.methods.size()];
        result = this.methods.values().toArray(result);
        return result;
    }

    private void addMethod(MethodDescriptor md) {
        String name = md.getName();
        MethodDescriptor old = this.methods.get(name);
        if (old == null) {
            this.methods.put(name, md);
            return;
        }
        String[] p1 = md.getParamNames();
        String[] p2 = old.getParamNames();
        boolean match = false;
        if (p1.length == p2.length) {
            match = true;
            for (int i = 0; i < p1.length; ++i) {
                if (p1[i].equals(p2[i])) continue;
                match = false;
                break;
            }
        }
        if (match) {
            MethodDescriptor composite = new MethodDescriptor(old, md);
            this.methods.put(name, composite);
            return;
        }
        String longKey = Introspector.makeQualifiedMethodName(name, p1);
        old = this.methods.get(longKey);
        if (old == null) {
            this.methods.put(longKey, md);
            return;
        }
        MethodDescriptor composite = new MethodDescriptor(old, md);
        this.methods.put(longKey, composite);
    }

    private PropertyDescriptor[] getTargetPropertyInfo() {
        int i;
        int i2;
        Object explicitProperties = null;
        if (explicitProperties == null && this.superBeanInfo != null) {
            PropertyDescriptor[] supers = this.superBeanInfo.getPropertyDescriptors();
            for (i2 = 0; i2 < supers.length; ++i2) {
                this.addPropertyDescriptor(supers[i2]);
            }
        }
        for (i = 0; i < this.additionalBeanInfo.length; ++i) {
            PropertyDescriptor[] additional = this.additionalBeanInfo[i].getPropertyDescriptors();
            if (additional == null) continue;
            for (int j = 0; j < additional.length; ++j) {
                this.addPropertyDescriptor(additional[j]);
            }
        }
        if (explicitProperties != null) {
            for (i = 0; i < (explicitProperties).length; ++i) {
                this.addPropertyDescriptor((PropertyDescriptor)explicitProperties[i]);
            }
        } else {
            Method[] methodList = Introspector.getPublicDeclaredMethods(this.beanClass);
            for (i2 = 0; i2 < methodList.length; ++i2) {
                int mods;
                Method method = methodList[i2];
                if (method == null || Modifier.isStatic(mods = method.getModifiers())) continue;
                String name = method.getName();
                Class<?>[] argTypes = method.getParameterTypes();
                Class<?> resultType = method.getReturnType();
                int argCount = argTypes.length;
                PropertyDescriptor pd = null;
                if (name.length() <= 3 && !name.startsWith(IS_PREFIX)) continue;
                try {
                    if (argCount == 0) {
                        Class<?> returnType = method.getReturnType();
                        if (name.startsWith(GET_PREFIX)) {
                            pd = new PropertyDescriptor(Introspector.decapitalize(name.substring(3)), method, null);
                        } else if (Introspector.areEqual(returnType, Boolean.TYPE) && name.startsWith(IS_PREFIX)) {
                            pd = new PropertyDescriptor(Introspector.decapitalize(name.substring(2)), method, null);
                        }
                    } else if (argCount == 1) {
                        if (name.startsWith(GET_PREFIX)) {
                            if (Introspector.areEqual(argTypes[0], Integer.TYPE)) {
                                pd = new IndexedPropertyDescriptor(Introspector.decapitalize(name.substring(3)), null, null, method, null);
                            } else if (Introspector.areEqual(argTypes[0], String.class)) {
                                pd = new MappedPropertyDescriptor(Introspector.decapitalize(name.substring(3)), null, null, method, null);
                            }
                        } else if (Introspector.areEqual(resultType, Void.TYPE) && name.startsWith(SET_PREFIX)) {
                            pd = new PropertyDescriptor(Introspector.decapitalize(name.substring(3)), null, method);
                        }
                    } else if (argCount == 2 && name.startsWith(SET_PREFIX)) {
                        if (Introspector.areEqual(argTypes[0], Integer.TYPE)) {
                            pd = new IndexedPropertyDescriptor(Introspector.decapitalize(name.substring(3)), null, null, null, method);
                        } else if (Introspector.areEqual(argTypes[0], String.class)) {
                            pd = new MappedPropertyDescriptor(Introspector.decapitalize(name.substring(3)), null, null, null, method);
                        }
                    }
                }
                catch (IntrospectionException ex) {
                    ex.printStackTrace();
                    pd = null;
                }
                if (pd == null) continue;
                this.addPropertyDescriptor(pd);
            }
        }
        this.processPropertyDescriptors();
        PropertyDescriptor[] result = new PropertyDescriptor[this.properties.size()];
        result = this.properties.values().toArray(result);
        return result;
    }

    private void addPropertyDescriptor(PropertyDescriptor pd) {
        String propName = pd.getName();
        List<PropertyDescriptor> list = this.pdStore.get(propName);
        if (list == null) {
            list = new ArrayList<PropertyDescriptor>();
            this.pdStore.put(propName, list);
        }
        list.add(pd);
    }

    private void processPropertyDescriptors() {
        if (this.properties == null) {
            this.properties = new TreeMap<String, PropertyDescriptor>();
        }
        Iterator<List<PropertyDescriptor>> it = this.pdStore.values().iterator();
        while (it.hasNext()) {
            int i;
            PropertyDescriptor pd = null;
            PropertyDescriptor gpd = null;
            PropertyDescriptor spd = null;
            IndexedPropertyDescriptor ipd = null;
            IndexedPropertyDescriptor igpd = null;
            IndexedPropertyDescriptor ispd = null;
            MappedPropertyDescriptor mpd = null;
            MappedPropertyDescriptor mgpd = null;
            MappedPropertyDescriptor mspd = null;
            List<PropertyDescriptor> list = it.next();
            for (i = 0; i < list.size(); ++i) {
                pd = list.get(i);
                if (pd instanceof IndexedPropertyDescriptor) {
                    ipd = (IndexedPropertyDescriptor)pd;
                    if (ipd.getIndexedReadMethod() == null) continue;
                    if (igpd != null) {
                        igpd = new IndexedPropertyDescriptor(igpd, ipd);
                        continue;
                    }
                    igpd = ipd;
                    continue;
                }
                if (pd instanceof MappedPropertyDescriptor) {
                    mpd = (MappedPropertyDescriptor)pd;
                    if (mpd.getMappedReadMethod() == null) continue;
                    if (mgpd != null) {
                        mgpd = new MappedPropertyDescriptor(mgpd, mpd);
                        continue;
                    }
                    mgpd = mpd;
                    continue;
                }
                if (pd.getReadMethod() == null) continue;
                if (gpd != null) {
                    Method method = gpd.getReadMethod();
                    if (method.getName().startsWith(IS_PREFIX)) continue;
                    gpd = new PropertyDescriptor(gpd, pd);
                    continue;
                }
                gpd = pd;
            }
            for (i = 0; i < list.size(); ++i) {
                pd = list.get(i);
                if (pd instanceof IndexedPropertyDescriptor) {
                    ipd = (IndexedPropertyDescriptor)pd;
                    if (ipd.getIndexedWriteMethod() == null) continue;
                    if (igpd != null) {
                        if (igpd.getIndexedPropertyType() != ipd.getIndexedPropertyType()) continue;
                        if (ispd != null) {
                            ispd = new IndexedPropertyDescriptor(ispd, ipd);
                            continue;
                        }
                        ispd = ipd;
                        continue;
                    }
                    if (ispd != null) {
                        ispd = new IndexedPropertyDescriptor(ispd, ipd);
                        continue;
                    }
                    ispd = ipd;
                    continue;
                }
                if (pd instanceof MappedPropertyDescriptor) {
                    mpd = (MappedPropertyDescriptor)pd;
                    if (mpd.getMappedWriteMethod() == null) continue;
                    if (mgpd != null) {
                        if (mgpd.getMappedPropertyType() != mpd.getMappedPropertyType()) continue;
                        if (mspd != null) {
                            mspd = new MappedPropertyDescriptor(mspd, mpd);
                            continue;
                        }
                        mspd = mpd;
                        continue;
                    }
                    if (mspd != null) {
                        mspd = new MappedPropertyDescriptor(mspd, mpd);
                        continue;
                    }
                    mspd = mpd;
                    continue;
                }
                if (pd.getWriteMethod() == null) continue;
                if (gpd != null) {
                    if (gpd.getPropertyType() != pd.getPropertyType()) continue;
                    if (spd != null) {
                        spd = new PropertyDescriptor(spd, pd);
                        continue;
                    }
                    spd = pd;
                    continue;
                }
                spd = spd != null ? new PropertyDescriptor(spd, pd) : pd;
            }
            pd = null;
            ipd = null;
            mpd = null;
            if (igpd != null && ispd != null) {
                PropertyDescriptor tpd;
                if (gpd != null && (tpd = this.mergePropertyDescriptor(igpd, gpd)) instanceof IndexedPropertyDescriptor) {
                    igpd = (IndexedPropertyDescriptor)tpd;
                }
                if (spd != null && (tpd = this.mergePropertyDescriptor(ispd, spd)) instanceof IndexedPropertyDescriptor) {
                    ispd = (IndexedPropertyDescriptor)tpd;
                }
                pd = igpd == ispd ? igpd : this.mergePropertyDescriptor(igpd, ispd);
            } else if (mgpd != null && mspd != null) {
                PropertyDescriptor tpd;
                if (gpd != null && (tpd = this.mergePropertyDescriptor(mgpd, gpd)) instanceof MappedPropertyDescriptor) {
                    mgpd = (MappedPropertyDescriptor)tpd;
                }
                if (spd != null && (tpd = this.mergePropertyDescriptor(mspd, spd)) instanceof MappedPropertyDescriptor) {
                    mspd = (MappedPropertyDescriptor)tpd;
                }
                pd = mgpd == mspd ? mgpd : this.mergePropertyDescriptor(mgpd, mspd);
            } else if (gpd != null && spd != null) {
                pd = gpd == spd ? gpd : this.mergePropertyDescriptor(gpd, spd);
            } else if (ispd != null) {
                pd = ispd;
                if (spd != null) {
                    pd = this.mergePropertyDescriptor(ispd, spd);
                }
                if (gpd != null) {
                    pd = this.mergePropertyDescriptor(ispd, gpd);
                }
            } else if (igpd != null) {
                pd = igpd;
                if (gpd != null) {
                    pd = this.mergePropertyDescriptor(igpd, gpd);
                }
                if (spd != null) {
                    pd = this.mergePropertyDescriptor(igpd, spd);
                }
            } else if (mspd != null) {
                pd = mspd;
                if (spd != null) {
                    pd = this.mergePropertyDescriptor(mspd, spd);
                }
                if (gpd != null) {
                    pd = this.mergePropertyDescriptor(mspd, gpd);
                }
            } else if (mgpd != null) {
                pd = mgpd;
                if (gpd != null) {
                    pd = this.mergePropertyDescriptor(mgpd, gpd);
                }
                if (spd != null) {
                    pd = this.mergePropertyDescriptor(mgpd, spd);
                }
            } else if (spd != null) {
                pd = spd;
            } else if (gpd != null) {
                pd = gpd;
            }
            if (pd instanceof IndexedPropertyDescriptor) {
                ipd = (IndexedPropertyDescriptor)pd;
                if (ipd.getIndexedReadMethod() == null && ipd.getIndexedWriteMethod() == null) {
                    pd = new PropertyDescriptor(ipd);
                }
            } else if (pd instanceof MappedPropertyDescriptor && (mpd = (MappedPropertyDescriptor)pd).getMappedReadMethod() == null && mpd.getMappedWriteMethod() == null) {
                pd = new PropertyDescriptor(mpd);
            }
            if (pd == null && list.size() > 0) {
                pd = list.get(0);
            }
            if (pd == null) continue;
            this.properties.put(pd.getName(), pd);
        }
    }

    private PropertyDescriptor mergePropertyDescriptor(IndexedPropertyDescriptor ipd, PropertyDescriptor pd) {
        PropertyDescriptor result = null;
        Class<?> propType = pd.getPropertyType();
        Class<?> ipropType = ipd.getIndexedPropertyType();
        if (propType.isArray() && propType.getComponentType() == ipropType || Introspector.isList(propType) && Introspector.getListComponentType(propType).isAssignableFrom(ipropType)) {
            result = pd.getClass0().isAssignableFrom(ipd.getClass0()) ? new IndexedPropertyDescriptor(pd, ipd) : new IndexedPropertyDescriptor(ipd, pd);
        } else if (pd.getClass0().isAssignableFrom(ipd.getClass0())) {
            result = ipd;
        } else {
            result = pd;
            Method write = result.getWriteMethod();
            Method read = result.getReadMethod();
            if (read == null && write != null && (read = Introspector.findMethod(result.getClass0(), GET_PREFIX + FeatureDescriptor.capitalize(result.getName()), 0)) != null) {
                try {
                    result.setReadMethod(read);
                }
                catch (IntrospectionException ex) {
                    // empty catch block
                }
            }
            if (write == null && read != null && (write = Introspector.findMethod(result.getClass0(), SET_PREFIX + FeatureDescriptor.capitalize(result.getName()), 1, new Class[]{read.getReturnType()})) != null) {
                try {
                    result.setWriteMethod(write);
                }
                catch (IntrospectionException ex) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private PropertyDescriptor mergePropertyDescriptor(MappedPropertyDescriptor mpd, PropertyDescriptor pd) {
        PropertyDescriptor result = null;
        Class<?> propType = pd.getPropertyType();
        Class<?> mpropType = mpd.getMappedPropertyType();
        if (Introspector.isMap(propType) && Introspector.getMapComponentType(propType).isAssignableFrom(mpropType)) {
            result = pd.getClass0().isAssignableFrom(mpd.getClass0()) ? new MappedPropertyDescriptor(pd, mpd) : new MappedPropertyDescriptor(mpd, pd);
        } else if (pd.getClass0().isAssignableFrom(mpd.getClass0())) {
            result = mpd;
        } else {
            result = pd;
            Method write = result.getWriteMethod();
            Method read = result.getReadMethod();
            if (read == null && write != null && (read = Introspector.findMethod(result.getClass0(), GET_PREFIX + FeatureDescriptor.capitalize(result.getName()), 0)) != null) {
                try {
                    result.setReadMethod(read);
                }
                catch (IntrospectionException ex) {
                    // empty catch block
                }
            }
            if (write == null && read != null && (write = Introspector.findMethod(result.getClass0(), SET_PREFIX + FeatureDescriptor.capitalize(result.getName()), 1, new Class[]{read.getReturnType()})) != null) {
                try {
                    result.setWriteMethod(write);
                }
                catch (IntrospectionException ex) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private PropertyDescriptor mergePropertyDescriptor(PropertyDescriptor pd1, PropertyDescriptor pd2) {
        if (pd1.getClass0().isAssignableFrom(pd2.getClass0())) {
            return new PropertyDescriptor(pd1, pd2);
        }
        return new PropertyDescriptor(pd2, pd1);
    }

    private PropertyDescriptor mergePropertyDescriptor(IndexedPropertyDescriptor ipd1, IndexedPropertyDescriptor ipd2) {
        if (ipd1.getClass0().isAssignableFrom(ipd2.getClass0())) {
            return new IndexedPropertyDescriptor(ipd1, ipd2);
        }
        return new IndexedPropertyDescriptor(ipd2, ipd1);
    }

    private PropertyDescriptor mergePropertyDescriptor(MappedPropertyDescriptor mpd1, MappedPropertyDescriptor mpd2) {
        if (mpd1.getClass0().isAssignableFrom(mpd2.getClass0())) {
            return new MappedPropertyDescriptor(mpd1, mpd2);
        }
        return new MappedPropertyDescriptor(mpd2, mpd1);
    }

    private ClassDescriptor getTargetClassDescriptor() {
        return new ClassDescriptor(this.beanClass, Introspector.getHierarchyDepth(this.beanClass));
    }

    private static synchronized Method[] getPublicDeclaredMethods(Class<?> clz) {
        Method[] result = null;
        if (!ReflectUtil.isPackageAccessible(clz)) {
            return new Method[0];
        }
        final Class<?> fclz = clz;
        Reference<Method[]> ref = declaredMethodCache.get(fclz);
        if (ref != null && (result = ref.get()) != null) {
            return result;
        }
        result = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return fclz.getDeclaredMethods();
            }
        });
        for (int i = 0; i < result.length; ++i) {
            Method method = result[i];
            int mods = method.getModifiers();
            if (Modifier.isPublic(mods)) continue;
            result[i] = null;
        }
        declaredMethodCache.put(fclz, new SoftReference<Method[]>(result));
        return result;
    }

    private static Method internalFindMethod(Class<?> start, String methodName, int argCount, Class<?>[] args) {
        Method method = null;
        for (Class<?> cl = start; cl != null; cl = cl.getSuperclass()) {
            Method[] methods = Introspector.getPublicDeclaredMethods(cl);
            for (int i = 0; i < methods.length; ++i) {
                method = methods[i];
                if (method == null) continue;
                Class<?>[] params = method.getParameterTypes();
                if (!method.getName().equals(methodName) || params.length != argCount) continue;
                if (args != null) {
                    boolean different = false;
                    if (argCount > 0) {
                        for (int j = 0; j < argCount; ++j) {
                            if (Introspector.areEqual(params[j], args[j])) continue;
                            different = true;
                        }
                        if (different) continue;
                    }
                }
                return method;
            }
        }
        method = null;
        Class<?>[] ifcs = start.getInterfaces();
        for (int i = 0; i < ifcs.length && (method = Introspector.internalFindMethod(ifcs[i], methodName, argCount, null)) == null; ++i) {
        }
        return method;
    }

    static Method findMethod(Class<?> cls, String methodName, int argCount) {
        return Introspector.findMethod(cls, methodName, argCount, null);
    }

    static Method findMethod(Class<?> cls, String methodName, int argCount, Class<?>[] args) {
        if (methodName == null) {
            return null;
        }
        return Introspector.internalFindMethod(cls, methodName, argCount, args);
    }

    public static boolean isSubclass(Class<?> a, Class<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        for (Class<?> x = a; x != null; x = x.getSuperclass()) {
            if (Introspector.areEqual(x, b)) {
                return true;
            }
            if (!b.isInterface()) continue;
            Class<?>[] interfaces = x.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Introspector.isSubclass(interfaces[i], b)) continue;
                return true;
            }
        }
        return false;
    }

    static Object instantiate(Class<?> sibling, String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> cls = Introspector.loadClass(sibling, className);
        return cls.newInstance();
    }
}

