/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.beans;

import de.dailab.jiac.common.aamm.beans.Introspector;
import de.dailab.jiac.common.aamm.beans.PropertyDescriptor;
import java.beans.IntrospectionException;
import java.lang.ref.Reference;
import java.lang.reflect.Method;

public class MappedPropertyDescriptor
extends PropertyDescriptor {
    private Reference<Class> mappedPropertyTypeRef;
    private Reference<Method> mappedReadMethodRef;
    private Reference<Method> mappedWriteMethodRef;
    private String mappedReadMethodName;
    private String mappedWriteMethodName;

    public MappedPropertyDescriptor(String propertyName, Class<?> beanClass) throws IntrospectionException {
        this(propertyName, beanClass, "get" + MappedPropertyDescriptor.capitalize(propertyName), "set" + MappedPropertyDescriptor.capitalize(propertyName), "get" + MappedPropertyDescriptor.capitalize(propertyName), "set" + MappedPropertyDescriptor.capitalize(propertyName));
    }

    public MappedPropertyDescriptor(String propertyName, Class<?> beanClass, String readMethodName, String writeMethodName, String mappedReadMethodName, String mappedWriteMethodName) throws IntrospectionException {
        super(propertyName, beanClass, readMethodName, writeMethodName);
        this.mappedReadMethodName = mappedReadMethodName;
        if (mappedReadMethodName != null && this.getMappedReadMethod() == null) {
            throw new IntrospectionException("Method not found: " + mappedReadMethodName);
        }
        this.mappedWriteMethodName = mappedWriteMethodName;
        if (mappedWriteMethodName != null && this.getMappedWriteMethod() == null) {
            throw new IntrospectionException("Method not found: " + mappedWriteMethodName);
        }
        this.findMappedPropertyType(this.getMappedReadMethod(), this.getMappedWriteMethod());
    }

    public MappedPropertyDescriptor(String propertyName, Method readMethod, Method writeMethod, Method mappedReadMethod, Method mappedWriteMethod) throws IntrospectionException {
        super(propertyName, readMethod, writeMethod);
        this.setMappedReadMethod0(mappedReadMethod);
        this.setMappedWriteMethod0(mappedWriteMethod);
        this.setMappedPropertyType(this.findMappedPropertyType(mappedReadMethod, mappedWriteMethod));
    }

    public synchronized Method getMappedReadMethod() {
        Method mappedReadMethod = this.getMappedReadMethod0();
        if (mappedReadMethod == null) {
            Class[] args;
            Class<?> cls = this.getClass0();
            if (cls == null || this.mappedReadMethodName == null && this.mappedReadMethodRef == null) {
                return null;
            }
            if (this.mappedReadMethodName == null) {
                Class<?> type = this.getMappedPropertyType0();
                this.mappedReadMethodName = Introspector.areEqual(type, Boolean.TYPE) || type == null ? "is" + this.getBaseName() : "get" + this.getBaseName();
            }
            if ((mappedReadMethod = Introspector.findMethod(cls, this.mappedReadMethodName, 1, args = new Class[]{String.class})) == null) {
                this.mappedReadMethodName = "get" + this.getBaseName();
                mappedReadMethod = Introspector.findMethod(cls, this.mappedReadMethodName, 1, args);
            }
            this.setMappedReadMethod0(mappedReadMethod);
        }
        return mappedReadMethod;
    }

    public synchronized void setMappedReadMethod(Method readMethod) throws IntrospectionException {
        this.setMappedPropertyType(this.findMappedPropertyType(readMethod, this.getMappedWriteMethod0()));
        this.setMappedReadMethod0(readMethod);
    }

    private void setMappedReadMethod0(Method readMethod) {
        if (readMethod == null) {
            this.mappedReadMethodName = null;
            this.mappedReadMethodRef = null;
            return;
        }
        this.setClass0(readMethod.getDeclaringClass());
        this.mappedReadMethodName = readMethod.getName();
        this.mappedReadMethodRef = MappedPropertyDescriptor.createReference(readMethod);
    }

    public synchronized Method getMappedWriteMethod() {
        Method mappedWriteMethod = this.getMappedWriteMethod0();
        if (mappedWriteMethod == null) {
            Class[] classArray;
            Class<?> type;
            Class<?> cls;
            block8: {
                cls = this.getClass0();
                if (cls == null || this.mappedWriteMethodName == null && this.mappedWriteMethodRef == null) {
                    return null;
                }
                type = this.getMappedPropertyType0();
                if (type == null) {
                    try {
                        type = this.findMappedPropertyType(this.getMappedReadMethod(), null);
                        this.setMappedPropertyType(type);
                    }
                    catch (IntrospectionException ex) {
                        Class<?> propType = this.getPropertyType();
                        if (!Introspector.isMap(propType)) break block8;
                        type = Introspector.getMapComponentType(propType);
                    }
                }
            }
            if (this.mappedWriteMethodName == null) {
                this.mappedWriteMethodName = "set" + this.getBaseName();
            }
            if (type == null) {
                classArray = null;
            } else {
                Class[] classArray2 = new Class[2];
                classArray2[0] = String.class;
                classArray = classArray2;
                classArray2[1] = type;
            }
            mappedWriteMethod = Introspector.findMethod(cls, this.mappedWriteMethodName, 2, classArray);
            this.setMappedWriteMethod0(mappedWriteMethod);
        }
        return mappedWriteMethod;
    }

    public synchronized void setMappedWriteMethod(Method writeMethod) throws IntrospectionException {
        Class<?> type = this.findMappedPropertyType(this.getMappedReadMethod(), writeMethod);
        this.setMappedPropertyType(type);
        this.setMappedWriteMethod0(writeMethod);
    }

    private void setMappedWriteMethod0(Method writeMethod) {
        if (writeMethod == null) {
            this.mappedWriteMethodName = null;
            this.mappedWriteMethodRef = null;
            return;
        }
        this.setClass0(writeMethod.getDeclaringClass());
        this.mappedWriteMethodName = writeMethod.getName();
        this.mappedWriteMethodRef = MappedPropertyDescriptor.createReference(writeMethod);
    }

    public synchronized Class<?> getMappedPropertyType() {
        Class<?> type = this.getMappedPropertyType0();
        if (type == null) {
            try {
                type = this.findMappedPropertyType(this.getMappedReadMethod(), this.getMappedWriteMethod());
                this.setMappedPropertyType(type);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return type;
    }

    private void setMappedPropertyType(Class type) {
        this.mappedPropertyTypeRef = MappedPropertyDescriptor.createReference(type);
    }

    private Class<?> getMappedPropertyType0() {
        return MappedPropertyDescriptor.getObject(this.mappedPropertyTypeRef);
    }

    private Method getMappedReadMethod0() {
        return MappedPropertyDescriptor.getObject(this.mappedReadMethodRef);
    }

    private Method getMappedWriteMethod0() {
        return MappedPropertyDescriptor.getObject(this.mappedWriteMethodRef);
    }

    private Class<?> findMappedPropertyType(Method mappedReadMethod, Method mappedWriteMethod) throws IntrospectionException {
        Class<?> propertyType;
        Class<?>[] params;
        Class<?> mappedPropertyType = null;
        if (mappedReadMethod != null) {
            params = mappedReadMethod.getParameterTypes();
            if (params.length != 1) {
                throw new IntrospectionException("bad mapped read method arg count");
            }
            if (!Introspector.areEqual(params[0], String.class)) {
                throw new IntrospectionException("non string key to mapped read method");
            }
            mappedPropertyType = mappedReadMethod.getReturnType();
            if (Introspector.areEqual(mappedPropertyType, Void.TYPE)) {
                throw new IntrospectionException("mapped read method returns void");
            }
        }
        if (mappedWriteMethod != null) {
            params = mappedWriteMethod.getParameterTypes();
            if (params.length != 2) {
                throw new IntrospectionException("bad mapped write method arg count");
            }
            if (!Introspector.areEqual(params[0], String.class)) {
                throw new IntrospectionException("non string key to mapped write method");
            }
            if (mappedPropertyType != null && mappedPropertyType != params[1]) {
                throw new IntrospectionException("type mismatch between mapped read and mapped write methods: " + this.getName());
            }
            mappedPropertyType = params[1];
        }
        if ((propertyType = this.getPropertyType()) != null) {
            if (Introspector.isMap(propertyType)) {
                if (!Introspector.getMapComponentType(propertyType).isAssignableFrom(mappedPropertyType)) {
                    throw new IntrospectionException("type mismatch between mapped and non-mapped methods: " + this.getName());
                }
            } else {
                throw new IntrospectionException("property is not a valid mapped property: " + this.getName());
            }
        }
        if (!(propertyType == null || propertyType.isArray() && propertyType.getComponentType() == mappedPropertyType)) {
            throw new IntrospectionException("type mismatch between mapped and non-mapped methods: " + this.getName());
        }
        return mappedPropertyType;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof MappedPropertyDescriptor) {
            MappedPropertyDescriptor other = (MappedPropertyDescriptor)obj;
            Method otherMappedReadMethod = other.getMappedReadMethod();
            Method otherMappedWriteMethod = other.getMappedWriteMethod();
            if (!this.compareMethods(this.getMappedReadMethod(), otherMappedReadMethod)) {
                return false;
            }
            if (!this.compareMethods(this.getMappedWriteMethod(), otherMappedWriteMethod)) {
                return false;
            }
            if (this.getMappedPropertyType() != other.getMappedPropertyType()) {
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public boolean isReadable() {
        return super.isReadable() || this.getMappedReadMethod() != null;
    }

    @Override
    public boolean isWritable() {
        return super.isWritable() || this.getMappedWriteMethod() != null;
    }

    MappedPropertyDescriptor(PropertyDescriptor x, PropertyDescriptor y) {
        super(x, y);
        if (x instanceof MappedPropertyDescriptor) {
            MappedPropertyDescriptor mx = (MappedPropertyDescriptor)x;
            try {
                Method xw;
                Method xr = mx.getMappedReadMethod();
                if (xr != null) {
                    this.setMappedReadMethod(xr);
                }
                if ((xw = mx.getMappedWriteMethod()) != null) {
                    this.setMappedWriteMethod(xw);
                }
            }
            catch (IntrospectionException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        if (y instanceof MappedPropertyDescriptor) {
            MappedPropertyDescriptor my = (MappedPropertyDescriptor)y;
            try {
                Method yw;
                Method yr = my.getMappedReadMethod();
                if (yr != null && yr.getDeclaringClass() == this.getClass0()) {
                    this.setMappedReadMethod(yr);
                }
                if ((yw = my.getMappedWriteMethod()) != null && yw.getDeclaringClass() == this.getClass0()) {
                    this.setMappedWriteMethod(yw);
                }
            }
            catch (IntrospectionException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }

    MappedPropertyDescriptor(MappedPropertyDescriptor old) {
        super(old);
        this.mappedReadMethodRef = old.mappedReadMethodRef;
        this.mappedWriteMethodRef = old.mappedWriteMethodRef;
        this.mappedPropertyTypeRef = old.mappedPropertyTypeRef;
        this.mappedWriteMethodName = old.mappedWriteMethodName;
        this.mappedReadMethodName = old.mappedReadMethodName;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + (this.mappedWriteMethodName == null ? 0 : this.mappedWriteMethodName.hashCode());
        result = 37 * result + (this.mappedReadMethodName == null ? 0 : this.mappedReadMethodName.hashCode());
        result = 37 * result + (this.getMappedPropertyType() == null ? 0 : this.getMappedPropertyType().hashCode());
        return result;
    }

    @Override
    protected boolean internalReduce(PropertyDescriptor pd) {
        boolean result = super.internalReduce(pd);
        if (pd instanceof MappedPropertyDescriptor) {
            MappedPropertyDescriptor mpd = (MappedPropertyDescriptor)pd;
            if (mpd.mappedReadMethodName != null || mpd.mappedReadMethodRef != null) {
                this.mappedReadMethodName = null;
                this.mappedReadMethodRef = null;
            }
            if (mpd.mappedWriteMethodName != null || mpd.mappedWriteMethodRef != null) {
                this.mappedWriteMethodName = null;
                this.mappedWriteMethodRef = null;
            }
        }
        return result || this.mappedReadMethodRef != null || this.mappedWriteMethodRef != null;
    }

    @Override
    public String toString() {
        String message = super.toString();
        message = message + ", mappedType=";
        message = message + this.getMappedPropertyType();
        message = message + ", mappedWriteMethod=";
        message = message + this.mappedWriteMethodName;
        message = message + ", mappedReadMethod=";
        message = message + this.mappedReadMethodName;
        return message;
    }
}

