/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.beans;

import de.dailab.jiac.common.aamm.beans.FeatureDescriptor;
import de.dailab.jiac.common.aamm.beans.Introspector;
import de.dailab.jiac.common.aamm.beans.ParameterDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MethodDescriptor
extends FeatureDescriptor {
    private Reference<Method> methodRef;
    private String[] paramNames;
    private List<Reference<Class>> params;
    private ParameterDescriptor[] parameterDescriptors;

    public MethodDescriptor(Method method) {
        this(method, null);
    }

    public MethodDescriptor(Method method, ParameterDescriptor[] parameterDescriptors) {
        this.setName(method.getName());
        this.setMethod(method);
        this.parameterDescriptors = parameterDescriptors;
    }

    public synchronized Method getMethod() {
        Class<?> cls;
        Method method = this.getMethod0();
        if (method == null && (cls = this.getClass0()) != null) {
            Class<?>[] params = this.getParams();
            if (params == null) {
                for (int i = 0; i < 3 && (method = Introspector.findMethod(cls, this.getName(), i, null)) == null; ++i) {
                }
            } else {
                method = Introspector.findMethod(cls, this.getName(), params.length, params);
            }
            this.setMethod(method);
        }
        return method;
    }

    private synchronized void setMethod(Method method) {
        if (method == null) {
            return;
        }
        if (this.getClass0() == null) {
            this.setClass0(method.getDeclaringClass());
        }
        this.setParams(method.getParameterTypes());
        this.methodRef = MethodDescriptor.createReference(method, true);
    }

    private Method getMethod0() {
        return MethodDescriptor.getObject(this.methodRef);
    }

    private synchronized void setParams(Class<?>[] param) {
        if (param == null) {
            return;
        }
        this.paramNames = new String[param.length];
        this.params = new ArrayList<Reference<Class>>(param.length);
        for (int i = 0; i < param.length; ++i) {
            this.paramNames[i] = param[i].getName();
            this.params.add(new WeakReference(param[i]));
        }
    }

    String[] getParamNames() {
        return this.paramNames;
    }

    private synchronized Class<?>[] getParams() {
        Class[] clss = new Class[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            Reference<Class> ref = this.params.get(i);
            Class cls = ref.get();
            if (cls == null) {
                return null;
            }
            clss[i] = cls;
        }
        return clss;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return this.parameterDescriptors;
    }

    MethodDescriptor(MethodDescriptor x, MethodDescriptor y) {
        super(x, y);
        this.methodRef = x.methodRef;
        if (y.methodRef != null) {
            this.methodRef = y.methodRef;
        }
        this.params = x.params;
        if (y.params != null) {
            this.params = y.params;
        }
        this.paramNames = x.paramNames;
        if (y.paramNames != null) {
            this.paramNames = y.paramNames;
        }
        this.parameterDescriptors = x.parameterDescriptors;
        if (y.parameterDescriptors != null) {
            this.parameterDescriptors = y.parameterDescriptors;
        }
    }

    MethodDescriptor(MethodDescriptor old) {
        super(old);
        this.methodRef = old.methodRef;
        this.params = old.params;
        this.paramNames = old.paramNames;
        if (old.parameterDescriptors != null) {
            int len = old.parameterDescriptors.length;
            this.parameterDescriptors = new ParameterDescriptor[len];
            for (int i = 0; i < len; ++i) {
                this.parameterDescriptors[i] = new ParameterDescriptor(old.parameterDescriptors[i]);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof MethodDescriptor) {
            Class<?> declClass;
            MethodDescriptor other = (MethodDescriptor)obj;
            Class<?> otherDeclClass = other.getClass0();
            if (!otherDeclClass.isAssignableFrom(declClass = this.getClass0()) && !declClass.isAssignableFrom(otherDeclClass)) {
                return false;
            }
            String[] otherParamNames = other.getParamNames();
            if (this.paramNames != null && otherParamNames != null) {
                if (this.paramNames.length != otherParamNames.length) {
                    return false;
                }
                for (int i = 0; i < this.paramNames.length; ++i) {
                    if (this.paramNames[i].equals(otherParamNames[i])) continue;
                    return false;
                }
                return true;
            }
            return this.paramNames == otherParamNames;
        }
        return false;
    }

    public int hashCode() {
        int result = 7;
        result = 37 * result + this.getName().hashCode();
        if (this.paramNames != null) {
            for (int i = 0; i < this.paramNames.length; ++i) {
                result = 37 * result + this.paramNames[i].hashCode();
            }
        }
        return result;
    }

    public String toString() {
        String[] names;
        StringBuilder message = new StringBuilder();
        message.append("method: name=").append(this.getName());
        Class<?> cls = this.getClass0();
        if (cls != null) {
            message.append(", class=");
            message.append(cls.getName());
        }
        if ((names = this.getParamNames()) != null) {
            for (int i = 0; i < names.length; ++i) {
                message.append(", param=").append(names[i]);
            }
        }
        return message.toString();
    }
}

