/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.beans;

import de.dailab.jiac.common.aamm.beans.FeatureDescriptor;
import de.dailab.jiac.common.aamm.beans.IndexedPropertyDescriptor;
import de.dailab.jiac.common.aamm.beans.Introspector;
import de.dailab.jiac.common.aamm.beans.MappedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.lang.ref.Reference;
import java.lang.reflect.Method;

public class PropertyDescriptor
extends FeatureDescriptor {
    private Reference<Class> propertyTypeRef;
    private Reference<Method> readMethodRef;
    private Reference<Method> writeMethodRef;
    private String baseName;
    private String writeMethodName;
    private String readMethodName;

    public static PropertyDescriptor merge(PropertyDescriptor x, PropertyDescriptor y) {
        PropertyDescriptor result = x instanceof IndexedPropertyDescriptor || y instanceof IndexedPropertyDescriptor ? new IndexedPropertyDescriptor(x, y) : (x instanceof MappedPropertyDescriptor || y instanceof MappedPropertyDescriptor ? new MappedPropertyDescriptor(x, y) : new PropertyDescriptor(x, y));
        return result;
    }

    public static PropertyDescriptor reduce(PropertyDescriptor x, PropertyDescriptor y) {
        PropertyDescriptor result = x instanceof IndexedPropertyDescriptor ? new IndexedPropertyDescriptor((IndexedPropertyDescriptor)x) : (x instanceof MappedPropertyDescriptor ? new MappedPropertyDescriptor((MappedPropertyDescriptor)x) : new PropertyDescriptor(x));
        return ((PropertyDescriptor)result).internalReduce(y) ? result : null;
    }

    public PropertyDescriptor(String propertyName, Class<?> clazz) throws IntrospectionException {
        this(propertyName, clazz, "is" + PropertyDescriptor.capitalize(propertyName), "set" + PropertyDescriptor.capitalize(propertyName));
    }

    public PropertyDescriptor(String propertyName, Class<?> clazz, String readMethodName, String writeMethodName) throws IntrospectionException {
        if (clazz == null) {
            throw new IntrospectionException("Target Bean class is null");
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name");
        }
        if ("".equals(readMethodName) || "".equals(writeMethodName)) {
            throw new IntrospectionException("read or write method name should not be the empty string");
        }
        this.setName(propertyName);
        this.setClass0(clazz);
        this.readMethodName = readMethodName;
        if (readMethodName != null && this.getReadMethod() == null) {
            throw new IntrospectionException("Method not found: " + readMethodName);
        }
        this.writeMethodName = writeMethodName;
        if (writeMethodName != null && this.getWriteMethod() == null) {
            throw new IntrospectionException("Method not found: " + writeMethodName);
        }
    }

    public PropertyDescriptor(String propertyName, Method readMethod, Method writeMethod) throws IntrospectionException {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name");
        }
        this.setName(propertyName);
        this.setReadMethod(readMethod);
        this.setWriteMethod(writeMethod);
    }

    PropertyDescriptor(PropertyDescriptor x, PropertyDescriptor y) {
        super(x, y);
        this.baseName = y.baseName != null ? y.baseName : x.baseName;
        this.readMethodName = y.readMethodName != null ? y.readMethodName : x.readMethodName;
        this.writeMethodName = y.writeMethodName != null ? y.writeMethodName : x.writeMethodName;
        this.propertyTypeRef = y.propertyTypeRef != null ? y.propertyTypeRef : x.propertyTypeRef;
        Method xr = x.getReadMethod();
        Method yr = y.getReadMethod();
        try {
            if (yr != null && yr.getDeclaringClass() == this.getClass0()) {
                this.setReadMethod(yr);
            } else {
                this.setReadMethod(xr);
            }
        }
        catch (IntrospectionException ex) {
            // empty catch block
        }
        if (xr != null && yr != null && xr.getDeclaringClass() == yr.getDeclaringClass() && xr.getReturnType() == Boolean.TYPE && yr.getReturnType() == Boolean.TYPE && xr.getName().indexOf("is") == 0 && yr.getName().indexOf("get") == 0) {
            try {
                this.setReadMethod(xr);
            }
            catch (IntrospectionException ex) {
                // empty catch block
            }
        }
        Method xw = x.getWriteMethod();
        Method yw = y.getWriteMethod();
        try {
            if (yw != null && yw.getDeclaringClass() == this.getClass0()) {
                this.setWriteMethod(yw);
            } else {
                this.setWriteMethod(xw);
            }
        }
        catch (IntrospectionException ex) {
            // empty catch block
        }
    }

    PropertyDescriptor(PropertyDescriptor old) {
        super(old);
        this.propertyTypeRef = old.propertyTypeRef;
        this.readMethodRef = old.readMethodRef;
        this.writeMethodRef = old.writeMethodRef;
        this.writeMethodName = old.writeMethodName;
        this.readMethodName = old.readMethodName;
        this.baseName = old.baseName;
    }

    public synchronized Class<?> getPropertyType() {
        Class<?> type = this.getPropertyType0();
        if (type == null) {
            try {
                type = this.findPropertyType(this.getReadMethod(), this.getWriteMethod());
                this.setPropertyType(type);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return type;
    }

    private void setPropertyType(Class type) {
        this.propertyTypeRef = PropertyDescriptor.createReference(type);
    }

    private Class<?> getPropertyType0() {
        return PropertyDescriptor.getObject(this.propertyTypeRef);
    }

    public synchronized Method getReadMethod() {
        Method readMethod = this.getReadMethod0();
        if (readMethod == null) {
            Class<?> cls = this.getClass0();
            if (cls == null || this.readMethodName == null && this.readMethodRef == null) {
                return null;
            }
            if (this.readMethodName == null) {
                Class<?> type = this.getPropertyType0();
                this.readMethodName = type == Boolean.TYPE || type == null ? "is" + this.getBaseName() : "get" + this.getBaseName();
            }
            if ((readMethod = Introspector.findMethod(cls, this.readMethodName, 0)) == null) {
                this.readMethodName = "get" + this.getBaseName();
                readMethod = Introspector.findMethod(cls, this.readMethodName, 0);
            }
            try {
                this.setReadMethod(readMethod);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return readMethod;
    }

    public synchronized void setReadMethod(Method readMethod) throws IntrospectionException {
        if (readMethod == null) {
            this.readMethodName = null;
            this.readMethodRef = null;
            return;
        }
        this.setPropertyType(this.findPropertyType(readMethod, this.getWriteMethod0()));
        this.setClass0(readMethod.getDeclaringClass());
        this.readMethodName = readMethod.getName();
        this.readMethodRef = PropertyDescriptor.createReference(readMethod, true);
    }

    public synchronized Method getWriteMethod() {
        Method writeMethod = this.getWriteMethod0();
        if (writeMethod == null) {
            Class[] classArray;
            Class<?> cls = this.getClass0();
            if (cls == null || this.writeMethodName == null && this.writeMethodRef == null) {
                return null;
            }
            Class<?> type = this.getPropertyType0();
            if (type == null) {
                try {
                    type = this.findPropertyType(this.getReadMethod(), null);
                    this.setPropertyType(type);
                }
                catch (IntrospectionException ex) {
                    return null;
                }
            }
            if (this.writeMethodName == null) {
                this.writeMethodName = "set" + this.getBaseName();
            }
            if (type == null) {
                classArray = null;
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = type;
            }
            writeMethod = Introspector.findMethod(cls, this.writeMethodName, 1, classArray);
            try {
                this.setWriteMethod(writeMethod);
            }
            catch (IntrospectionException ex) {
                // empty catch block
            }
        }
        return writeMethod;
    }

    public synchronized void setWriteMethod(Method writeMethod) throws IntrospectionException {
        if (writeMethod == null) {
            this.writeMethodName = null;
            this.writeMethodRef = null;
            return;
        }
        this.setPropertyType(this.findPropertyType(this.getReadMethod(), writeMethod));
        this.setClass0(writeMethod.getDeclaringClass());
        this.writeMethodName = writeMethod.getName();
        this.writeMethodRef = PropertyDescriptor.createReference(writeMethod, true);
    }

    public boolean isReadable() {
        return this.getReadMethod() != null;
    }

    public boolean isWritable() {
        return this.getWriteMethod() != null;
    }

    private Method getReadMethod0() {
        return PropertyDescriptor.getObject(this.readMethodRef);
    }

    private Method getWriteMethod0() {
        return PropertyDescriptor.getObject(this.writeMethodRef);
    }

    @Override
    void setClass0(Class clz) {
        if (this.getClass0() != null && clz.isAssignableFrom(this.getClass0())) {
            return;
        }
        super.setClass0(clz);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof PropertyDescriptor) {
            PropertyDescriptor other = (PropertyDescriptor)obj;
            Method otherReadMethod = other.getReadMethod();
            Method otherWriteMethod = other.getWriteMethod();
            if (!this.compareMethods(this.getReadMethod(), otherReadMethod)) {
                return false;
            }
            if (!this.compareMethods(this.getWriteMethod(), otherWriteMethod)) {
                return false;
            }
            if (this.getPropertyType() == other.getPropertyType() && this.writeMethodName == other.writeMethodName && this.readMethodName == other.readMethodName) {
                return true;
            }
        }
        return false;
    }

    boolean compareMethods(Method a, Method b) {
        if (a == null != (b == null)) {
            return false;
        }
        return a == null || b == null || a.equals(b);
    }

    private Class<?> findPropertyType(Method readMethod, Method writeMethod) throws IntrospectionException {
        Class<?>[] params;
        Class<?> propertyType = null;
        if (readMethod != null) {
            params = readMethod.getParameterTypes();
            if (params.length != 0) {
                throw new IntrospectionException("bad read method arg count: " + readMethod);
            }
            propertyType = readMethod.getReturnType();
            if (propertyType == Void.TYPE) {
                throw new IntrospectionException("read method " + readMethod.getName() + " returns void");
            }
        }
        if (writeMethod != null) {
            params = writeMethod.getParameterTypes();
            if (params.length != 1) {
                throw new IntrospectionException("bad write method arg count: " + writeMethod);
            }
            if (propertyType != null && propertyType != params[0]) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            propertyType = params[0];
        }
        return propertyType;
    }

    public int hashCode() {
        int result = 7;
        result = 37 * result + (this.getPropertyType() == null ? 0 : this.getPropertyType().hashCode());
        result = 37 * result + (this.getReadMethod() == null ? 0 : this.getReadMethod().hashCode());
        result = 37 * result + (this.getWriteMethod() == null ? 0 : this.getWriteMethod().hashCode());
        result = 37 * result + (this.writeMethodName == null ? 0 : this.writeMethodName.hashCode());
        result = 37 * result + (this.readMethodName == null ? 0 : this.readMethodName.hashCode());
        result = 37 * result + this.getName().hashCode();
        return result;
    }

    String getBaseName() {
        if (this.baseName == null) {
            this.baseName = PropertyDescriptor.capitalize(this.getName());
        }
        return this.baseName;
    }

    protected boolean internalReduce(PropertyDescriptor pd) {
        if (pd.readMethodName != null || pd.readMethodRef != null) {
            this.readMethodName = null;
            this.readMethodRef = null;
        }
        if (pd.writeMethodName != null || pd.writeMethodRef != null) {
            this.writeMethodName = null;
            this.writeMethodRef = null;
        }
        return this.readMethodRef != null || this.writeMethodRef != null;
    }

    public String toString() {
        String message = "property: name=" + this.getName();
        message = message + ", class=" + this.getClass0();
        message = message + ", type=" + this.getPropertyType();
        message = message + ", writeMethod=";
        message = message + this.writeMethodName;
        message = message + ", readMethod=";
        message = message + this.readMethodName;
        return message;
    }
}

