/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.check;

import de.dailab.jiac.common.aamm.IModelBase;
import de.dailab.jiac.common.aamm.IPropertyType;
import de.dailab.jiac.common.aamm.IReferencableComplexType;
import de.dailab.jiac.common.aamm.ListPropertyType;
import de.dailab.jiac.common.aamm.MapPropertyType;
import de.dailab.jiac.common.aamm.NamedComplexType;
import de.dailab.jiac.common.aamm.ObjectFactory;
import de.dailab.jiac.common.aamm.ReferencableAgentElementType;
import de.dailab.jiac.common.aamm.ReferencableAgentType;
import de.dailab.jiac.common.aamm.ReferencableNodeType;
import de.dailab.jiac.common.aamm.ReferencableObjectType;
import de.dailab.jiac.common.aamm.ReferencePropertyType;
import de.dailab.jiac.common.aamm.ReferenceType;
import de.dailab.jiac.common.aamm.SimplePropertyType;
import de.dailab.jiac.common.aamm.beans.ClassInfo;
import de.dailab.jiac.common.aamm.beans.IndexedPropertyDescriptor;
import de.dailab.jiac.common.aamm.beans.Introspector;
import de.dailab.jiac.common.aamm.beans.MappedPropertyDescriptor;
import de.dailab.jiac.common.aamm.beans.PropertyDescriptor;
import de.dailab.jiac.common.aamm.ext.Reference;
import de.dailab.jiac.common.aamm.resolve.MergedConfiguration;
import de.dailab.jiac.common.aamm.resolve.ResolutionException;
import de.dailab.jiac.common.aamm.tools.CheckerToolContext;
import de.dailab.jiac.common.aamm.tools.ICheckerParams;
import de.dailab.jiac.common.aamm.util.IMetaDataConstants;
import de.dailab.jiac.common.aamm.util.PropertyCheckHelper;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;

public class DefinitionChecker
implements IMetaDataConstants {
    protected final CheckerToolContext context;
    protected CheckerResult checkerResult;
    protected CheckerCallback callback;
    private HashMap<Class<?>, DefinitionHandler<?>> _handler;

    public DefinitionChecker(CheckerToolContext context, ICheckerParams params) throws ClassNotFoundException {
        this.context = context;
        this._handler = new HashMap();
        ObjectFactory factory = context.getObjectFactory();
        ClassLoader loader = context.getLoader();
        this._handler.put(factory.createReferencableNodeType().getClass(), new DefinitionHandler<ReferencableNodeType>(loader.loadClass(params.getNodeClassName())){

            @Override
            public boolean handleParent(ReferencableNodeType current, IReferencableComplexType parent, MergedConfiguration config) {
                if (parent instanceof ReferencableNodeType) {
                    DefinitionChecker.this.doCheck(parent, "node", config, false);
                    current.getAgentRefs().addAll(0, ((ReferencableNodeType)parent).getAgentRefs());
                    return true;
                }
                return false;
            }

            @Override
            void checkSpecialChildren(ReferencableNodeType current, MergedConfiguration config) {
                for (ReferenceType agentRef : current.getAgentRefs()) {
                    try {
                        DefinitionChecker.this.doCheck(config.getAgent(agentRef), "agent", config, true);
                    }
                    catch (ResolutionException re) {
                        DefinitionChecker.this.checkerResult.errors.add("error with agent reference: " + re.getMessage());
                    }
                }
            }
        });
        this._handler.put(factory.createReferencableAgentType().getClass(), new DefinitionHandler<ReferencableAgentType>(loader.loadClass(params.getAgentClassName())){

            @Override
            public boolean handleParent(ReferencableAgentType current, IReferencableComplexType parent, MergedConfiguration config) {
                if (parent instanceof ReferencableAgentType) {
                    DefinitionChecker.this.doCheck(parent, "agent", config, false);
                    current.getAgentElements().addAll(0, ((ReferencableAgentType)parent).getAgentElements());
                    return true;
                }
                return false;
            }

            @Override
            void checkSpecialChildren(ReferencableAgentType current, MergedConfiguration config) {
                for (IModelBase agentElementRef : current.getAgentElements()) {
                    try {
                        DefinitionChecker.this.doCheck(config.getAgentElement(agentElementRef), "agent element", config, true);
                    }
                    catch (ResolutionException re) {
                        DefinitionChecker.this.checkerResult.errors.add("error with agent element reference: " + re.getMessage());
                    }
                }
            }
        });
        this._handler.put(factory.createReferencableAgentElementType().getClass(), new DefinitionHandler<ReferencableAgentElementType>(loader.loadClass(params.getAgentElementClassName())){

            @Override
            public boolean handleParent(ReferencableAgentElementType current, IReferencableComplexType parent, MergedConfiguration config) {
                if (parent instanceof ReferencableAgentElementType) {
                    DefinitionChecker.this.doCheck(parent, "agent element", config, false);
                    return true;
                }
                return false;
            }
        });
        this._handler.put(factory.createReferencableObjectType().getClass(), new DefinitionHandler<ReferencableObjectType>(loader.loadClass(params.getObjectClassName())){

            @Override
            public boolean handleParent(ReferencableObjectType current, IReferencableComplexType parent, MergedConfiguration config) {
                if (parent instanceof ReferencableObjectType) {
                    DefinitionChecker.this.doCheck(parent, "object", config, false);
                    return true;
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CheckerResult flattenAndCheck(MergedConfiguration config) {
        this.checkerResult = new CheckerResult();
        this.callback = new CheckerCallback(config);
        try {
            for (Reference nodeReference : config.nodesToUse) {
                try {
                    this.doCheck(config.getNode(nodeReference), "node", config, true);
                }
                catch (ResolutionException re) {
                    this.checkerResult.errors.add("error with node reference: " + re.getMessage());
                }
            }
            for (Reference agentReference : config.agentsToUse) {
                try {
                    this.doCheck(config.getAgent(agentReference), "agent", config, true);
                }
                catch (ResolutionException re) {
                    this.checkerResult.errors.add("error with agent reference: " + re.getMessage());
                }
            }
            CheckerResult checkerResult = this.checkerResult;
            return checkerResult;
        }
        finally {
            this.callback = null;
            this.checkerResult = null;
        }
    }

    protected static void mergePropertiesOfComplexPart(IReferencableComplexType parent, IReferencableComplexType child) {
        String displayName;
        String clazz = parent.getClazz();
        if (clazz != null && child.getClazz() == null) {
            child.setClazz(clazz);
        }
        if (parent instanceof NamedComplexType && child instanceof NamedComplexType && (displayName = ((NamedComplexType)((Object)parent)).getDisplayName()) != null && ((NamedComplexType)((Object)child)).getDisplayName() == null) {
            ((NamedComplexType)((Object)child)).setDisplayName(displayName);
        }
        for (IPropertyType property : parent.getProperties()) {
            property.mergeIntoChildProperties(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCheck(IReferencableComplexType complex, String type, MergedConfiguration config, boolean concrete) {
        Object state;
        Reference ref = Reference.createFor(complex);
        if (concrete && complex.getParent() == null && complex.getClazz() == null) {
            this.checkerResult.errors.add(type + " '" + ref + "' does not define class");
        }
        if ((state = complex.getMetaData("checkStateKey")) == CHECKED) {
            return;
        }
        if (state == IN_PROGRESS) {
            this.checkerResult.errors.add("cyclic reference for " + type + " '" + ref + "'");
            return;
        }
        complex.setMetaData("checkStateKey", IN_PROGRESS);
        try {
            DefinitionHandler<?> handler = this._handler.get(complex.getClass());
            if (complex.getParent() != null) {
                IReferencableComplexType parent = config.cache.get(Reference.createFrom(complex.getParent()));
                if (!handler.handleParent(complex, parent, config)) {
                    this.checkerResult.errors.add("parent of " + type + " '" + ref + "' is invalid");
                    return;
                }
                DefinitionChecker.mergePropertiesOfComplexPart(parent, complex);
                complex.setParent(null);
            }
            handler.checkSpecialChildren(complex, config);
            this.checkPropertiesOfComplexPart(complex, type, handler.superClass, concrete);
        }
        finally {
            complex.setMetaData("checkStateKey", CHECKED);
        }
    }

    private void checkPropertiesOfComplexPart(IReferencableComplexType complex, String type, Class<?> superClass, boolean concrete) {
        Class<?> clazz;
        Reference ref = Reference.createFor(complex);
        String className = complex.getClazz();
        if (className == null) {
            if (concrete) {
                this.checkerResult.errors.add(type + " '" + ref + "' does not define class");
            }
            return;
        }
        try {
            clazz = this.context.getLoader().loadClass(className);
        }
        catch (Exception e) {
            this.checkerResult.errors.add("could not find class '" + className + "' for " + type + " definition '" + ref + "' " + e);
            return;
        }
        if (!superClass.isAssignableFrom(clazz)) {
            this.checkerResult.errors.add("class of '" + ref + "' is invalid for type " + type);
            return;
        }
        int cmods = clazz.getModifiers();
        if (Modifier.isAbstract(cmods) || !Modifier.isPublic(cmods) || clazz.isInterface()) {
            this.checkerResult.errors.add("class of '" + ref + "' is abstract or an interface");
            return;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            this.checkerResult.errors.add("class of '" + ref + "' has no default constructor");
            return;
        }
        HashMap<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();
        try {
            ClassInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                if (pd instanceof IndexedPropertyDescriptor && ((IndexedPropertyDescriptor)pd).getIndexedWriteMethod() != null) {
                    descriptors.put(pd.getName(), pd);
                    continue;
                }
                if (pd instanceof MappedPropertyDescriptor && ((MappedPropertyDescriptor)pd).getMappedWriteMethod() != null) {
                    descriptors.put(pd.getName(), pd);
                    continue;
                }
                if (pd.getWriteMethod() == null) continue;
                descriptors.put(pd.getName(), pd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.checkerResult.errors.add("could not introspect class '" + clazz + ": " + e);
            return;
        }
        for (IPropertyType prop : complex.getProperties()) {
            PropertyDescriptor pd = (PropertyDescriptor)descriptors.get(prop.getName());
            if (pd == null) {
                this.checkerResult.errors.add("property " + prop.getName() + " not available");
                continue;
            }
            if (prop instanceof ListPropertyType) {
                this.callback.prefix = "list property '" + prop.getName();
                PropertyCheckHelper.checkListProperty((ListPropertyType)prop, pd, this.callback);
                continue;
            }
            if (prop instanceof MapPropertyType) {
                this.callback.prefix = "map property '" + prop.getName();
                PropertyCheckHelper.checkMapProperty((MapPropertyType)prop, pd, this.callback);
                continue;
            }
            if (prop instanceof ReferencePropertyType) {
                this.callback.prefix = "reference property '" + prop.getName();
                PropertyCheckHelper.checkReferenceProperty((ReferencePropertyType)prop, pd, this.callback);
                continue;
            }
            this.callback.prefix = "simple property '" + prop.getName();
            PropertyCheckHelper.checkSimpleProperty((SimplePropertyType)prop, pd, this.callback);
        }
    }

    public final class CheckerCallback {
        String prefix;
        private final MergedConfiguration _config;

        public CheckerCallback(MergedConfiguration config) {
            this._config = config;
        }

        public void enforceTypeForReference(Reference reference, Class<?> expected, String errorMessage) {
            String savePrefix = this.prefix;
            IReferencableComplexType complexType = this._config.cache.get(reference);
            DefinitionChecker.this.doCheck(complexType, "object", this._config, true);
            this.prefix = savePrefix;
            if (complexType.getClazz() != null) {
                try {
                    Class<?> specified = DefinitionChecker.this.context.getLoader().loadClass(complexType.getClazz());
                    if (!expected.isAssignableFrom(specified)) {
                        this.addErrorMessage(errorMessage);
                    }
                }
                catch (Exception e) {
                    this.addErrorMessage("could not load class '" + complexType.getClazz() + "': " + e.getMessage());
                }
            }
        }

        public void addErrorMessage(String errorMessage) {
            DefinitionChecker.this.checkerResult.errors.add(this.prefix + " " + errorMessage);
        }
    }

    static abstract class DefinitionHandler<T extends IReferencableComplexType> {
        final Class<?> superClass;

        DefinitionHandler(Class<?> superClass) {
            this.superClass = superClass;
        }

        abstract boolean handleParent(T var1, IReferencableComplexType var2, MergedConfiguration var3);

        void checkSpecialChildren(T current, MergedConfiguration config) {
        }
    }

    public static class CheckerResult {
        public final HashSet<String> errors = new HashSet();
        public final HashSet<String> warnings = new HashSet();

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.errors.size() > 0) {
                builder.append("ERRORS: \n");
                for (String err : this.errors) {
                    builder.append('\t').append(err).append('\n');
                }
            }
            if (this.warnings.size() > 0) {
                builder.append("WARNINGS: \n");
                for (String warn : this.warnings) {
                    builder.append('\t').append(warn).append('\n');
                }
            }
            return builder.toString();
        }

        public boolean hasErrors() {
            return this.errors.size() > 0;
        }

        public boolean hasWarnings() {
            return this.warnings.size() > 0;
        }
    }
}

