/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.check;

import de.dailab.jiac.common.aamm.beans.Introspector;
import de.dailab.jiac.common.aamm.check.StringConcatenationExpression;
import de.dailab.jiac.common.aamm.check.StringLiteralExpression;
import de.dailab.jiac.common.aamm.check.VariableExpression;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public abstract class Expression {
    public static String parseAndConvertToStringValue(String value, ClassLoader loader) {
        StringBuilder builder = new StringBuilder();
        for (Expression e : Expression.parse(value, loader)) {
            builder.append(e.toStringValue());
        }
        return builder.toString();
    }

    public static Expression parseAndConvertToJavaExpression(String value, ClassLoader loader) {
        return Expression.merge(Expression.parse(value, loader));
    }

    public static final Expression merge(Expression ... expressions) {
        return expressions.length == 1 ? expressions[0] : new StringConcatenationExpression(expressions);
    }

    public static final Expression merge(List<Expression> expressions) {
        return expressions.size() == 1 ? expressions.get(0) : new StringConcatenationExpression(expressions.toArray(new Expression[expressions.size()]));
    }

    private static List<Expression> parse(String value, ClassLoader loader) {
        int end;
        int open;
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        String current = value;
        while ((open = current.indexOf("${")) >= 0 && (end = current.indexOf(125)) > open) {
            if (open > 0) {
                expressions.add(new StringLiteralExpression(current.substring(0, open)));
            }
            String variable = current.substring(open + 2, end);
            String className = variable.substring(0, variable.lastIndexOf(46));
            String variableName = variable.substring(className.length() + 1);
            try {
                Class<?> clazz = loader.loadClass(className);
                Field field = clazz.getField(variableName);
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                    throw new IllegalArgumentException("field '" + variableName + "' is not public and static");
                }
                expressions.add(new VariableExpression(variable, field));
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("could not load class '" + className + "'", cnfe);
            }
            catch (NoSuchFieldException nsfe) {
                throw new IllegalArgumentException("could not find field '" + variable + "'", nsfe);
            }
            current = end < current.length() - 1 ? current.substring(end + 1) : "";
        }
        if (current.length() > 0) {
            expressions.add(new StringLiteralExpression(current));
        }
        return expressions;
    }

    protected abstract Class<?> getType();

    protected abstract String toJavaExpression();

    protected abstract String toStringValue();

    public String toString() {
        return this.toJavaExpression();
    }

    public final String convertToJavaExpression(Class<?> targetType) {
        boolean objectType = false;
        if (Introspector.areEqual(targetType, Object.class)) {
            objectType = true;
            targetType = this.getType();
        }
        if (Introspector.areEqual(targetType, Boolean.class) || Introspector.areEqual(targetType, Boolean.TYPE)) {
            return this.convertToBooleanJavaExpression(!objectType && targetType.isPrimitive());
        }
        if (Introspector.areEqual(targetType, Byte.class) || Introspector.areEqual(targetType, Byte.TYPE)) {
            return this.convertToByteJavaExpression(!objectType && targetType.isPrimitive());
        }
        if (Introspector.areEqual(targetType, Character.class) || Introspector.areEqual(targetType, Character.TYPE)) {
            return this.convertToCharJavaExpression(!objectType && targetType.isPrimitive());
        }
        if (Introspector.areEqual(targetType, Double.class) || Introspector.areEqual(targetType, Double.TYPE)) {
            return this.convertToDoubleJavaExpression(!objectType && targetType.isPrimitive());
        }
        if (Introspector.areEqual(targetType, Float.class) || Introspector.areEqual(targetType, Float.TYPE)) {
            return this.convertToFloatJavaExpression(!objectType && targetType.isPrimitive());
        }
        if (Introspector.areEqual(targetType, Integer.class) || Introspector.areEqual(targetType, Integer.TYPE)) {
            return this.convertToIntJavaExpression(!objectType && targetType.isPrimitive());
        }
        if (Introspector.areEqual(targetType, Long.class) || Introspector.areEqual(targetType, Long.TYPE)) {
            return this.convertToLongJavaExpression(!objectType && targetType.isPrimitive());
        }
        if (Introspector.areEqual(targetType, Short.class) || Introspector.areEqual(targetType, Short.TYPE)) {
            return this.convertToShortJavaExpression(!objectType && targetType.isPrimitive());
        }
        if (Introspector.areEqual(targetType, String.class)) {
            return this.convertToStringJavaExpression();
        }
        throw new IllegalArgumentException("cannot convert " + this.toJavaExpression() + " (" + this.getType() + ") to " + targetType);
    }

    private String convertToBooleanJavaExpression(boolean isPrimitive) {
        Class<?> myType = this.getType();
        if (myType == String.class) {
            String suffix;
            String string = suffix = isPrimitive ? ".booleanValue()" : "";
            if (this instanceof StringLiteralExpression) {
                return (this.toJavaExpression().equalsIgnoreCase("\"true\"") ? "Boolean.TRUE" : "Boolean.FALSE") + suffix;
            }
            return "(" + this.toJavaExpression() + ".equalsIgnoreCase(\"true\") ? Boolean.TRUE : Boolean.FALSE)" + suffix;
        }
        if (myType == Boolean.class) {
            return isPrimitive ? this.toJavaExpression() + ".booleanValue()" : this.toJavaExpression();
        }
        if (myType == Boolean.TYPE) {
            return isPrimitive ? this.toJavaExpression() : "(" + this.toJavaExpression() + " ? Boolean.TRUE : Boolean.FALSE)";
        }
        throw new IllegalArgumentException("cannot convert " + this.toJavaExpression() + " (" + myType + ") to " + (isPrimitive ? "boolean" : "java.lang.Boolean"));
    }

    private String convertToByteJavaExpression(boolean isPrimitive) {
        Class<?> myType = this.getType();
        if (myType == String.class) {
            if (this instanceof StringLiteralExpression) {
                byte value = Byte.parseByte(this.toJavaExpression().replace("\"", ""));
                return isPrimitive ? "(byte)" + value : "new Byte((byte)" + value + ")";
            }
            String value = "Byte.parseByte(" + this.toJavaExpression() + ")";
            return isPrimitive ? value : "new Byte(" + value + ")";
        }
        if (myType == Byte.class) {
            return isPrimitive ? this.toJavaExpression() + ".byteValue()" : this.toJavaExpression();
        }
        if (myType == Byte.TYPE) {
            return isPrimitive ? this.toJavaExpression() : "new Byte(" + this.toJavaExpression() + ")";
        }
        throw new IllegalArgumentException("cannot convert " + this.toJavaExpression() + " (" + myType + ") to " + (isPrimitive ? "byte" : "java.lang.Byte"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertToCharJavaExpression(boolean isPrimitive) {
        Class<?> myType = this.getType();
        if (myType == String.class) {
            if (this instanceof StringLiteralExpression) {
                String value = this.toJavaExpression().replace("\"", "'");
                if (value.length() != 3) throw new IllegalArgumentException("cannot convert " + this.toJavaExpression() + " (" + myType + ") to " + (isPrimitive ? "char" : "java.lang.Character"));
                return isPrimitive ? value : "new Character(" + value + ")";
            }
            String value = this.toJavaExpression() + ".charAt(0)";
            return isPrimitive ? value : "new Character(" + value + ")";
        }
        if (myType == Character.class) {
            return isPrimitive ? this.toJavaExpression() + ".charValue()" : this.toJavaExpression();
        }
        if (myType != Byte.TYPE) throw new IllegalArgumentException("cannot convert " + this.toJavaExpression() + " (" + myType + ") to " + (isPrimitive ? "char" : "java.lang.Character"));
        return isPrimitive ? this.toJavaExpression() : "new Character(" + this.toJavaExpression() + ")";
    }

    private String convertToDoubleJavaExpression(boolean isPrimitive) {
        Class<?> myType = this.getType();
        if (myType == String.class) {
            if (this instanceof StringLiteralExpression) {
                double value = Double.parseDouble(this.toJavaExpression().replace("\"", ""));
                return isPrimitive ? String.valueOf(value) : "new Double(" + value + ")";
            }
            String value = "Double.parseDouble(" + this.toJavaExpression() + ")";
            return isPrimitive ? value : "new Double(" + value + ")";
        }
        if (myType == Double.class) {
            return isPrimitive ? this.toJavaExpression() + ".doubleValue()" : this.toJavaExpression();
        }
        if (myType == Double.TYPE) {
            return isPrimitive ? this.toJavaExpression() : "new Double(" + this.toJavaExpression() + ")";
        }
        if (myType == Float.class) {
            String value = "(double)" + this.toJavaExpression() + ".floatValue()";
            return isPrimitive ? value : "new Double(" + value + ")";
        }
        if (myType == Float.TYPE) {
            String value = "(double)" + this.toJavaExpression();
            return isPrimitive ? value : "new Double(" + value + ")";
        }
        throw new IllegalArgumentException("cannot convert " + this.toJavaExpression() + " (" + myType + ") to " + (isPrimitive ? "double" : "java.lang.Double"));
    }

    private String convertToFloatJavaExpression(boolean isPrimitive) {
        Class<?> myType = this.getType();
        if (myType == String.class) {
            if (this instanceof StringLiteralExpression) {
                float value = Float.parseFloat(this.toJavaExpression().replace("\"", ""));
                return isPrimitive ? String.valueOf(value) : "new Float(" + value + ")";
            }
            String value = "Float.parseFloat(" + this.toJavaExpression() + ")";
            return isPrimitive ? value : "new Float(" + value + ")";
        }
        if (myType == Float.class) {
            return isPrimitive ? this.toJavaExpression() + ".floatValue()" : this.toJavaExpression();
        }
        if (myType == Float.TYPE) {
            return isPrimitive ? this.toJavaExpression() : "new Float(" + this.toJavaExpression() + ")";
        }
        throw new IllegalArgumentException("cannot convert " + this.toJavaExpression() + " (" + myType + ") to " + (isPrimitive ? "float" : "java.lang.Float"));
    }

    private String convertToIntJavaExpression(boolean isPrimitive) {
        Class<?> myType = this.getType();
        if (myType == String.class) {
            if (this instanceof StringLiteralExpression) {
                int value = Integer.parseInt(this.toJavaExpression().replace("\"", ""));
                return isPrimitive ? String.valueOf(value) : "new Integer(" + value + ")";
            }
            String value = "Integer.parseInt(" + this.toJavaExpression() + ")";
            return isPrimitive ? value : "new Integer(" + value + ")";
        }
        if (myType == Integer.class) {
            return isPrimitive ? this.toJavaExpression() + ".intValue()" : this.toJavaExpression();
        }
        if (myType == Integer.TYPE) {
            return isPrimitive ? this.toJavaExpression() : "new Integer(" + this.toJavaExpression() + ")";
        }
        if (myType == Byte.TYPE || myType == Short.TYPE) {
            String value = "(int)" + this.toJavaExpression();
            return isPrimitive ? value : "new Integer(" + value + ")";
        }
        if (myType == Byte.class || myType == Short.class) {
            String value = "(int)" + this.toJavaExpression() + (myType == Byte.class ? ".byteValue()" : ".shortValue()");
            return isPrimitive ? value : "new Integer(" + value + ")";
        }
        throw new IllegalArgumentException("cannot convert " + this.toJavaExpression() + " (" + myType + ") to " + (isPrimitive ? "int" : "java.lang.Integer"));
    }

    private String convertToLongJavaExpression(boolean isPrimitive) {
        Class<?> myType = this.getType();
        if (myType == String.class) {
            if (this instanceof StringLiteralExpression) {
                long value = Long.parseLong(this.toJavaExpression().replace("\"", ""));
                return isPrimitive ? String.valueOf(value) : "new Long(" + value + "L)";
            }
            String value = "Long.parseLong(" + this.toJavaExpression() + ")";
            return isPrimitive ? value : "new Long(" + value + "L)";
        }
        if (myType == Long.class) {
            return isPrimitive ? this.toJavaExpression() + ".longValue()" : this.toJavaExpression();
        }
        if (myType == Long.TYPE) {
            return isPrimitive ? this.toJavaExpression() : "new Long(" + this.toJavaExpression() + "L)";
        }
        if (myType == Byte.TYPE || myType == Short.TYPE || myType == Integer.TYPE) {
            String value = "(long)" + this.toJavaExpression();
            return isPrimitive ? value : "new Long(" + value + ")";
        }
        if (myType == Byte.class || myType == Short.class || myType == Integer.class) {
            String value = "(long)" + this.toJavaExpression() + (myType == Byte.class ? ".byteValue()" : (myType == Short.class ? ".shortValue()" : ".intValue()"));
            return isPrimitive ? value : "new Long(" + value + ")";
        }
        throw new IllegalArgumentException("cannot convert " + this.toJavaExpression() + " (" + myType + ") to " + (isPrimitive ? "long" : "java.lang.Long"));
    }

    private String convertToShortJavaExpression(boolean isPrimitive) {
        Class<?> myType = this.getType();
        if (myType == String.class) {
            if (this instanceof StringLiteralExpression) {
                short value = Short.parseShort(this.toJavaExpression().replace("\"", ""));
                return isPrimitive ? "(short)" + value : "new Short((short)" + value + ")";
            }
            String value = "Short.parseShort(" + this.toJavaExpression() + ")";
            return isPrimitive ? value : "new Short(" + value + ")";
        }
        if (myType == Short.class) {
            return isPrimitive ? this.toJavaExpression() + ".shortValue()" : this.toJavaExpression();
        }
        if (myType == Short.TYPE) {
            return isPrimitive ? this.toJavaExpression() : "new Short(" + this.toJavaExpression() + ")";
        }
        if (myType == Byte.class) {
            String value = "(short)" + this.toJavaExpression() + ".byteValue()";
            return isPrimitive ? value : "new Short(" + value + ")";
        }
        if (myType == Byte.TYPE) {
            String value = "(short)" + this.toJavaExpression();
            return isPrimitive ? value : "new Short(" + value + ")";
        }
        throw new IllegalArgumentException("cannot convert " + this.toJavaExpression() + " (" + myType + ") to " + (isPrimitive ? "short" : "java.lang.Short"));
    }

    private String convertToStringJavaExpression() {
        Class<?> myType = this.getType();
        if (myType == String.class) {
            return this.toJavaExpression();
        }
        if (myType.isPrimitive()) {
            return "String.valueOf(" + this.toJavaExpression() + ")";
        }
        return this.toJavaExpression() + ".toString()";
    }
}

