/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.check;

import de.dailab.jiac.common.aamm.check.Expression;

class StringConcatenationExpression
extends Expression {
    private final Expression[] _expressions;

    StringConcatenationExpression(Expression ... expressions) {
        if (expressions.length <= 1) {
            throw new IllegalArgumentException("expressions must contain at least two expressions");
        }
        this._expressions = expressions;
    }

    @Override
    protected String toJavaExpression() {
        StringBuilder result = new StringBuilder();
        int last = this._expressions.length - 1;
        for (int i = 0; i <= last; ++i) {
            result.append(this._expressions[i].toJavaExpression());
            if (i >= last) continue;
            result.append('+');
        }
        return result.toString();
    }

    @Override
    protected Class<?> getType() {
        return String.class;
    }

    @Override
    protected String toStringValue() {
        StringBuilder builder = new StringBuilder();
        for (Expression e : this._expressions) {
            builder.append(e.toStringValue());
        }
        return builder.toString();
    }
}

