/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.ext;

import de.dailab.jiac.common.aamm.ICollectionType;
import de.dailab.jiac.common.aamm.IComplexType;
import de.dailab.jiac.common.aamm.IModelBase;
import de.dailab.jiac.common.aamm.IPropertyType;
import de.dailab.jiac.common.aamm.IReferenceType;
import de.dailab.jiac.common.aamm.ReferencableAgentType;
import de.dailab.jiac.common.aamm.ReferencableNodeType;
import de.dailab.jiac.common.aamm.ReferenceType;
import de.dailab.jiac.common.aamm.ext.Reference;
import java.util.HashSet;
import java.util.Set;

public final class DependencyCollector {
    public static Set<Reference> getDependencies(IComplexType self) {
        HashSet<Reference> dependencies = new HashSet<Reference>();
        for (IPropertyType prop : self.getProperties()) {
            if (prop instanceof IReferenceType) {
                dependencies.add(Reference.createFrom((IReferenceType)((Object)prop)));
                continue;
            }
            if (!(prop instanceof ICollectionType)) continue;
            for (IModelBase e : (ICollectionType)prop) {
                if (!(e instanceof IReferenceType)) continue;
                dependencies.add(Reference.createFrom((IReferenceType)e));
            }
        }
        if (self instanceof ReferencableNodeType) {
            DependencyCollector.insertDependencies((ReferencableNodeType)self, dependencies);
        } else if (self instanceof ReferencableAgentType) {
            DependencyCollector.insertDependencies((ReferencableAgentType)self, dependencies);
        }
        if (self.getParent() != null) {
            dependencies.add(Reference.createFrom(self.getParent()));
        }
        return dependencies;
    }

    private static void insertDependencies(ReferencableNodeType node, HashSet<Reference> deps) {
        for (ReferenceType agentRef : node.getAgentRefs()) {
            deps.add(Reference.createFrom(agentRef));
        }
    }

    private static void insertDependencies(ReferencableAgentType agent, HashSet<Reference> deps) {
        for (IModelBase agentElementRef : agent.getAgentElements()) {
            deps.add(Reference.createFrom((IReferenceType)agentElementRef));
        }
    }

    private DependencyCollector() {
    }
}

