/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.ext;

import de.dailab.jiac.common.aamm.ApplicationType;
import de.dailab.jiac.common.aamm.FrameworkType;
import de.dailab.jiac.common.aamm.IModelBase;
import de.dailab.jiac.common.aamm.IMultiFileConfiguration;
import de.dailab.jiac.common.aamm.ISingleFileConfiguration;
import de.dailab.jiac.common.aamm.ReferencableAgentElementType;
import de.dailab.jiac.common.aamm.ReferencableAgentType;
import de.dailab.jiac.common.aamm.ReferencableNodeType;
import de.dailab.jiac.common.aamm.ReferencableObjectType;
import de.dailab.jiac.common.aamm.ext.ArrayListExtension;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class MultiFileConfiguration
implements IMultiFileConfiguration {
    protected final ArrayListExtension<ISingleFileConfiguration> singleFileConfigurations;

    public MultiFileConfiguration(List<ISingleFileConfiguration> singleFiles) throws IllegalArgumentException {
        if (singleFiles.size() <= 0) {
            throw new IllegalArgumentException("at least one configuration must be present");
        }
        this.singleFileConfigurations = new ArrayListExtension();
        for (ISingleFileConfiguration config : singleFiles) {
            this.addSingleFileConfiguration(config);
        }
    }

    @Override
    public void apply(IModelBase.IModelVisitor visitor) {
        this.singleFileConfigurations.apply(visitor);
    }

    @Override
    public List<ReferencableAgentElementType> getAgentElements() {
        return new AbstractDelegatingList<ReferencableAgentElementType>(){

            @Override
            protected List<ReferencableAgentElementType> getTargetList(ISingleFileConfiguration conf) {
                return conf.getAgentElements();
            }
        };
    }

    @Override
    public List<ReferencableAgentType> getAgents() {
        return new AbstractDelegatingList<ReferencableAgentType>(){

            @Override
            protected List<ReferencableAgentType> getTargetList(ISingleFileConfiguration conf) {
                return conf.getAgents();
            }
        };
    }

    @Override
    public ApplicationType getApplication() {
        for (ISingleFileConfiguration config : this.singleFileConfigurations) {
            if (config.getApplication() == null) continue;
            return config.getApplication();
        }
        return null;
    }

    @Override
    public Iterator<ISingleFileConfiguration> iterator() {
        return Collections.unmodifiableList(this.singleFileConfigurations).iterator();
    }

    @Override
    public FrameworkType getFramework() {
        return ((ISingleFileConfiguration)this.singleFileConfigurations.get(0)).getFramework();
    }

    @Override
    public void addSingleFileConfiguration(ISingleFileConfiguration config) throws IllegalArgumentException {
        if (this.singleFileConfigurations.size() <= 0) {
            this.singleFileConfigurations.add(config);
            return;
        }
        ApplicationType app = this.getApplication();
        if (app != null && config.getApplication() != null) {
            StringBuilder error = new StringBuilder();
            error.append("ambigous application definitions in: \n");
            error.append(" * ").append(app.getConfiguration().getFileUrl()).append('\n');
            error.append(" * ").append(config.getFileUrl()).append('\n');
            throw new IllegalArgumentException(error.toString());
        }
        String ns = this.getNamespace();
        if (!ns.equals(config.getNamespace())) {
            throw new IllegalArgumentException("namespace mismatch: " + ns + " vs " + config.getNamespace());
        }
        FrameworkType ft = this.getFramework();
        if (ft != config.getFramework()) {
            throw new IllegalArgumentException("framework mismatch: " + ft.name() + " vs " + config.getFramework().name());
        }
        this.singleFileConfigurations.add(config);
    }

    @Override
    public String getNamespace() {
        return ((ISingleFileConfiguration)this.singleFileConfigurations.get(0)).getNamespace();
    }

    @Override
    public List<ReferencableNodeType> getNodes() {
        return new AbstractDelegatingList<ReferencableNodeType>(){

            @Override
            protected List<ReferencableNodeType> getTargetList(ISingleFileConfiguration conf) {
                return conf.getNodes();
            }
        };
    }

    @Override
    public List<ReferencableObjectType> getObjects() {
        return new AbstractDelegatingList<ReferencableObjectType>(){

            @Override
            protected List<ReferencableObjectType> getTargetList(ISingleFileConfiguration conf) {
                return conf.getObjects();
            }
        };
    }

    private abstract class AbstractDelegatingList<E extends IModelBase>
    extends AbstractCollection<E>
    implements List<E> {
        protected AbstractDelegatingList() {
        }

        @Override
        public final boolean add(E e) {
            if (e == null) {
                throw new IllegalArgumentException("null element");
            }
            ISingleFileConfiguration conf = this.getValidConfiguration(e);
            List<E> target = this.getTargetList(conf);
            if (!target.contains(e)) {
                return target.add(e);
            }
            return false;
        }

        @Override
        public final Iterator<E> iterator() {
            return new Iterator<E>(){
                int index = 0;
                Iterator<E> old;
                Iterator<E> current;

                @Override
                public boolean hasNext() {
                    while (this.current == null || !this.current.hasNext()) {
                        if (this.index >= MultiFileConfiguration.this.singleFileConfigurations.size()) {
                            this.current = null;
                            return false;
                        }
                        ISingleFileConfiguration conf = (ISingleFileConfiguration)MultiFileConfiguration.this.singleFileConfigurations.get(this.index++);
                        this.current = AbstractDelegatingList.this.getTargetList(conf).iterator();
                    }
                    return true;
                }

                @Override
                public E next() {
                    this.old = null;
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.old = this.current;
                    return (IModelBase)this.current.next();
                }

                @Override
                public void remove() {
                    if (this.old == null) {
                        throw new IllegalStateException();
                    }
                    this.old.remove();
                    this.old = null;
                }
            };
        }

        @Override
        public final int size() {
            int size = 0;
            for (ISingleFileConfiguration conf : MultiFileConfiguration.this.singleFileConfigurations) {
                size += this.getTargetList(conf).size();
            }
            return size;
        }

        @Override
        public final E get(int index) {
            List<E> targetList = null;
            for (int l = 0; l < MultiFileConfiguration.this.singleFileConfigurations.size() && index >= 0; index -= targetList.size(), ++l) {
                targetList = this.getTargetList((ISingleFileConfiguration)MultiFileConfiguration.this.singleFileConfigurations.get(l));
            }
            if (targetList == null || index >= 0) {
                throw new IndexOutOfBoundsException("invalid index");
            }
            return (E)((IModelBase)targetList.get(targetList.size() + index));
        }

        @Override
        public final void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int lastIndexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ListIterator<E> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ListIterator<E> listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final List<E> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }

        protected abstract List<E> getTargetList(ISingleFileConfiguration var1);

        private ISingleFileConfiguration getValidConfiguration(E element) {
            ISingleFileConfiguration conf = element.getConfiguration();
            if (conf == null || !MultiFileConfiguration.this.singleFileConfigurations.contains(conf)) {
                throw new IllegalArgumentException("not part of this multi-file configuration");
            }
            return conf;
        }
    }
}

