/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.ext;

import de.dailab.jiac.common.aamm.IReferencableComplexType;
import de.dailab.jiac.common.aamm.IReferenceType;

public class Reference {
    public static final char NAMESPACE_ID_SEPARATOR = '#';
    private static final String REFERENCE_KEY = "#reference#";
    public final String namespace;
    public final String id;

    public static Reference parseReference(String value) {
        return null;
    }

    public static String printReference(Reference ref) {
        return null;
    }

    public static Reference createFor(IReferencableComplexType rct) {
        String namespace = rct.getConfiguration().getNamespace();
        assert (namespace != null);
        return new Reference(namespace, rct.getId());
    }

    public static Reference createFrom(IReferenceType ref) {
        Reference result = (Reference)ref.getMetaData(REFERENCE_KEY);
        if (result == null) {
            String namespace = ref.getNamespace();
            assert (namespace != null);
            if (namespace == null) {
                System.err.println(ref.getLocalIdentifier());
                throw new IllegalArgumentException("the namespace for the reference cannot be determined");
            }
            result = new Reference(namespace, ref.getLocalIdentifier());
            ref.setMetaData(REFERENCE_KEY, result);
        }
        return result;
    }

    public static String createFullQualifiedId(String id, String defaultNamespace) {
        int hashmark = id.indexOf(35);
        if (hashmark >= 0) {
            if (id.lastIndexOf(35) != hashmark) {
                throw new IllegalArgumentException("the specified id '" + id + "' is not valid");
            }
            return id;
        }
        return defaultNamespace + '#' + id;
    }

    public Reference(String namespace, String id) {
        if (namespace == null || id == null) {
            throw new IllegalArgumentException(namespace + " " + id);
        }
        this.namespace = namespace;
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)obj;
        return this.namespace.equals(other.namespace) && this.id.equals(other.id);
    }

    public int hashCode() {
        return this.namespace.hashCode() ^ this.id.hashCode();
    }

    public String toFullQualifiedId() {
        return this.namespace + '#' + this.id;
    }

    public String toJavaIdentifier() {
        String result = this.toFullQualifiedId();
        result = result.replace('.', '_');
        return result.replace('#', '_');
    }

    public String toString() {
        return this.toFullQualifiedId();
    }
}

