/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.ext;

import de.dailab.jiac.common.aamm.ComplexType;
import de.dailab.jiac.common.aamm.ConfigurationType;
import de.dailab.jiac.common.aamm.IModelBase;
import de.dailab.jiac.common.aamm.IReferenceType;
import de.dailab.jiac.common.aamm.ISingleFileConfiguration;
import de.dailab.jiac.common.aamm.ImportType;
import de.dailab.jiac.common.aamm.ObjectFactory;
import de.dailab.jiac.common.aamm.ReferencableAgentElementType;
import de.dailab.jiac.common.aamm.ReferencableAgentType;
import de.dailab.jiac.common.aamm.ReferencableNodeType;
import de.dailab.jiac.common.aamm.ReferencableObjectType;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public final class SingleFileConfiguration
extends ConfigurationType
implements ISingleFileConfiguration {
    public final ComplexType resolve(IReferenceType reference) {
        if (!this.getNamespace().equals(reference.getNamespace())) {
            return null;
        }
        String ref = reference.getLocalIdentifier();
        for (ReferencableAgentType a : this.getAgents()) {
            if (!ref.equals(a.getId())) continue;
            return a;
        }
        for (ReferencableAgentElementType ae : this.getAgentElements()) {
            if (!ref.equals(ae.getId())) continue;
            return ae;
        }
        for (ReferencableNodeType n : this.getNodes()) {
            if (!ref.equals(n.getId())) continue;
            return n;
        }
        for (ReferencableObjectType o : this.getObjects()) {
            if (!ref.equals(o.getId())) continue;
            return o;
        }
        return null;
    }

    public void setConfigurationData(String myNamespace, URL fileUrl) {
        this.setMetaData("model-part-namespace", myNamespace);
        this.setMetaData("model-source-file", fileUrl);
    }

    @Override
    public void prepareProcessing(ObjectFactory factory) {
        this.apply(new IModelBase.IModelVisitor(){

            @Override
            public void visitModel(IModelBase modelPart) {
                if (modelPart instanceof IReferenceType) {
                    IReferenceType ref = (IReferenceType)modelPart;
                    String refStr = ref.getRef();
                    int colon = refStr.indexOf(58);
                    if (colon > 0) {
                        ref.setNamespace(SingleFileConfiguration.this.getNamespaceForAlias(refStr.substring(0, colon)));
                        ref.setLocalIdentifier(refStr.substring(colon + 1));
                    } else {
                        ref.setNamespace(SingleFileConfiguration.this.getNamespace());
                        ref.setLocalIdentifier(refStr);
                    }
                }
                modelPart.setMetaData("model-parent-reference", SingleFileConfiguration.this);
            }
        });
    }

    @Override
    public void prepareMarshalling(ObjectFactory factory) {
        final HashMap<String, String> aliases = new HashMap<String, String>();
        for (ImportType importType : this.getImports()) {
            aliases.put(importType.getNamespace(), importType.getAs());
        }
        this.apply(new IModelBase.IModelVisitor(){

            @Override
            public void visitModel(IModelBase modelPart) {
                if (modelPart instanceof IReferenceType) {
                    IReferenceType ref = (IReferenceType)modelPart;
                    String namespace = ref.getNamespace();
                    String id = ref.getLocalIdentifier();
                    if (SingleFileConfiguration.this.getNamespace().equals(namespace)) {
                        ref.setRef(id);
                    } else {
                        String alias = (String)aliases.get(namespace);
                        if (alias == null) {
                            int point = namespace.lastIndexOf(46);
                            alias = point > 0 ? namespace.substring(point + 1) : namespace;
                            String rawAlias = alias;
                            int suffix = 1;
                            while (aliases.containsValue(alias)) {
                                alias = rawAlias + suffix++;
                            }
                            aliases.put(namespace, alias);
                        }
                        ref.setRef(alias + ':' + id);
                    }
                }
            }
        });
        this.getImports().clear();
        for (Map.Entry entry : aliases.entrySet()) {
            ImportType imp = factory.createImportType();
            imp.setNamespace((String)entry.getKey());
            imp.setAs((String)entry.getValue());
            this.getImports().add(imp);
        }
    }

    @Override
    public URL getFileUrl() {
        URL fu = (URL)this.getMetaData("model-source-file");
        if (fu == null) {
            throw new IllegalStateException("config not initialised");
        }
        return fu;
    }

    @Override
    public String getNamespace() {
        String ns = (String)this.getMetaData("model-part-namespace");
        if (ns == null) {
            throw new IllegalStateException("config not initialised");
        }
        return ns;
    }

    @Override
    public ISingleFileConfiguration getConfiguration() {
        return this;
    }

    protected String getNamespaceForAlias(String alias) {
        for (ImportType it : this.getImports()) {
            if (!it.getAs().equals(alias) || it.getNamespace() == null) continue;
            return it.getNamespace();
        }
        throw new IllegalArgumentException("unknown alias: '" + alias + "'");
    }
}

