/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.resolve;

import de.dailab.jiac.common.aamm.IConfiguration;
import de.dailab.jiac.common.aamm.IReferencableComplexType;
import de.dailab.jiac.common.aamm.IReferenceType;
import de.dailab.jiac.common.aamm.ext.ModelVisitorAdapter;
import de.dailab.jiac.common.aamm.ext.Reference;
import de.dailab.jiac.common.aamm.ext.SingleFileConfiguration;
import de.dailab.jiac.common.aamm.resolve.ResolutionException;
import java.util.HashMap;
import java.util.HashSet;

public final class ConfigurationProcessor {
    public final HashMap<Reference, IReferencableComplexType> referencables = new HashMap();
    public final HashMap<Reference, HashSet<Reference>> dependencies = new HashMap();
    private final ModelVisitor _visitor = new ModelVisitor();

    public void processConfiguration(IConfiguration configuration) throws ResolutionException {
        configuration.apply(this._visitor);
        if (this._visitor.errorMessage.length() > 0) {
            try {
                throw new ResolutionException(this._visitor.errorMessage.toString());
            }
            catch (Throwable throwable) {
                this._visitor.errorMessage.setLength(0);
                throw throwable;
            }
        }
    }

    private final class ModelVisitor
    extends ModelVisitorAdapter {
        protected final StringBuffer errorMessage = new StringBuffer();
        private Reference _currentReferencable;

        protected ModelVisitor() {
        }

        @Override
        protected void visitSingleFileConfiguration(SingleFileConfiguration configuration) {
            this._currentReferencable = null;
        }

        @Override
        protected void visitReferencableComplexType(IReferencableComplexType rct) {
            this._currentReferencable = Reference.createFor(rct);
            if (ConfigurationProcessor.this.referencables.containsKey(this._currentReferencable)) {
                IReferencableComplexType old = ConfigurationProcessor.this.referencables.get(this._currentReferencable);
                if (old != rct) {
                    this.errorMessage.append("id '").append(this._currentReferencable.id).append("' is ambigous: ");
                    this.errorMessage.append(System.getProperty("line.separator")).append("  ");
                    this.errorMessage.append(old.getConfiguration().getFileUrl());
                    this.errorMessage.append(System.getProperty("line.separator")).append("  ");
                    this.errorMessage.append(rct.getConfiguration().getFileUrl());
                    this.errorMessage.append(System.getProperty("line.separator"));
                }
            } else {
                ConfigurationProcessor.this.referencables.put(this._currentReferencable, rct);
            }
        }

        @Override
        protected void visitReference(IReferenceType ref) {
            Reference r = Reference.createFrom(ref);
            if (this._currentReferencable != null) {
                HashSet<Reference> deps = ConfigurationProcessor.this.dependencies.get(this._currentReferencable);
                if (deps == null) {
                    deps = new HashSet();
                    ConfigurationProcessor.this.dependencies.put(this._currentReferencable, deps);
                }
                deps.add(r);
            }
        }
    }
}

