/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.resolve;

import de.dailab.jiac.common.aamm.ComplexType;
import de.dailab.jiac.common.aamm.IModelBase;
import de.dailab.jiac.common.aamm.IReferencableComplexType;
import de.dailab.jiac.common.aamm.IReferenceType;
import de.dailab.jiac.common.aamm.ReferencableAgentElementType;
import de.dailab.jiac.common.aamm.ReferencableAgentType;
import de.dailab.jiac.common.aamm.ReferencableNodeType;
import de.dailab.jiac.common.aamm.ReferencableObjectType;
import de.dailab.jiac.common.aamm.ReferenceType;
import de.dailab.jiac.common.aamm.ext.Reference;
import de.dailab.jiac.common.aamm.resolve.ResolutionException;
import java.util.HashMap;

public class MergedConfiguration {
    public final HashMap<Reference, IReferencableComplexType> cache;
    public final Reference[] nodesToUse;
    public final Reference[] agentsToUse;

    public MergedConfiguration(Reference[] nodesToUse, Reference[] agentsToUse, HashMap<Reference, IReferencableComplexType> cache) {
        this.nodesToUse = nodesToUse;
        this.agentsToUse = agentsToUse;
        this.cache = cache;
    }

    public ReferencableAgentType getAgent(ReferenceType ref) throws ResolutionException {
        return this.getReferencableOfType(ReferencableAgentType.class, ref);
    }

    public ReferencableAgentType getAgent(Reference reference) throws ResolutionException {
        return this.getReferencableOfType(ReferencableAgentType.class, reference);
    }

    public ReferencableAgentElementType getAgentElement(IModelBase ref) throws ResolutionException {
        return this.getReferencableOfType(ReferencableAgentElementType.class, (IReferenceType)ref);
    }

    public ReferencableNodeType getNode(ReferenceType ref) throws ResolutionException {
        return this.getReferencableOfType(ReferencableNodeType.class, ref);
    }

    public ReferencableNodeType getNode(Reference reference) throws ResolutionException {
        return this.getReferencableOfType(ReferencableNodeType.class, reference);
    }

    public ReferencableObjectType getObject(IModelBase ref) throws ResolutionException {
        return this.getReferencableOfType(ReferencableObjectType.class, (IReferenceType)ref);
    }

    private <R extends ComplexType> R getReferencableOfType(Class<R> type, IReferenceType ref) throws ResolutionException {
        Reference reference = Reference.createFrom(ref);
        return this.getReferencableOfType(type, reference);
    }

    private <R extends ComplexType> R getReferencableOfType(Class<R> type, Reference reference) throws ResolutionException {
        IReferencableComplexType target = this.cache.get(reference);
        if (!type.isInstance(target)) {
            StringBuilder error = new StringBuilder();
            error.append("Reference '").append(reference.toFullQualifiedId());
            error.append("' resolves to invalid type: expected '").append(type);
            error.append("' but got '").append(target.getClass()).append("'!");
            throw new ResolutionException(error.toString());
        }
        return (R)((ComplexType)type.cast(target));
    }
}

