/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.resolve;

import de.dailab.jiac.common.aamm.ApplicationType;
import de.dailab.jiac.common.aamm.IConfiguration;
import de.dailab.jiac.common.aamm.IReferencableComplexType;
import de.dailab.jiac.common.aamm.ReferencableNodeType;
import de.dailab.jiac.common.aamm.ReferenceType;
import de.dailab.jiac.common.aamm.ext.Reference;
import de.dailab.jiac.common.aamm.resolve.ConfigurationProcessor;
import de.dailab.jiac.common.aamm.resolve.MergedConfiguration;
import de.dailab.jiac.common.aamm.resolve.ResolutionException;
import de.dailab.jiac.common.aamm.tools.CheckerToolContext;
import de.dailab.jiac.common.aamm.tools.DefinitionFlattener;
import de.dailab.jiac.common.aamm.tools.MetaModelException;
import de.dailab.jiac.common.aamm.tools.MetaModelReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class Resolver {
    private final CheckerToolContext _context;

    public Resolver(CheckerToolContext context) {
        this._context = context;
    }

    public MergedConfiguration resolveAndMerge(String namespace) throws MetaModelException, ResolutionException {
        ResolutionProcessContext process = new ResolutionProcessContext();
        try {
            this.collect(process, namespace);
        }
        catch (MetaModelException mme) {
            System.err.println("error after processing: " + process.namespaces);
            throw mme;
        }
        Reference[] nodesToUse = process.nodesToUse.toArray(new Reference[process.nodesToUse.size()]);
        Reference[] agentsToUse = process.agentsToUse.toArray(new Reference[process.agentsToUse.size()]);
        return new MergedConfiguration(nodesToUse, agentsToUse, process.referencables);
    }

    private void collect(ResolutionProcessContext process, String initialNamespace) throws MetaModelException, ResolutionException {
        MetaModelReader reader = this._context.createReader();
        DefinitionFlattener flattener = this._context.createDefinitionFlattener();
        ConfigurationProcessor processor = new ConfigurationProcessor();
        process.namespaces.add(initialNamespace);
        IConfiguration initialConfiguration = reader.read(this._context.getLoader(), initialNamespace);
        flattener.flatten(initialConfiguration);
        processor.processConfiguration(initialConfiguration);
        HashSet<Reference> initialChain = new HashSet<Reference>();
        if (initialConfiguration.getApplication() == null) {
            for (ReferencableNodeType node : initialConfiguration.getNodes()) {
                Reference reference = Reference.createFor(node);
                process.nodesToUse.add(reference);
                initialChain.add(reference);
                initialChain.addAll((Collection)processor.dependencies.get(reference));
            }
        } else {
            ApplicationType app = initialConfiguration.getApplication();
            for (ReferenceType ref : app.getNodeRefs()) {
                Reference reference = Reference.createFrom(ref);
                process.nodesToUse.add(reference);
                initialChain.add(reference);
                ReferencableNodeType node = (ReferencableNodeType)processor.referencables.get(reference);
                if (node == null) continue;
                initialChain.addAll((Collection)processor.dependencies.get(reference));
            }
        }
        StringBuilder error = new StringBuilder();
        process.toResolve.addAll(initialChain);
        while (process.toResolve.size() > 0) {
            Reference ref = process.toResolve.get(0);
            if (process.resolved.contains(ref)) {
                process.toResolve.remove(0);
                continue;
            }
            String ns = ref.namespace;
            if (!process.namespaces.contains(ns)) {
                IConfiguration newConf = reader.read(this._context.getLoader(), ns);
                flattener.flatten(newConf);
                process.namespaces.add(ns);
                processor.processConfiguration(newConf);
            }
            if (!processor.referencables.containsKey(ref)) {
                if (error.length() > 0) {
                    error.append(',');
                }
                error.append(ref.toFullQualifiedId());
            } else {
                HashSet<Reference> nc;
                if (process.nodesToUse.contains(ref)) {
                    try {
                        ReferencableNodeType node = (ReferencableNodeType)processor.referencables.get(ref);
                        for (ReferenceType agent : node.getAgentRefs()) {
                            process.agentsToUse.add(Reference.createFrom(agent));
                        }
                    }
                    catch (ClassCastException cce) {
                        error.append(ref.toFullQualifiedId());
                    }
                }
                if ((nc = processor.dependencies.get(ref)) != null) {
                    for (Reference nr : nc) {
                        if (process.resolved.contains(ref) || process.toResolve.contains(nr)) continue;
                        process.toResolve.add(nr);
                    }
                }
            }
            process.resolved.add(process.toResolve.remove(0));
        }
        if (error.length() > 0) {
            System.err.println(processor.referencables.keySet());
            error.insert(0, "could not resolve the following references: ");
            throw new ResolutionException(error.toString());
        }
        process.referencables = processor.referencables;
    }

    private static class ResolutionProcessContext {
        HashSet<Reference> nodesToUse = new HashSet();
        HashSet<Reference> agentsToUse = new HashSet();
        HashSet<String> namespaces = new HashSet();
        ArrayList<Reference> toResolve = new ArrayList();
        HashSet<Reference> resolved = new HashSet();
        HashMap<Reference, IReferencableComplexType> referencables;

        ResolutionProcessContext() {
        }
    }
}

