/*
 * Decompiled with CFR 0.152.
 */
package de.dailab.jiac.common.aamm.tools;

import de.dailab.jiac.common.aamm.AgentElementType;
import de.dailab.jiac.common.aamm.ListPropertyType;
import de.dailab.jiac.common.aamm.MapPropertyType;
import de.dailab.jiac.common.aamm.ObjectEntryType;
import de.dailab.jiac.common.aamm.ObjectFactory;
import de.dailab.jiac.common.aamm.ObjectItemType;
import de.dailab.jiac.common.aamm.ObjectPropertyType;
import de.dailab.jiac.common.aamm.RefEntryType;
import de.dailab.jiac.common.aamm.RefItemType;
import de.dailab.jiac.common.aamm.ReferencableAgentElementType;
import de.dailab.jiac.common.aamm.ReferencableAgentType;
import de.dailab.jiac.common.aamm.ReferencableNodeType;
import de.dailab.jiac.common.aamm.ReferencableObjectType;
import de.dailab.jiac.common.aamm.ReferencePropertyType;
import de.dailab.jiac.common.aamm.ReferenceType;
import de.dailab.jiac.common.aamm.SimplePropertyType;
import de.dailab.jiac.common.aamm.ValueEntryType;
import de.dailab.jiac.common.aamm.ValueItemType;
import java.util.HashMap;

public final class AdaptableObjectFactory
extends ObjectFactory {
    private final String _implPackage;
    private final HashMap<Class<?>, Class<?>> _implClasses;

    AdaptableObjectFactory(String implPackage) {
        this._implPackage = implPackage;
        this._implClasses = new HashMap();
    }

    @Override
    public AgentElementType createAgentElementType() {
        return this.create(AgentElementType.class);
    }

    @Override
    public ObjectPropertyType createObjectPropertyType() {
        return this.create(ObjectPropertyType.class);
    }

    @Override
    public ListPropertyType createListPropertyType() {
        return this.create(ListPropertyType.class);
    }

    @Override
    public MapPropertyType createMapPropertyType() {
        return this.create(MapPropertyType.class);
    }

    @Override
    public ObjectEntryType createObjectEntryType() {
        return this.create(ObjectEntryType.class);
    }

    @Override
    public ObjectItemType createObjectItemType() {
        return this.create(ObjectItemType.class);
    }

    @Override
    public RefEntryType createRefEntryType() {
        return this.create(RefEntryType.class);
    }

    @Override
    public ReferencableAgentElementType createReferencableAgentElementType() {
        return this.create(ReferencableAgentElementType.class);
    }

    @Override
    public ReferencableAgentType createReferencableAgentType() {
        return this.create(ReferencableAgentType.class);
    }

    @Override
    public ReferencableNodeType createReferencableNodeType() {
        return this.create(ReferencableNodeType.class);
    }

    @Override
    public ReferencableObjectType createReferencableObjectType() {
        return this.create(ReferencableObjectType.class);
    }

    @Override
    public ReferencePropertyType createReferencePropertyType() {
        return this.create(ReferencePropertyType.class);
    }

    @Override
    public ReferenceType createReferenceType() {
        return this.create(ReferenceType.class);
    }

    @Override
    public RefItemType createRefItemType() {
        return this.create(RefItemType.class);
    }

    @Override
    public SimplePropertyType createSimplePropertyType() {
        return this.create(SimplePropertyType.class);
    }

    @Override
    public ValueEntryType createValueEntryType() {
        return this.create(ValueEntryType.class);
    }

    @Override
    public ValueItemType createValueItemType() {
        return this.create(ValueItemType.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T create(Class<T> type) {
        if (!this._implClasses.containsKey(type)) {
            String typeName = type.getName();
            StringBuilder implName = new StringBuilder();
            implName.append(this._implPackage).append('.').append(typeName.substring(typeName.lastIndexOf(46) + 1)).append("Impl");
            Class<?> implType = null;
            try {
                implType = this.getClass().getClassLoader().loadClass(implName.toString());
                T t = type.cast(implType.newInstance());
                return t;
            }
            catch (Exception e) {
                implType = null;
            }
            finally {
                this._implClasses.put(type, implType);
            }
        } else {
            Class<?> implType = this._implClasses.get(type);
            if (implType != null) {
                try {
                    return type.cast(implType.newInstance());
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

